/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.labelfield;

import java.lang.reflect.Method;
import org.eclipse.scout.commons.internal.runtime.CompatibilityUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.labelfield.ILabelField;
import org.eclipse.scout.rt.ui.swt.LogicalGridData;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutValueFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.labelfield.ISwtScoutLabelField;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SwtScoutLabelField
extends SwtScoutValueFieldComposite<ILabelField>
implements ISwtScoutLabelField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutLabelField.class);

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getEnvironment().getFormToolkit().createStatusLabel(container, this.getEnvironment(), (IFormField)this.getScoutObject());
        int style = 0;
        if (((ILabelField)this.getScoutObject()).isWrapText()) {
            style |= 0x40;
        }
        StyledText text = this.getEnvironment().getFormToolkit().createStyledText(container, style |= 2);
        text.setBackground(container.getBackground());
        text.setEditable(false);
        if (!CompatibilityUtility.isEclipseVersionLessThan35()) {
            try {
                Method setWrapIndent = StyledText.class.getMethod("setWrapIndent", Integer.TYPE);
                setWrapIndent.invoke((Object)text, text.getIndent());
                int borderWidth = 4;
                Method setMargins = StyledText.class.getMethod("setMargins", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                setMargins.invoke((Object)text, 0, borderWidth, 0, borderWidth);
            }
            catch (Exception e) {
                LOG.warn("could not access methods 'setWrapIndent' or 'setMargins' on 'StyledText'.", (Throwable)e);
            }
        }
        LogicalGridData textData = LogicalGridDataBuilder.createField(((IFormField)this.getScoutObject()).getGridData());
        text.setLayoutData((Object)textData);
        container.setTabList(new Control[0]);
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setSwtField((Control)text);
        this.getSwtContainer().setLayout((Layout)new LogicalGridLayout(1, 0));
    }

    public StyledText getSwtField() {
        return (StyledText)super.getSwtField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setTextWrapFromScout(((ILabelField)this.getScoutObject()).isWrapText());
        this.setSelectableFromScout(((ILabelField)this.getScoutObject()).isSelectable());
    }

    @Override
    protected void setDisplayTextFromScout(String s) {
        String oldText = this.getSwtField().getText();
        if (s == null) {
            s = "";
        }
        if (oldText == null) {
            oldText = "";
        }
        if (oldText.equals(s)) {
            return;
        }
        this.getSwtField().setText(s);
        this.getSwtContainer().layout(true, true);
    }

    protected void setTextWrapFromScout(boolean booleanValue) {
    }

    protected void setSelectableFromScout(boolean booleanValue) {
        this.getSwtField().setEnabled(booleanValue);
    }

    @Override
    protected void setFieldEnabled(Control swtField, boolean enabled) {
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if ("wrapText".equals(name)) {
            this.setTextWrapFromScout(((ILabelField)this.getScoutObject()).isWrapText());
        } else if ("selectable".equals(name)) {
            this.setSelectableFromScout(((ILabelField)this.getScoutObject()).isSelectable());
        }
    }
}

