/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.sequencebox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.form.fields.ICompositeField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValueField;
import org.eclipse.scout.rt.client.ui.form.fields.booleanfield.IBooleanField;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.ui.swt.LogicalGridData;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.swt.ext.StatusLabelEx;
import org.eclipse.scout.rt.ui.swt.form.fields.ISwtScoutFormField;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFormFieldGridData;
import org.eclipse.scout.rt.ui.swt.form.fields.checkbox.ISwtScoutCheckbox;
import org.eclipse.scout.rt.ui.swt.form.fields.sequencebox.ISwtScoutSequenceBox;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SwtScoutSequenceBox
extends SwtScoutFieldComposite<ISequenceBox>
implements ISwtScoutSequenceBox {
    private PropertyChangeListener m_scoutMandatoryChangeListener;
    private PropertyChangeListener m_scoutErrorStatusChangeListener;

    @Override
    protected void initializeSwt(Composite parent) {
        Composite container = this.getEnvironment().getFormToolkit().createComposite(parent);
        StatusLabelEx label = this.getEnvironment().getFormToolkit().createStatusLabel(container, this.getEnvironment(), (IFormField)this.getScoutObject());
        Composite fieldContainer = this.getEnvironment().getFormToolkit().createComposite(container);
        int visibleCount = 0;
        for (IFormField scoutField : this.getScoutObject().getFields()) {
            ISwtScoutFormField swtFormField = this.getEnvironment().createFormField(fieldContainer, scoutField);
            ILabelComposite childLabel = null;
            childLabel = swtFormField instanceof ISwtScoutCheckbox ? ((ISwtScoutCheckbox)swtFormField).getPlaceholderLabel() : swtFormField.getSwtLabel();
            if (childLabel != null && childLabel.getLayoutData() instanceof LogicalGridData) {
                ((LogicalGridData)childLabel.getLayoutData()).widthHint = 0;
                if (this.removeLabelCompletely(swtFormField)) {
                    childLabel.setVisible(false);
                }
                if (swtFormField.getScoutObject() instanceof IFormField) {
                    IFormField childScoutField = (IFormField)swtFormField.getScoutObject();
                    if (childScoutField.isVisible()) {
                        ++visibleCount;
                    }
                    if (visibleCount > 1 && !childLabel.getVisible()) {
                        childLabel.setVisible(true);
                        childLabel.setText("");
                    }
                }
            }
            SwtScoutFormFieldGridData data = new SwtScoutFormFieldGridData(scoutField){

                @Override
                public void validate() {
                    super.validate();
                    this.useUiWidth = !SwtScoutSequenceBox.this.getScoutObject().isEqualColumnWidths();
                    this.useUiHeight = true;
                }
            };
            swtFormField.getSwtContainer().setLayoutData((Object)data);
        }
        this.setSwtContainer(container);
        this.setSwtLabel(label);
        this.setSwtField((Control)fieldContainer);
        fieldContainer.setLayout((Layout)new LogicalGridLayout(this.getGridColumnGapInPixel(), 0));
        container.setLayout((Layout)new LogicalGridLayout(1, 0));
    }

    protected int getGridColumnGapInPixel() {
        return 6;
    }

    private boolean removeLabelCompletely(ISwtScoutFormField swtScoutFormField) {
        if (swtScoutFormField == null) {
            return false;
        }
        if (!(swtScoutFormField.getScoutObject() instanceof IFormField)) {
            return false;
        }
        IFormField formField = (IFormField)swtScoutFormField.getScoutObject();
        if (formField.getLabelPosition() == 2) {
            return true;
        }
        return formField instanceof IBooleanField;
    }

    public Composite getSwtField() {
        return (Composite)super.getSwtField();
    }

    @Override
    public ISequenceBox getScoutObject() {
        return (ISequenceBox)super.getScoutObject();
    }

    protected void setChildMandatoryFromScout() {
        boolean inheritedMandatory = false;
        List<IValueField<?>> visibleFields = this.findVisibleValueFields((ICompositeField)this.getScoutObject());
        for (IValueField<?> field : visibleFields) {
            if (!field.isMandatory()) continue;
            inheritedMandatory = true;
            break;
        }
        this.setMandatoryFromScout(inheritedMandatory);
    }

    protected void setChildErrorStatusFromScout() {
        IProcessingStatus inheritedErrorStatus = null;
        List<IValueField<?>> visibleFields = this.findVisibleValueFields((ICompositeField)this.getScoutObject());
        if (visibleFields.size() > 0) {
            inheritedErrorStatus = visibleFields.get(0).getErrorStatus();
        }
        this.setErrorStatusFromScout(inheritedErrorStatus);
    }

    protected List<IValueField<?>> findVisibleValueFields(ICompositeField parent) {
        LinkedList valueFields = new LinkedList();
        for (IFormField field : parent.getFields()) {
            if (!field.isVisible()) continue;
            if (field instanceof IValueField) {
                valueFields.add((IValueField)field);
                continue;
            }
            if (!(field instanceof ICompositeField)) continue;
            valueFields.addAll(this.findVisibleValueFields((ICompositeField)field));
        }
        return valueFields;
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
        if (this.getSwtLabel() != null && this.getSwtLabel().getEnabled() != b) {
            this.getSwtLabel().setEnabled(b);
        }
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.m_scoutMandatoryChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Runnable j = new Runnable(){

                    @Override
                    public void run() {
                        if (SwtScoutSequenceBox.this.getSwtContainer() != null && !SwtScoutSequenceBox.this.getSwtContainer().isDisposed()) {
                            SwtScoutSequenceBox.this.setChildMandatoryFromScout();
                        }
                    }
                };
                SwtScoutSequenceBox.this.getEnvironment().invokeSwtLater(j);
            }
        };
        for (IFormField f : this.getScoutObject().getFields()) {
            f.addPropertyChangeListener("mandatory", this.m_scoutMandatoryChangeListener);
        }
        this.m_scoutErrorStatusChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Runnable j = new Runnable(){

                    @Override
                    public void run() {
                        SwtScoutSequenceBox.this.setChildErrorStatusFromScout();
                    }
                };
                SwtScoutSequenceBox.this.getEnvironment().invokeSwtLater(j);
            }
        };
        for (IFormField f : this.getScoutObject().getFields()) {
            f.addPropertyChangeListener("errorStatus", this.m_scoutErrorStatusChangeListener);
        }
        this.setChildMandatoryFromScout();
    }

    @Override
    protected void detachScout() {
        if (this.m_scoutMandatoryChangeListener != null) {
            for (IFormField f : this.getScoutObject().getFields()) {
                f.removePropertyChangeListener("mandatory", this.m_scoutMandatoryChangeListener);
            }
            this.m_scoutMandatoryChangeListener = null;
        }
        if (this.m_scoutErrorStatusChangeListener != null) {
            for (IFormField f : this.getScoutObject().getFields()) {
                f.removePropertyChangeListener("errorStatus", this.m_scoutErrorStatusChangeListener);
            }
            this.m_scoutErrorStatusChangeListener = null;
        }
        super.detachScout();
    }
}

