/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields.tabbox;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.RunnableWithData;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;
import org.eclipse.scout.rt.ui.swt.form.fields.SwtScoutFieldComposite;
import org.eclipse.scout.rt.ui.swt.form.fields.tabbox.ISwtScoutTabBox;
import org.eclipse.scout.rt.ui.swt.form.fields.tabbox.SwtScoutTabItem;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SwtScoutTabBox
extends SwtScoutFieldComposite<ITabBox>
implements ISwtScoutTabBox {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutTabBox.class);
    private HashMap<CTabItem, SwtScoutTabItem> m_tabs;
    private HashMap<IGroupBox, SwtScoutTabItem> m_scoutTabMapping;
    private Listener m_uiTabFocusListener;
    private P_TabListener m_tabListener = new P_TabListener();
    private OptimisticLock m_selectedTabLock = new OptimisticLock();

    @Override
    protected void initializeSwt(Composite parent) {
        CTabFolder tabFolder = this.getEnvironment().getFormToolkit().createTabFolder(parent);
        tabFolder.marginHeight = 8;
        this.setSwtLabel(null);
        this.setSwtField((Control)tabFolder);
        this.setSwtContainer((Composite)tabFolder);
        for (IGroupBox box : this.getScoutObject().getGroupBoxes()) {
            box.addPropertyChangeListener((PropertyChangeListener)this.m_tabListener);
        }
        this.buildItems();
        if (this.m_uiTabFocusListener == null) {
            this.m_uiTabFocusListener = new P_SwtFocusListener();
        }
        tabFolder.addListener(13, this.m_uiTabFocusListener);
        tabFolder.addListener(15, this.m_uiTabFocusListener);
        tabFolder.addListener(16, this.m_uiTabFocusListener);
        this.getSwtContainer().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SwtScoutTabBox.this.m_scoutTabMapping != null) {
                    IGroupBox selectedGroupBox = SwtScoutTabBox.this.getScoutObject().getSelectedTab();
                    IGroupBox[] groupBoxes = SwtScoutTabBox.this.getScoutObject().getGroupBoxes().toArray(new IGroupBox[SwtScoutTabBox.this.getScoutObject().getGroupBoxes().size()]);
                    int i = groupBoxes.length - 1;
                    while (i >= 0) {
                        IGroupBox groupBox = groupBoxes[i];
                        if (groupBox != selectedGroupBox) {
                            this.disposeGroupBoxWithTabs(groupBox);
                        }
                        --i;
                    }
                    if (selectedGroupBox != null) {
                        this.disposeGroupBoxWithTabs(selectedGroupBox);
                    }
                    SwtScoutTabBox.this.m_scoutTabMapping = null;
                    SwtScoutTabBox.this.m_tabs = null;
                }
            }

            private void disposeGroupBoxWithTabs(IGroupBox groupBox) {
                SwtScoutTabItem swtScoutTabItem = (SwtScoutTabItem)SwtScoutTabBox.this.m_scoutTabMapping.remove(groupBox);
                if (swtScoutTabItem != null) {
                    SwtScoutTabBox.this.m_tabs.remove(swtScoutTabItem.getTabItem());
                    swtScoutTabItem.getTabItem().dispose();
                    swtScoutTabItem.dispose();
                }
            }
        });
    }

    protected void buildItems() {
        try {
            this.getSwtContainer().setRedraw(false);
            this.m_tabs = new HashMap();
            this.m_scoutTabMapping = new HashMap();
            for (IGroupBox box : this.getScoutObject().getGroupBoxes()) {
                if (!box.isVisible()) continue;
                SwtScoutTabItem item = new SwtScoutTabItem();
                item.createField((Composite)this.getSwtField(), box, this.getEnvironment());
                this.m_tabs.put(item.getTabItem(), item);
                this.m_scoutTabMapping.put(box, item);
            }
            SwtScoutTabItem selectedTabItem = this.getTabItem(this.getScoutObject().getSelectedTab());
            if (selectedTabItem != null) {
                this.getSwtField().setSelection(selectedTabItem.getTabItem());
            }
        }
        finally {
            this.getSwtContainer().setRedraw(true);
        }
    }

    @Override
    public ITabBox getScoutObject() {
        return (ITabBox)super.getScoutObject();
    }

    public CTabFolder getSwtField() {
        return (CTabFolder)super.getSwtField();
    }

    @Override
    protected void attachScout() {
        super.attachScout();
        this.setSelectedTabFromScout();
    }

    @Override
    protected void detachScout() {
        for (IGroupBox b : this.getScoutObject().getGroupBoxes()) {
            b.removePropertyChangeListener((PropertyChangeListener)this.m_tabListener);
        }
        super.detachScout();
    }

    @Override
    protected void setEnabledFromScout(boolean b) {
    }

    protected void setSelectedTabFromSwt() {
        try {
            IGroupBox box;
            CTabItem comp;
            SwtScoutTabItem tabComposite;
            if (this.m_selectedTabLock.acquire() && (tabComposite = this.m_tabs.get(comp = this.getSwtField().getSelection())) != null && (box = (IGroupBox)tabComposite.getScoutObject()) != null) {
                Runnable j = new Runnable(){

                    @Override
                    public void run() {
                        SwtScoutTabBox.this.getScoutObject().getUIFacade().setSelectedTabFromUI(box);
                    }
                };
                this.getEnvironment().invokeScoutLater(j, 0L);
            }
        }
        finally {
            this.m_selectedTabLock.release();
        }
    }

    protected void setSelectedTabFromScout() {
        try {
            this.m_selectedTabLock.acquire();
            IGroupBox selectedTab = this.getScoutObject().getSelectedTab();
            SwtScoutTabItem swtScoutTabItem = this.m_scoutTabMapping.get(selectedTab);
            if (swtScoutTabItem == null) {
                return;
            }
            CTabItem foundItem = swtScoutTabItem.getTabItem();
            if (foundItem != null) {
                this.getSwtField().setSelection(foundItem);
            }
        }
        finally {
            this.m_selectedTabLock.release();
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("selectedTab")) {
            this.setSelectedTabFromScout();
        }
    }

    private void showGroupBox(IGroupBox groupBox) {
        try {
            this.getSwtContainer().setRedraw(false);
            SwtScoutTabItem item = this.getTabItem(groupBox);
            if (item == null || item.isDisposed()) {
                item = new SwtScoutTabItem();
                item.createField((Composite)this.getSwtField(), groupBox, this.getEnvironment());
                this.m_tabs.put(item.getTabItem(), item);
                this.m_scoutTabMapping.put(groupBox, item);
            }
        }
        finally {
            this.getSwtContainer().setRedraw(true);
        }
    }

    private void hideGroupBox(IGroupBox groupBox) {
        try {
            this.getSwtContainer().setRedraw(false);
            SwtScoutTabItem item = this.getTabItem(groupBox);
            this.m_tabs.remove(item.getTabItem());
            this.m_scoutTabMapping.remove(groupBox);
            if (item != null && item.isInitialized() && !item.isDisposed()) {
                item.getTabItem().dispose();
                item.dispose();
            }
        }
        finally {
            this.getSwtContainer().setRedraw(true);
        }
    }

    private SwtScoutTabItem getTabItem(IGroupBox groupBox) {
        if (groupBox == null) {
            return null;
        }
        return this.m_scoutTabMapping.get(groupBox);
    }

    private class P_SwtFocusListener
    implements Listener {
        private SwtScoutTabItem m_focusedItem;

        private P_SwtFocusListener() {
        }

        public void handleEvent(Event event) {
            SwtScoutTabItem item = (SwtScoutTabItem)SwtScoutTabBox.this.m_tabs.get(SwtScoutTabBox.this.getSwtField().getSelection());
            switch (event.type) {
                case 13: {
                    SwtScoutTabBox.this.setSelectedTabFromSwt();
                    if (this.m_focusedItem == item) {
                        return;
                    }
                    if (this.m_focusedItem != null) {
                        this.m_focusedItem.setUiFocus(false);
                    }
                    this.m_focusedItem = item;
                    this.m_focusedItem.setUiFocus(true);
                    break;
                }
                case 16: {
                    if (this.m_focusedItem == null) break;
                    this.m_focusedItem.setUiFocus(false);
                    this.m_focusedItem = null;
                    break;
                }
                case 15: {
                    if (this.m_focusedItem != null) {
                        this.m_focusedItem.setUiFocus(false);
                    }
                    this.m_focusedItem = item;
                    if (this.m_focusedItem == null) break;
                    this.m_focusedItem.setUiFocus(true);
                    break;
                }
            }
        }
    }

    private class P_TabListener
    implements PropertyChangeListener {
        private P_TabListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("visible")) {
                RunnableWithData t = new RunnableWithData(){

                    public void run() {
                        IGroupBox groupBox = (IGroupBox)evt.getSource();
                        if (groupBox.isVisible()) {
                            SwtScoutTabBox.this.showGroupBox(groupBox);
                        } else {
                            SwtScoutTabBox.this.hideGroupBox(groupBox);
                        }
                    }
                };
                SwtScoutTabBox.this.getEnvironment().invokeSwtLater((Runnable)t);
            }
        }
    }
}

