/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.jdt.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.dialog.IMemberSelectionChangedListener;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.IPropertyBean;
import org.eclipse.swt.widgets.Shell;

public class PropertyBeanDeleteAction
extends AbstractScoutHandler {
    private MemberSelectionDialog m_confirmDialog;
    private IPropertyBean m_beanDesc;

    public PropertyBeanDeleteAction() {
        super(Texts.get((String)"DeleteWithPopup"), ScoutSdkUi.getImageDescriptor("variable_remove.png"), "Delete", false, IScoutHandler.Category.DELETE);
    }

    @Override
    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        this.m_confirmDialog = new MemberSelectionDialog(shell, this.getLabel());
        this.m_confirmDialog.addMemberSelectionListener(new P_SelectionValidationListener());
        ArrayList<IMember> members = new ArrayList<IMember>();
        ArrayList<IMember> selectedMembers = new ArrayList<IMember>();
        this.collectAffectedMembers(members, selectedMembers);
        this.m_confirmDialog.setMembers(members.toArray(new IMember[members.size()]));
        this.m_confirmDialog.setSelectedMembers(selectedMembers.toArray(new IMember[selectedMembers.size()]));
        if (this.m_confirmDialog.open() == 0) {
            JavaElementDeleteOperation op = new JavaElementDeleteOperation();
            op.setMembers((IJavaElement[])this.m_confirmDialog.getSelectedMembers());
            OperationJob job = new OperationJob(new IOperation[]{op});
            job.schedule();
        }
        return null;
    }

    protected void collectAffectedMembers(List<IMember> members, List<IMember> selectedMembers) {
        IMember[] beanMembers = this.getBeanDesc().getAllMembers();
        members.addAll(Arrays.asList(beanMembers));
        selectedMembers.addAll(Arrays.asList(beanMembers));
    }

    public IPropertyBean getBeanDesc() {
        return this.m_beanDesc;
    }

    @Override
    public boolean isVisible() {
        return this.m_beanDesc != null && this.isEditable((IJavaElement)this.m_beanDesc.getDeclaringType());
    }

    public void setBeanDesc(IPropertyBean beanDesc) {
        this.m_beanDesc = beanDesc;
    }

    private class P_SelectionValidationListener
    implements IMemberSelectionChangedListener {
        private P_SelectionValidationListener() {
        }

        @Override
        public void handleSelectionChanged(IMember[] selection) {
            PropertyBeanDeleteAction.this.m_confirmDialog.setMessage("");
            boolean canOk = true;
            if (selection == null || selection.length == 0) {
                canOk = false;
            } else {
                HashSet<IMember> members = new HashSet<IMember>(Arrays.asList(selection));
                if (members.contains(PropertyBeanDeleteAction.this.getBeanDesc().getField()) && (PropertyBeanDeleteAction.this.getBeanDesc().getReadMethod() != null && !members.contains(PropertyBeanDeleteAction.this.getBeanDesc().getReadMethod()) || PropertyBeanDeleteAction.this.getBeanDesc().getWriteMethod() != null && !members.contains(PropertyBeanDeleteAction.this.getBeanDesc().getWriteMethod()))) {
                    canOk = false;
                    PropertyBeanDeleteAction.this.m_confirmDialog.setMessage(Texts.get((String)"FieldCanBeDeletedWithWriteMethod"), 3);
                }
            }
            PropertyBeanDeleteAction.this.m_confirmDialog.getOkButton().setEnabled(canOk);
        }
    }
}

