/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.bundle;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.extensions.bundle.INewScoutBundleHandler;
import org.eclipse.scout.sdk.ui.extensions.bundle.IProductLauncherContributor;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleUiExtension;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class ScoutBundleExtensionPoint {
    private static final String extensionId = "scoutBundle";
    private static final String attributeBundleId = "id";
    private static final String attributeBundleName = "bundleName";
    private static final String attributeBundleType = "bundleType";
    private static final String attributeOrderNumber = "orderNumber";
    private static final String attributeClass = "bundleNewHandler";
    private static final String attributeProductLauncherContributor = "productLauncherContributor";
    private static final String attributeBundlePage = "bundlePage";
    private static final String attributeIcon = "icon";
    private static final String attributeLauncherIcon = "launcherIcon";
    private static final Object lock = new Object();
    private static Map<String, ScoutBundleUiExtension> allExtensions = null;

    private ScoutBundleExtensionPoint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, ScoutBundleUiExtension> getAllExtensions() {
        if (allExtensions == null) {
            Object object = lock;
            synchronized (object) {
                if (allExtensions == null) {
                    IExtension[] extensions;
                    HashMap<String, ScoutBundleUiExtension> tmp = new HashMap<String, ScoutBundleUiExtension>();
                    IExtensionRegistry reg = Platform.getExtensionRegistry();
                    IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", extensionId);
                    IExtension[] iExtensionArray = extensions = xp.getExtensions();
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement[] elements;
                        IExtension extension = iExtensionArray[n2];
                        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                        int n3 = elements.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement element = iConfigurationElementArray[n4];
                            ScoutBundleUiExtension extensionPoint = new ScoutBundleUiExtension();
                            extensionPoint.setBundleId(element.getAttribute(attributeBundleId));
                            extensionPoint.setBundleName(element.getAttribute(attributeBundleName));
                            try {
                                String launcherIcon;
                                String icon;
                                String bundlePage;
                                String contribPlugin = element.getContributor().getName();
                                extensionPoint.setNewScoutBundleHandler((INewScoutBundleHandler)element.createExecutableExtension(attributeClass));
                                String productLauncherContributor = element.getAttribute(attributeProductLauncherContributor);
                                if (StringUtility.hasText((String)productLauncherContributor)) {
                                    extensionPoint.setProductLauncherContributor((IProductLauncherContributor)element.createExecutableExtension(attributeProductLauncherContributor));
                                }
                                if (!StringUtility.isNullOrEmpty((String)(bundlePage = StringUtility.trim((String)element.getAttribute(attributeBundlePage))))) {
                                    try {
                                        Class loadClass = Platform.getBundle((String)contribPlugin).loadClass(bundlePage);
                                        extensionPoint.setBundlePageClass(loadClass);
                                    }
                                    catch (Exception e) {
                                        ScoutSdkUi.logError("Unable to load bundle page '" + bundlePage + "'.", e);
                                    }
                                }
                                if (StringUtility.hasText((String)(icon = element.getAttribute(attributeIcon)))) {
                                    extensionPoint.setIcon(AbstractUIPlugin.imageDescriptorFromPlugin((String)contribPlugin, (String)icon));
                                }
                                if (StringUtility.hasText((String)(launcherIcon = element.getAttribute(attributeLauncherIcon)))) {
                                    extensionPoint.setLauncherIconPath(AbstractUIPlugin.imageDescriptorFromPlugin((String)contribPlugin, (String)launcherIcon));
                                }
                                String attOrderNr = element.getAttribute(attributeOrderNumber);
                                try {
                                    extensionPoint.setOrderNumber(Integer.parseInt(attOrderNr));
                                }
                                catch (NumberFormatException e) {
                                    ScoutSdkUi.logError("could not parse order number '" + attOrderNr + "' of extension '" + element.getNamespaceIdentifier() + "'.", e);
                                }
                                extensionPoint.setBundleType(element.getAttribute(attributeBundleType));
                                if (extensionPoint.isValidConfiguration()) {
                                    tmp.put(extensionPoint.getBundleType(), extensionPoint);
                                }
                            }
                            catch (CoreException e) {
                                ScoutSdkUi.logError("could not load class '" + element.getAttribute(attributeClass) + "'.", e);
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    allExtensions = tmp;
                }
            }
        }
        return allExtensions;
    }

    public static final ScoutBundleUiExtension[] getExtensions() {
        Collection<ScoutBundleUiExtension> all = ScoutBundleExtensionPoint.getAllExtensions().values();
        ScoutBundleUiExtension[] array = all.toArray(new ScoutBundleUiExtension[all.size()]);
        Arrays.sort(array, new Comparator<ScoutBundleUiExtension>(){

            @Override
            public int compare(ScoutBundleUiExtension o1, ScoutBundleUiExtension o2) {
                return o1.getOrderNumber() - o2.getOrderNumber();
            }
        });
        return array;
    }

    public static final ScoutBundleUiExtension getExtension(String type) {
        return ScoutBundleExtensionPoint.getAllExtensions().get(type);
    }
}

