/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.ITypeResolver;
import org.eclipse.scout.sdk.operation.util.wellform.WellformServerBundleOperation;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.create.ClassIdNewAction;
import org.eclipse.scout.sdk.ui.action.create.ScoutBundleNewAction;
import org.eclipse.scout.sdk.ui.action.validation.FormDataSqlBindingValidateAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.library.LibrariesTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.AbstractBundleNodeTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNode;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.ServerSessionNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.ServerServicesTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.common.CommonServicesNodePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.lookup.LookupServiceTablePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class ServerNodePage
extends AbstractBundleNodeTablePage {
    private ICachedTypeHierarchy m_serverSessionHierarchy;

    public ServerNodePage(IPage parent, ScoutBundleNode node) {
        super(parent, node);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ServerNodePage";
    }

    @Override
    public void unloadPage() {
        if (this.m_serverSessionHierarchy != null) {
            this.m_serverSessionHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_serverSessionHierarchy = null;
        }
    }

    @Override
    public void loadChildrenImpl() {
        super.loadChildrenImpl();
        if (this.m_serverSessionHierarchy == null) {
            IType iServerSession = TypeUtility.getType((String)"org.eclipse.scout.rt.server.IServerSession");
            this.m_serverSessionHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iServerSession);
            this.m_serverSessionHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        try {
            IType[] iTypeArray = ScoutTypeUtility.getServerSessionTypes((IScoutBundle)this.getScoutBundle());
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType serverSession = iTypeArray[n2];
                new ServerSessionNodePage(this, serverSession);
                ++n2;
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + ServerSessionNodePage.class.getSimpleName() + "' node in bundle '" + this.getScoutBundle().getSymbolicName() + "'.", e);
        }
        try {
            new ServerServicesTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + ServerServicesTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutBundle().getSymbolicName() + "'.", e);
        }
        try {
            new LookupServiceTablePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + LookupServiceTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutBundle().getSymbolicName() + "'.", e);
        }
        try {
            new CommonServicesNodePage(this);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured during loading '" + CommonServicesNodePage.class.getSimpleName() + "' node in bundle '" + this.getScoutBundle().getSymbolicName() + "'.", e);
        }
        try {
            new LibrariesTablePage(this, this.getScoutBundle());
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("Error occured while loading '" + LibrariesTablePage.class.getSimpleName() + "' node in bundle '" + this.getScoutBundle().getSymbolicName() + "'.", e);
        }
    }

    protected IType[] resolveServices() {
        IType iService = TypeUtility.getType((String)"org.eclipse.scout.service.IService");
        IPrimaryTypeTypeHierarchy serviceHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iService);
        IType[] services = serviceHierarchy.getAllSubtypes(iService, ScoutTypeFilters.getTypesInScoutBundles((IScoutBundle[])new IScoutBundle[]{this.getScoutBundle()}));
        return services;
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{WellformAction.class, FormDataSqlBindingValidateAction.class, ScoutBundleNewAction.class, ClassIdNewAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        if (menu instanceof WellformAction) {
            WellformAction action = (WellformAction)menu;
            action.init(this.getScoutBundle());
            action.setOperation((IOperation)new WellformServerBundleOperation(this.getScoutBundle()));
        } else if (menu instanceof FormDataSqlBindingValidateAction) {
            ((FormDataSqlBindingValidateAction)menu).setTyperesolver(new ITypeResolver(){

                public IType[] getTypes() {
                    return ServerNodePage.this.resolveServices();
                }
            });
        } else if (menu instanceof ScoutBundleNewAction) {
            ((ScoutBundleNewAction)menu).setScoutProject(this.getScoutBundle());
        } else if (menu instanceof ClassIdNewAction) {
            ((ClassIdNewAction)menu).setScoutBundle(this.getScoutBundle());
        }
    }
}

