/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractValuePresenter;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.config.parser.BigDecimalPropertySourceParser;
import org.eclipse.scout.sdk.workspace.type.config.parser.IPropertySourceParser;
import org.eclipse.swt.widgets.Composite;

public class BigDecimalPresenter
extends AbstractValuePresenter<BigDecimal> {
    private final IPropertySourceParser<BigDecimal> m_parser = new BigDecimalPropertySourceParser();
    private final NumberFormat m_formatter = DecimalFormat.getInstance();

    public BigDecimalPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent, "[\\-\\+0-9eE\\.']*");
        this.m_formatter.setMaximumFractionDigits(20);
    }

    public IPropertySourceParser<BigDecimal> getParser() {
        return this.m_parser;
    }

    @Override
    protected String formatDisplayValue(BigDecimal value) throws CoreException {
        if (value == null) {
            return "";
        }
        return this.m_formatter.format(value);
    }

    @Override
    protected BigDecimal parseSourceInput(String input) throws CoreException {
        if (input.equals("")) {
            return (BigDecimal)this.getDefaultValue();
        }
        return (BigDecimal)this.getParser().parseSourceValue(input, this.getMethod().peekMethod(), this.getMethod().getSuperTypeHierarchy());
    }

    @Override
    protected BigDecimal parseDisplayInput(String input) throws CoreException {
        return this.parseSourceInput(input.replace("'", ""));
    }

    @Override
    protected synchronized void storeValue(BigDecimal value) throws CoreException {
        try {
            ConfigPropertyUpdateOperation updateOp = new ConfigPropertyUpdateOperation(this.getMethod(), this.getParser());
            updateOp.setValue((Object)value);
            OperationJob job = new OperationJob(new IOperation[]{updateOp});
            job.setDebug(true);
            job.schedule();
        }
        catch (Exception e) {
            ScoutSdkUi.logError("could not parse default value of method '" + this.getMethod().getMethodName() + "' in type '" + this.getMethod().getType().getFullyQualifiedName() + "'.", e);
        }
    }

    @Override
    protected int getTextAlignment() {
        return 131072;
    }
}

