/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.services;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplateContext;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.viewsupport.ProjectTemplateStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.scout.sdk.internal.ScoutSdk;
import org.eclipse.scout.sdk.sourcebuilder.ICommentSourceBuilder;
import org.eclipse.scout.sdk.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.sourcebuilder.comment.IJavaElementCommentBuilderService;
import org.eclipse.scout.sdk.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.sourcebuilder.field.IFieldSourceBuilder;
import org.eclipse.scout.sdk.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.IImportValidator;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.MethodParameter;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class JavaElementCommentBuilderService
implements IJavaElementCommentBuilderService {
    private static final String[] EMPTY = new String[0];
    private static final String UNDEFINED_VAR_VALUE = "undefined";
    private static final int METHOD_TYPE_NORMAL = 2;
    private static final int METHOD_TYPE_GETTER = 4;
    private static final int METHOD_TYPE_SETTER = 8;
    private static final UsernameResolver USERNAME_RESOLVER = new UsernameResolver();
    private static final ICommentSourceBuilder COMPILATION_UNIT_COMMENT_BUILDER = new ICommentSourceBuilder(){

        public void createSource(ISourceBuilder sourceBuilder, StringBuilder source, String lineDelimiter, IJavaProject ownerProject, IImportValidator validator) throws CoreException {
            if (!(sourceBuilder instanceof ICompilationUnitSourceBuilder)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.scout.sdk", "to create an compilation unit comment the source builder must be an instance of 'ICompilationUnitSourceBuilder'."));
            }
            if (!JavaElementCommentBuilderService.isAutomaticallyAddComments(ownerProject)) {
                return;
            }
            ICompilationUnitSourceBuilder icuSourceBuilder = (ICompilationUnitSourceBuilder)sourceBuilder;
            Template template = JavaElementCommentBuilderService.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.filecomment", ownerProject);
            if (template != null) {
                CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), ownerProject, lineDelimiter);
                context.setVariable("file_name", icuSourceBuilder.getElementName());
                context.setVariable("package_name", icuSourceBuilder.getPackageFragmentName());
                context.setVariable("project_name", ownerProject.getElementName());
                context.setVariable("type_name", JavaCore.removeJavaLikeExtension((String)icuSourceBuilder.getElementName()));
                String comment = JavaElementCommentBuilderService.evaluateTemplate(context, template);
                if (comment != null) {
                    source.append(comment);
                }
            }
        }
    };
    private static final ICommentSourceBuilder TYPE_COMMENT_SOURCE_BUILDER = new ICommentSourceBuilder(){

        public void createSource(ISourceBuilder sourceBuilder, StringBuilder source, String lineDelimiter, IJavaProject ownerProject, IImportValidator validator) throws CoreException {
            TemplateBuffer buffer;
            if (!(sourceBuilder instanceof ITypeSourceBuilder)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.scout.sdk", "to create a type comment the source builder must be an instance of 'ITypeSourceBuilder'."));
            }
            if (!JavaElementCommentBuilderService.isAutomaticallyAddComments(ownerProject)) {
                return;
            }
            ITypeSourceBuilder typeSourceBuilder = (ITypeSourceBuilder)sourceBuilder;
            Template template = JavaElementCommentBuilderService.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.typecomment", ownerProject);
            if (template == null) {
                return;
            }
            CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), ownerProject, lineDelimiter);
            context.setVariable("file_name", JavaElementCommentBuilderService.UNDEFINED_VAR_VALUE);
            context.setVariable("package_name", Signature.getQualifier((String)typeSourceBuilder.getFullyQualifiedName()));
            context.setVariable("project_name", ownerProject.getElementName());
            context.setVariable("enclosing_type", Signature.getQualifier((String)typeSourceBuilder.getElementName()));
            context.setVariable("type_name", Signature.getSimpleName((String)typeSourceBuilder.getElementName()));
            try {
                buffer = context.evaluate(template);
            }
            catch (BadLocationException e) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            catch (TemplateException e) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            String str = buffer.getString();
            if (Strings.containsOnlyWhitespaces((String)str)) {
                return;
            }
            TemplateVariable position = JavaElementCommentBuilderService.findVariable(buffer, "tags");
            if (position == null) {
                if (str != null) {
                    source.append(str);
                }
                return;
            }
            Document document = new Document(str);
            int[] tagOffsets = position.getOffsets();
            int i = tagOffsets.length - 1;
            while (i >= 0) {
                try {
                    JavaElementCommentBuilderService.insertTag((IDocument)document, tagOffsets[i], position.getLength(), EMPTY, EMPTY, null, EMPTY, false, lineDelimiter);
                }
                catch (BadLocationException e) {
                    throw new CoreException(JavaUIStatus.createError((int)4, (Throwable)e));
                }
                --i;
            }
            String comment = document.get();
            if (comment != null) {
                source.append(comment);
            }
        }
    };
    private static final ICommentSourceBuilder METHOD_COMMENT_SOURCE_BUILDER = JavaElementCommentBuilderService.createMethodSourceBuilder(2);
    private static final ICommentSourceBuilder METHOD_GETTER_COMMENT_SOURCE_BUILDER = JavaElementCommentBuilderService.createMethodSourceBuilder(4);
    private static final ICommentSourceBuilder METHOD_SETTER_COMMENT_SOURCE_BUILDER = JavaElementCommentBuilderService.createMethodSourceBuilder(8);
    private static final ICommentSourceBuilder FIELD_COMMENT_SOURCE_BUILDER = new ICommentSourceBuilder(){

        public void createSource(ISourceBuilder sourceBuilder, StringBuilder source, String lineDelimiter, IJavaProject ownerProject, IImportValidator validator) throws CoreException {
            if (!(sourceBuilder instanceof IFieldSourceBuilder)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.scout.sdk", "to create an field comment the source builder must be an instance of 'IFieldSourceBuilder'."));
            }
            if (!JavaElementCommentBuilderService.isAutomaticallyAddComments(ownerProject)) {
                return;
            }
            IFieldSourceBuilder fieldSourceBuilder = (IFieldSourceBuilder)sourceBuilder;
            Template template = JavaElementCommentBuilderService.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.fieldcomment", ownerProject);
            if (template != null) {
                CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), ownerProject, lineDelimiter);
                context.setVariable("field_type", Signature.getSignatureSimpleName((String)fieldSourceBuilder.getSignature()));
                context.setVariable("field", fieldSourceBuilder.getElementName());
                context.setVariable("project_name", ownerProject.getElementName());
                context.setVariable("package_name", JavaElementCommentBuilderService.UNDEFINED_VAR_VALUE);
                context.setVariable("file_name", JavaElementCommentBuilderService.UNDEFINED_VAR_VALUE);
                String comment = JavaElementCommentBuilderService.evaluateTemplate(context, template);
                if (comment != null) {
                    source.append(comment);
                }
            }
        }
    };

    public ICommentSourceBuilder createPreferencesCompilationUnitCommentBuilder() {
        return COMPILATION_UNIT_COMMENT_BUILDER;
    }

    public ICommentSourceBuilder createPreferencesMethodOverrideComment(final String interfaceFqn) {
        return new ICommentSourceBuilder(){

            public void createSource(ISourceBuilder sourceBuilder, StringBuilder source, String lineDelimiter, IJavaProject ownerProject, IImportValidator validator) throws CoreException {
                if (!(sourceBuilder instanceof IMethodSourceBuilder)) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.scout.sdk", "to create an compilation unit comment the source builder must be an instance of 'ICompilationUnitSourceBuilder'."));
                }
                if (!JavaElementCommentBuilderService.isAutomaticallyAddComments(ownerProject)) {
                    return;
                }
                IMethodSourceBuilder methodSourceBuilder = (IMethodSourceBuilder)sourceBuilder;
                Template template = JavaElementCommentBuilderService.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.overridecomment", ownerProject);
                if (template != null) {
                    CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), ownerProject, lineDelimiter);
                    context.setVariable("package_name", JavaElementCommentBuilderService.UNDEFINED_VAR_VALUE);
                    context.setVariable("project_name", ownerProject.getElementName());
                    context.setVariable("file_name", JavaElementCommentBuilderService.UNDEFINED_VAR_VALUE);
                    context.setVariable("enclosing_method", methodSourceBuilder.getElementName());
                    context.setVariable("enclosing_type", JavaElementCommentBuilderService.UNDEFINED_VAR_VALUE);
                    StringBuilder seeBuilder = new StringBuilder("@see ");
                    seeBuilder.append(interfaceFqn).append("#").append(methodSourceBuilder.getElementName()).append("(");
                    Iterator parameterIterator = methodSourceBuilder.getParameters().iterator();
                    if (parameterIterator.hasNext()) {
                        seeBuilder.append(SignatureUtility.getFullyQualifiedName((String)((MethodParameter)parameterIterator.next()).getSignature()));
                        while (parameterIterator.hasNext()) {
                            seeBuilder.append(", ").append(SignatureUtility.getFullyQualifiedName((String)((MethodParameter)parameterIterator.next()).getSignature()));
                        }
                    }
                    seeBuilder.append(")");
                    context.setVariable("see_to_overridden", seeBuilder.toString());
                    String comment = JavaElementCommentBuilderService.evaluateTemplate(context, template);
                    if (comment != null) {
                        source.append(comment);
                    }
                }
            }
        };
    }

    private static ICommentSourceBuilder createMethodSourceBuilder(final int type) {
        return new ICommentSourceBuilder(){

            public void createSource(ISourceBuilder sourceBuilder, StringBuilder source, String lineDelimiter, IJavaProject ownerProject, IImportValidator validator) throws CoreException {
                TemplateBuffer buffer;
                if (!(sourceBuilder instanceof IMethodSourceBuilder)) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.scout.sdk", "to create a method comment the source builder must be an instance of 'IMethodSourceBuilder'."));
                }
                if (!JavaElementCommentBuilderService.isAutomaticallyAddComments(ownerProject)) {
                    return;
                }
                IMethodSourceBuilder methodSourceBuilder = (IMethodSourceBuilder)sourceBuilder;
                List parameters = methodSourceBuilder.getParameters();
                String[] paramSignatures = new String[parameters.size()];
                String[] paramNames = new String[parameters.size()];
                int j = 0;
                for (MethodParameter param : parameters) {
                    paramSignatures[j] = param.getSignature();
                    paramNames[j] = param.getName();
                    ++j;
                }
                List exceptionSignatures = methodSourceBuilder.getExceptionSignatures();
                String returnTypeSignature = methodSourceBuilder.getReturnTypeSignature();
                String fieldTypeSimpleName = JavaElementCommentBuilderService.UNDEFINED_VAR_VALUE;
                String templateName = null;
                switch (type) {
                    case 4: {
                        templateName = "org.eclipse.jdt.ui.text.codetemplates.gettercomment";
                        fieldTypeSimpleName = Signature.getSignatureSimpleName((String)methodSourceBuilder.getReturnTypeSignature());
                        break;
                    }
                    case 8: {
                        templateName = "org.eclipse.jdt.ui.text.codetemplates.settercomment";
                        if (methodSourceBuilder.getParameters().size() <= 0) break;
                        fieldTypeSimpleName = Signature.getSignatureSimpleName((String)((MethodParameter)methodSourceBuilder.getParameters().get(0)).getSignature());
                        break;
                    }
                    default: {
                        templateName = returnTypeSignature == null ? "org.eclipse.jdt.ui.text.codetemplates.constructorcomment" : "org.eclipse.jdt.ui.text.codetemplates.methodcomment";
                    }
                }
                Template template = JavaElementCommentBuilderService.getCodeTemplate(templateName, ownerProject);
                if (template == null) {
                    return;
                }
                CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), ownerProject, lineDelimiter);
                String getterSetterName = JavaElementCommentBuilderService.UNDEFINED_VAR_VALUE;
                Matcher matcher = TypeUtility.BEAN_METHOD_NAME.matcher(methodSourceBuilder.getElementName());
                if (matcher.find()) {
                    getterSetterName = matcher.group(2);
                }
                context.setVariable("project_name", ownerProject.getElementName());
                context.setVariable("file_name", JavaElementCommentBuilderService.UNDEFINED_VAR_VALUE);
                context.setVariable("package_name", JavaElementCommentBuilderService.UNDEFINED_VAR_VALUE);
                context.setVariable("enclosing_method", methodSourceBuilder.getElementName());
                context.setVariable("enclosing_type", JavaElementCommentBuilderService.UNDEFINED_VAR_VALUE);
                context.setVariable("field", getterSetterName);
                context.setVariable("field_type", fieldTypeSimpleName);
                context.setVariable("bare_field_name", getterSetterName);
                if (parameters.size() > 0) {
                    context.setVariable("param", ((MethodParameter)parameters.get(0)).getName());
                } else {
                    context.setVariable("param", JavaElementCommentBuilderService.UNDEFINED_VAR_VALUE);
                }
                if (returnTypeSignature != null) {
                    context.setVariable("return_type", Signature.toString((String)returnTypeSignature));
                }
                try {
                    buffer = context.evaluate(template);
                }
                catch (BadLocationException e) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                catch (TemplateException e) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                if (buffer == null) {
                    return;
                }
                String str = buffer.getString();
                if (Strings.containsOnlyWhitespaces((String)str)) {
                    return;
                }
                TemplateVariable position = JavaElementCommentBuilderService.findVariable(buffer, "tags");
                if (position == null) {
                    if (str != null) {
                        source.append(str);
                    }
                    return;
                }
                Document document = new Document(str);
                String[] exceptionNames = new String[exceptionSignatures.size()];
                int i = 0;
                while (i < exceptionNames.length) {
                    exceptionNames[i] = Signature.toString((String)((String)exceptionSignatures.get(i)));
                    ++i;
                }
                String returnType = returnTypeSignature != null ? Signature.toString((String)returnTypeSignature) : null;
                int[] tagOffsets = position.getOffsets();
                int i2 = tagOffsets.length - 1;
                while (i2 >= 0) {
                    try {
                        JavaElementCommentBuilderService.insertTag((IDocument)document, tagOffsets[i2], position.getLength(), paramNames, exceptionNames, returnType, EMPTY, false, lineDelimiter);
                    }
                    catch (BadLocationException e) {
                        throw new CoreException(JavaUIStatus.createError((int)4, (Throwable)e));
                    }
                    --i2;
                }
                String comment = document.get();
                if (comment != null) {
                    source.append(comment);
                }
            }
        };
    }

    public ICommentSourceBuilder createPreferencesTypeCommentBuilder() {
        return TYPE_COMMENT_SOURCE_BUILDER;
    }

    public ICommentSourceBuilder createPreferencesMethodCommentBuilder() {
        return METHOD_COMMENT_SOURCE_BUILDER;
    }

    public ICommentSourceBuilder createPreferencesMethodGetterCommentBuilder() {
        return METHOD_GETTER_COMMENT_SOURCE_BUILDER;
    }

    public ICommentSourceBuilder createPreferencesMethodSetterCommentBuilder() {
        return METHOD_SETTER_COMMENT_SOURCE_BUILDER;
    }

    public ICommentSourceBuilder createPreferencesFieldCommentBuilder() {
        return FIELD_COMMENT_SOURCE_BUILDER;
    }

    private static boolean isAutomaticallyAddComments(IJavaProject jp) {
        IScopeContext[] contexts;
        IScopeContext[] iScopeContextArray = contexts = new IScopeContext[]{new ProjectScope(jp.getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            String val;
            IScopeContext context = iScopeContextArray[n2];
            IEclipsePreferences node = context.getNode("org.eclipse.jdt.ui");
            if (node != null && (val = node.get("org.eclipse.jdt.ui.javadoc", null)) != null) {
                return "true".equals(val);
            }
            ++n2;
        }
        return true;
    }

    private static String evaluateTemplate(CodeTemplateContext context, Template template) throws CoreException {
        TemplateBuffer buffer;
        Iterator resolvers = context.getContextType().resolvers();
        while (resolvers.hasNext()) {
            TemplateVariableResolver resolver = (TemplateVariableResolver)resolvers.next();
            if (!(resolver instanceof GlobalTemplateVariables.User)) continue;
            context.getContextType().removeResolver(resolver);
            context.getContextType().addResolver((TemplateVariableResolver)USERNAME_RESOLVER);
            break;
        }
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (TemplateException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces((String)str)) {
            return null;
        }
        return str;
    }

    private static Template getCodeTemplate(String id, IJavaProject project) {
        if (project == null) {
            return JavaPlugin.getDefault().getCodeTemplateStore().findTemplateById(id);
        }
        ProjectTemplateStore projectStore = new ProjectTemplateStore(project.getProject());
        try {
            projectStore.load();
        }
        catch (IOException e) {
            ScoutSdk.logError((Throwable)e);
        }
        return projectStore.findTemplateById(id);
    }

    private static TemplateVariable findVariable(TemplateBuffer buffer, String variable) {
        TemplateVariable[] positions = buffer.getVariables();
        int i = 0;
        while (i < positions.length) {
            TemplateVariable curr = positions[i];
            if (variable.equals(curr.getType())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static void insertTag(IDocument textBuffer, int offset, int length, String[] paramNames, String[] exceptionNames, String returnType, String[] typeParameterNames, boolean isDeprecated, String lineDelimiter) throws BadLocationException {
        int prevLine;
        IRegion region = textBuffer.getLineInformationOfOffset(offset);
        if (region == null) {
            return;
        }
        String lineStart = textBuffer.get(region.getOffset(), offset - region.getOffset());
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < typeParameterNames.length) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@param <").append(typeParameterNames[i]).append('>');
            ++i;
        }
        i = 0;
        while (i < paramNames.length) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@param ").append(paramNames[i]);
            ++i;
        }
        if (returnType != null && !returnType.equals("void")) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@return");
        }
        if (exceptionNames != null) {
            i = 0;
            while (i < exceptionNames.length) {
                if (buf.length() > 0) {
                    buf.append(lineDelimiter).append(lineStart);
                }
                buf.append("@throws ").append(exceptionNames[i]);
                ++i;
            }
        }
        if (isDeprecated) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@deprecated");
        }
        if (buf.length() == 0 && JavaElementCommentBuilderService.isAllCommentWhitespace(lineStart) && (prevLine = textBuffer.getLineOfOffset(offset) - 1) > 0) {
            IRegion prevRegion = textBuffer.getLineInformation(prevLine);
            int prevLineEnd = prevRegion.getOffset() + prevRegion.getLength();
            textBuffer.replace(prevLineEnd, offset + length - prevLineEnd, "");
            return;
        }
        textBuffer.replace(offset, length, buf.toString());
    }

    private static boolean isAllCommentWhitespace(String lineStart) {
        int i = 0;
        while (i < lineStart.length()) {
            char ch = lineStart.charAt(i);
            if (!Character.isWhitespace(ch) && ch != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final class UsernameResolver
    extends GlobalTemplateVariables.User {
        private UsernameResolver() {
        }

        protected String resolve(TemplateContext context) {
            return ScoutUtility.getUsername();
        }
    }
}

