/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.service.ServiceRegistrationDescription;
import org.eclipse.scout.sdk.ui.fields.bundletree.ICheckStateListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public abstract class AbstractServiceWizard
extends AbstractWorkspaceWizard {
    public static final String TYPE_SERVICE_REG_SESSION = "svcRegSession";
    private static final String SETTING_DEFAULT_SESSIONS = "settingDefaultSessions";

    protected static String getDefaultSessionSettingKey(IScoutBundle parent) {
        return "settingDefaultSessions_" + parent.getSymbolicName().replace('.', '_');
    }

    protected IType getLastUsedDefaultSession(IScoutBundle parent) {
        IType candidate;
        String fqn = this.getDialogSettings().get(AbstractServiceWizard.getDefaultSessionSettingKey(parent));
        if (StringUtility.hasText((String)fqn) && TypeUtility.exists((IJavaElement)(candidate = TypeUtility.getType((String)fqn)))) {
            return candidate;
        }
        return null;
    }

    public abstract BundleTreeWizardPage getLocationsPage();

    protected List<ServiceRegistrationDescription> getCheckedServiceRegistrations(ITreeNode[] serviceRegNodes) {
        LinkedList<ServiceRegistrationDescription> result = new LinkedList<ServiceRegistrationDescription>();
        ITreeNode[] iTreeNodeArray = serviceRegNodes;
        int n = serviceRegNodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode n3 = iTreeNodeArray[n2];
            if (this.getLocationsPage().isNodeChecked(n3)) {
                IScoutBundle b = BundleTreeWizardPage.getLocationBundle(n3);
                IType sessionToUse = null;
                ITreeNode[] iTreeNodeArray2 = n3.getChildren(NodeFilters.getVisible());
                int n4 = iTreeNodeArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    ITreeNode child = iTreeNodeArray2[n5];
                    if (this.getLocationsPage().isNodeChecked(child)) {
                        sessionToUse = (IType)child.getData();
                        break;
                    }
                    ++n5;
                }
                result.add(new ServiceRegistrationDescription(ScoutUtility.getJavaProject((IScoutBundle)b), sessionToUse));
            }
            ++n2;
        }
        return result;
    }

    protected void storeUsedSession(ServiceRegistrationDescription sessionRegDesc) {
        IScoutBundle bundle;
        if (sessionRegDesc.session != null && (bundle = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundle((IJavaElement)sessionRegDesc.targetProject)) != null) {
            this.getDialogSettings().put(AbstractServiceWizard.getDefaultSessionSettingKey(bundle), sessionRegDesc.session);
        }
    }

    protected void refreshAvailableSessions(ITreeNode serviceRegistrationNode, ITreeNode serviceRegNodeOrig) {
        BundleTreeWizardPage locationPage = this.getLocationsPage();
        IScoutBundle bundle = BundleTreeWizardPage.getLocationBundle(serviceRegistrationNode);
        if (bundle == null) {
            return;
        }
        IType[] sessions = ScoutTypeUtility.getSessionTypes((IJavaProject)bundle.getJavaProject());
        ITreeNode[] createdNodes = new ITreeNode[sessions.length];
        IType defaultSelection = null;
        if (locationPage != null) {
            ITreeNode[] iTreeNodeArray = serviceRegNodeOrig.getChildren(NodeFilters.getVisible());
            int n = iTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode sibling = iTreeNodeArray[n2];
                if (locationPage.isNodeChecked(sibling)) {
                    defaultSelection = (IType)sibling.getData();
                    break;
                }
                ++n2;
            }
            if (defaultSelection == null) {
                defaultSelection = this.getLastUsedDefaultSession(bundle);
            }
        }
        serviceRegistrationNode.clearChildren();
        boolean defaultFound = false;
        int i = 0;
        while (i < sessions.length) {
            boolean isServerSession = TypeUtility.getSuperTypeHierarchy((IType)sessions[i]).contains(TypeUtility.getType((String)"org.eclipse.scout.rt.server.IServerSession"));
            ImageDescriptor icon = null;
            icon = isServerSession ? ScoutSdkUi.getImageDescriptor("serverSession.png") : ScoutSdkUi.getImageDescriptor("clientSession.png");
            createdNodes[i] = TreeUtility.createNode(serviceRegistrationNode, TYPE_SERVICE_REG_SESSION, Texts.get((String)"UseSessionInRegistration", (String[])new String[]{sessions[i].getElementName()}), icon, i, sessions[i]);
            if (defaultSelection != null && CompareUtility.equals((Object)sessions[i], (Object)defaultSelection)) {
                defaultFound = true;
            }
            ++i;
        }
        if (locationPage != null) {
            if (defaultSelection == null || !defaultFound) {
                defaultSelection = ScoutUtility.getNearestType((IType[])sessions, (IScoutBundle)bundle);
            }
            if (serviceRegistrationNode != serviceRegNodeOrig) {
                locationPage.setNodeChecked(serviceRegistrationNode, locationPage.isNodeChecked(serviceRegNodeOrig));
            }
            i = 0;
            while (i < sessions.length) {
                locationPage.setNodeChecked(createdNodes[i], CompareUtility.equals((Object)sessions[i], (Object)defaultSelection));
                ++i;
            }
            locationPage.refreshTree();
        }
    }

    protected class P_InitialCheckedFilter
    implements ITreeNodeFilter {
        @Override
        public boolean accept(ITreeNode node) {
            if (node.getType() == AbstractServiceWizard.TYPE_SERVICE_REG_SESSION) {
                IScoutBundle b = BundleTreeWizardPage.getLocationBundle(node);
                IType curSession = (IType)node.getData();
                ITreeNode[] siblings = node.getParent().getChildren(NodeFilters.getVisible());
                IType defaultSession = AbstractServiceWizard.this.getLastUsedDefaultSession(b);
                boolean defaultSessionFound = false;
                IType[] sessions = new IType[siblings.length];
                int i = 0;
                while (i < siblings.length) {
                    sessions[i] = (IType)siblings[i].getData();
                    if (!defaultSessionFound && sessions[i].equals(defaultSession)) {
                        defaultSessionFound = true;
                    }
                    ++i;
                }
                if (defaultSession == null || !defaultSessionFound) {
                    defaultSession = ScoutUtility.getNearestType((IType[])sessions, (IScoutBundle)b);
                }
                return CompareUtility.equals((Object)defaultSession, (Object)curSession);
            }
            return true;
        }
    }

    protected class P_SessionCheckListener
    implements ICheckStateListener {
        @Override
        public void fireNodeCheckStateChanged(ITreeNode node, boolean checkState) {
            if (checkState && node.getType() == AbstractServiceWizard.TYPE_SERVICE_REG_SESSION) {
                ITreeNode[] iTreeNodeArray = node.getParent().getChildren(NodeFilters.getVisible());
                int n = iTreeNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITreeNode sibling = iTreeNodeArray[n2];
                    if (sibling != node) {
                        AbstractServiceWizard.this.getLocationsPage().setNodeChecked(sibling, false);
                    }
                    ++n2;
                }
            }
        }
    }
}

