/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.library;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.operation.library.LibraryBundleCreateOperation;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.library.JarSelectionWizardPage;
import org.eclipse.scout.sdk.ui.wizard.library.LibraryTypeWizardPage;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;

public class LibraryNewWizard
extends AbstractWorkspaceWizard {
    private JarSelectionWizardPage m_jarSelectionWizardPage;
    private LibraryTypeWizardPage m_libraryWizardPage;
    private final IScoutBundle m_ownerBundle;

    public LibraryNewWizard(IScoutBundle ownerBundle) {
        this.m_ownerBundle = ownerBundle;
        this.m_jarSelectionWizardPage = new JarSelectionWizardPage();
        this.m_jarSelectionWizardPage.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("jarFiles")) {
                    Set<File> jarFiles;
                    String projectName;
                    StringBuilder nameBuilder = new StringBuilder();
                    if (LibraryNewWizard.this.getOwnerBundle() != null && StringUtility.hasText((String)(projectName = LibraryNewWizard.this.getOwnerBundle().getSymbolicName()))) {
                        nameBuilder.append(projectName).append(".");
                    }
                    if ((jarFiles = LibraryNewWizard.this.m_jarSelectionWizardPage.getJarFiles()) != null && jarFiles.size() > 0) {
                        String jarFileName = jarFiles.iterator().next().getName();
                        int dotIndex = jarFileName.lastIndexOf(".");
                        if (dotIndex > 0) {
                            nameBuilder.append(jarFileName.substring(0, dotIndex));
                        } else {
                            nameBuilder.append(jarFileName);
                        }
                    } else {
                        nameBuilder.append("library");
                    }
                    int index = 1;
                    String bundleName = nameBuilder.toString();
                    while (Platform.getBundle((String)bundleName) != null) {
                        bundleName = String.valueOf(nameBuilder.toString()) + index++;
                    }
                    LibraryNewWizard.this.m_libraryWizardPage.setBundleName(bundleName);
                }
            }
        });
        this.addPage((IWizardPage)this.m_jarSelectionWizardPage);
        this.m_libraryWizardPage = new LibraryTypeWizardPage(ownerBundle);
        this.addPage((IWizardPage)this.m_libraryWizardPage);
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        super.performFinish(monitor, workingCopyManager);
        LibraryBundleCreateOperation operation = new LibraryBundleCreateOperation();
        operation.setBundleName(this.getLibraryWizardPage().getBundleName());
        operation.setLibraryFiles(this.getJarSelectionWizardPage().getJarFiles());
        switch (this.getLibraryWizardPage().getLibraryType()) {
            case Plugin: {
                operation.setLibraryUserBundles(this.getLibraryWizardPage().getLibraryUserBundles());
                break;
            }
            case Fragment: {
                operation.setFragmentHost(this.getLibraryWizardPage().getFragmentHost());
                break;
            }
            case SystemBundleFragment: {
                operation.setFragmentHost("system.bundle");
            }
        }
        operation.validate();
        operation.run(monitor, workingCopyManager);
        return true;
    }

    public JarSelectionWizardPage getJarSelectionWizardPage() {
        return this.m_jarSelectionWizardPage;
    }

    public LibraryTypeWizardPage getLibraryWizardPage() {
        return this.m_libraryWizardPage;
    }

    public IScoutBundle getOwnerBundle() {
        return this.m_ownerBundle;
    }
}

