/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.sdk.util.log.ScoutStatus;

public class FormatPreservingProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ENCODING = "8859_1";
    private final Properties m_properties = new Properties();
    private final ReentrantReadWriteLock m_lock;
    private final ArrayList<P_PropertyLine> m_lines = new ArrayList();
    private Map<String, String> m_origValues;

    public FormatPreservingProperties() {
        this.m_lock = new ReentrantReadWriteLock(true);
    }

    public void load(IFile f) throws CoreException {
        InputStream is = null;
        try {
            is = f.getContents();
            this.load(is);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new CoreException((IStatus)new ScoutStatus(e));
                }
            }
        }
    }

    public void load(InputStream is) throws CoreException {
        try {
            this.load(IOUtility.getContent((InputStream)is, (boolean)false));
        }
        catch (ProcessingException e) {
            throw new CoreException((IStatus)new ScoutStatus(e));
        }
    }

    public void store(OutputStream out) throws CoreException {
        BufferedWriter writer = null;
        try {
            try {
                this.m_lock.readLock().lock();
                writer = new BufferedWriter(new OutputStreamWriter(out, ENCODING));
                for (P_PropertyLine line : this.m_lines) {
                    if (line.ignore) continue;
                    if (StringUtility.hasText((String)line.key)) {
                        writer.write(this.getLineFormatted(line.key));
                    } else {
                        writer.write(line.comment);
                    }
                    writer.newLine();
                }
                writer.flush();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new ScoutStatus(e));
            }
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public void setProperty(String key, String value) {
        if (key == null || value == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.m_lock.writeLock().lock();
            boolean newKey = !this.m_properties.containsKey(key);
            this.m_properties.setProperty(key, value);
            if (newKey) {
                P_PropertyLine newLine = new P_PropertyLine();
                newLine.key = key;
                this.m_lines.add(newLine);
            }
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    public String getProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("null is not a valid property key");
        }
        try {
            this.m_lock.readLock().lock();
            String string = this.m_properties.getProperty(key);
            return string;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public boolean containsProperty(String key) {
        try {
            this.m_lock.readLock().lock();
            boolean bl = this.m_properties.containsKey(key);
            return bl;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public void removeProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("null is not a valid property key");
        }
        try {
            this.m_lock.writeLock().lock();
            this.m_properties.remove(key);
            Iterator<P_PropertyLine> it = this.m_lines.iterator();
            while (it.hasNext()) {
                P_PropertyLine line = it.next();
                if (!CompareUtility.equals((Object)key, (Object)line.key)) continue;
                it.remove();
                break;
            }
        }
        finally {
            this.m_lock.writeLock().unlock();
        }
    }

    public Map<String, String> getEntries() {
        try {
            this.m_lock.readLock().lock();
            HashMap<String, String> result = new HashMap<String, String>(this.m_properties.size());
            for (Map.Entry<Object, Object> entry : this.m_properties.entrySet()) {
                result.put((String)entry.getKey(), (String)entry.getValue());
            }
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public int size() {
        try {
            this.m_lock.readLock().lock();
            int n = this.m_properties.size();
            return n;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    public boolean isDirty() {
        try {
            this.m_lock.readLock().lock();
            if (this.size() != this.m_origValues.size()) {
                return true;
            }
            for (Map.Entry<String, String> entry : this.m_origValues.entrySet()) {
                if (!CompareUtility.notEquals((Object)this.getProperty(entry.getKey()), (Object)entry.getValue())) continue;
                return true;
            }
            return false;
        }
        finally {
            this.m_lock.readLock().unlock();
        }
    }

    private void load(byte[] data) {
        BufferedReader reader = null;
        try {
            try {
                this.m_lock.writeLock().lock();
                reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(data), ENCODING));
                reader.mark(data.length + 1);
                this.m_lines.clear();
                this.m_properties.clear();
                this.m_properties.load(reader);
                reader.reset();
                String lineContent = null;
                boolean lastLineEndsWithBackSlash = false;
                while ((lineContent = reader.readLine()) != null) {
                    String lineContentTrim = lineContent.trim();
                    P_PropertyLine line = new P_PropertyLine();
                    line.ignore = lastLineEndsWithBackSlash;
                    if (!lastLineEndsWithBackSlash) {
                        if (lineContentTrim.length() < 1 || lineContentTrim.charAt(0) == '#' || lineContentTrim.charAt(0) == '!') {
                            line.comment = lineContent;
                        } else {
                            String key = this.findKey(lineContent);
                            if (StringUtility.hasText((String)key)) {
                                line.key = key;
                            } else {
                                throw new IllegalArgumentException("Invalid properties file format");
                            }
                        }
                    }
                    this.m_lines.add(line);
                    boolean bl = lastLineEndsWithBackSlash = lineContentTrim.length() > 0 && lineContentTrim.charAt(lineContentTrim.length() - 1) == '\\';
                }
                this.m_origValues = this.getEntries();
            }
            catch (IOException iOException) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                this.m_lock.writeLock().unlock();
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            this.m_lock.writeLock().unlock();
        }
    }

    /*
     * Loose catch block
     */
    private String getLineFormatted(String key) {
        String string;
        BufferedReader lineReader;
        ByteArrayOutputStream buffer;
        block21: {
            Properties parser = new Properties();
            parser.setProperty(key, this.m_properties.getProperty(key));
            buffer = null;
            lineReader = null;
            buffer = new ByteArrayOutputStream();
            parser.store(buffer, null);
            lineReader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(buffer.toByteArray()), ENCODING));
            lineReader.readLine();
            string = lineReader.readLine();
            if (buffer == null) break block21;
            try {
                buffer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (lineReader != null) {
            try {
                lineReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
        catch (IOException e) {
            if (buffer != null) {
                try {
                    buffer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (lineReader != null) {
                try {
                    lineReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
            catch (Throwable throwable) {
                if (buffer != null) {
                    try {
                        buffer.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (lineReader != null) {
                    try {
                        lineReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private String findKey(String lineContent) {
        ByteArrayInputStream is;
        block18: {
            String string;
            block19: {
                Set<Object> keySet;
                block16: {
                    block17: {
                        Properties parser = new Properties();
                        is = null;
                        is = new ByteArrayInputStream(lineContent.getBytes(ENCODING));
                        parser.load(is);
                        keySet = parser.keySet();
                        if (keySet.size() != 0) break block16;
                        if (is == null) break block17;
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
                if (keySet.size() != 1) break block18;
                string = (String)keySet.iterator().next();
                if (is == null) break block19;
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return string;
        }
        try {
            try {
                throw new IllegalArgumentException("Invalid properties file format");
            }
            catch (IOException e) {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    private static final class P_PropertyLine
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean ignore;
        private String comment;
        private String key;

        private P_PropertyLine() {
        }
    }
}

