/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;

public final class NamingUtility {
    private static final Object LOCK = new Object();
    private static Set<String> javaKeyWords = null;

    private NamingUtility() {
    }

    public static String ensureValidParameterName(String parameterName) {
        if (NamingUtility.isReservedJavaKeyword(parameterName)) {
            return String.valueOf(parameterName) + "Value";
        }
        return parameterName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getJavaKeyWords() {
        if (javaKeyWords == null) {
            Object object = LOCK;
            synchronized (object) {
                if (javaKeyWords == null) {
                    String[] keyWords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "false", "null", "true"};
                    HashSet<String> tmp = new HashSet<String>(keyWords.length);
                    String[] stringArray = keyWords;
                    int n = keyWords.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        tmp.add(s);
                        ++n2;
                    }
                    javaKeyWords = Collections.unmodifiableSet(tmp);
                }
            }
        }
        return javaKeyWords;
    }

    public static boolean isReservedJavaKeyword(String word) {
        return NamingUtility.getJavaKeyWords().contains(word.toLowerCase());
    }

    public static boolean isFullyQualifiedName(String name) {
        return name != null && (name.indexOf(46) > 0 || name.indexOf(36) > 0);
    }

    public static String ensureStartWithLowerCase(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.trim()).length() == 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name.length());
        sb.append(Character.toLowerCase(name.charAt(0)));
        if (name.length() > 1) {
            sb.append(name.substring(1));
        }
        return sb.toString();
    }

    public static String ensureStartWithUpperCase(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.trim()).length() == 0) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name.length());
        sb.append(Character.toUpperCase(name.charAt(0)));
        if (name.length() > 1) {
            sb.append(name.substring(1));
        }
        return sb.toString();
    }

    public static String toJavaCamelCase(String input) {
        return NamingUtility.toJavaCamelCase(input, true);
    }

    public static int stringDistance(String s1, String s2) {
        if (s1 == null || s2 == null || CompareUtility.equals((Object)s1, (Object)s2)) {
            return 0;
        }
        int l1 = s1.length();
        int l2 = s2.length();
        if (l1 == 0) {
            return l2;
        }
        if (l2 == 0) {
            return l1;
        }
        int[] col0 = new int[l1 + 1];
        int[] col1 = new int[l1 + 1];
        int i = 0;
        while (i <= l1) {
            col0[i] = i;
            ++i;
        }
        int j = 1;
        while (j <= l2) {
            char jth = s2.charAt(j - 1);
            col1[0] = j;
            i = 1;
            while (i <= l1) {
                int cost = s1.charAt(i - 1) == jth ? 0 : 1;
                col1[i] = Math.min(Math.min(col1[i - 1] + 1, col0[i] + 1), col0[i - 1] + cost);
                ++i;
            }
            int[] col = col0;
            col0 = col1;
            col1 = col;
            ++j;
        }
        return col0[l1];
    }

    public static String toJavaCamelCase(String input, boolean lowerCaseFirstToken) {
        if (!StringUtility.hasText((String)input)) {
            return null;
        }
        String ALLOWED_CHARS = "abcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder camel = new StringBuilder(input.length());
        char[] charArray = input.toCharArray();
        boolean nextCharUpper = !lowerCaseFirstToken;
        int i = 0;
        while (i < charArray.length) {
            char cur = charArray[i];
            char curLower = Character.toLowerCase(cur);
            if ("abcdefghijklmnopqrstuvwxyz0123456789".indexOf(curLower) >= 0) {
                if (nextCharUpper) {
                    cur = Character.toUpperCase(cur);
                    nextCharUpper = false;
                } else if (i == 0) {
                    cur = curLower;
                }
                camel.append(cur);
            } else {
                nextCharUpper = true;
            }
            ++i;
        }
        return camel.toString();
    }
}

