/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.pde;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModel;
import org.eclipse.pde.internal.core.bundle.BundlePluginModelBase;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.plugin.WorkspaceExtensionsModel;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.osgi.framework.Version;

public final class LazyPluginModel {
    private final IProject m_project;
    private final IFile m_manifestFile;
    private final IFile m_pluginXmlFile;
    private final IFile m_buildPropertiesFile;
    private volatile BundleDescription m_desc;
    private volatile IPluginModelBase m_bundlePluginModel;
    private volatile IPluginBase m_pluginBase;
    private volatile IBundle m_bundle;
    private volatile WorkspaceBundleModel m_bundleModel;
    private volatile WorkspaceBuildModel m_buildModel;
    private volatile WorkspaceExtensionsModel m_extensionsModel;

    public LazyPluginModel(IPluginModelBase modelBase) {
        if (modelBase == null) {
            throw new IllegalArgumentException("null project not allowed.");
        }
        this.m_project = null;
        this.m_manifestFile = null;
        this.m_pluginXmlFile = null;
        this.m_buildPropertiesFile = null;
        this.m_bundlePluginModel = modelBase;
        this.m_desc = modelBase.getBundleDescription();
        this.m_pluginBase = modelBase.getPluginBase(true);
    }

    public LazyPluginModel(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException("null project not allowed.");
        }
        this.m_project = project;
        this.m_manifestFile = this.getProject().getFile("META-INF/MANIFEST.MF");
        this.m_pluginXmlFile = this.getProject().getFile("plugin.xml");
        this.m_buildPropertiesFile = this.getProject().getFile("build.properties");
        if (!this.isInteresting()) {
            throw new IllegalArgumentException("the passed project '" + project.getName() + "' is not a valid plugin.");
        }
    }

    private boolean isInteresting() {
        return this.getProject() != null && this.getProject().isOpen() && this.getManifestFile() != null && this.getManifestFile().exists() && this.getPluginXmlFile() != null && this.getBuildPropertiesFile() != null;
    }

    public IPluginModelBase getBundlePluginModel() {
        this.loadBundlePluginExtensionModels();
        return this.m_bundlePluginModel;
    }

    public WorkspaceExtensionsModel getExtensionsModel() {
        this.loadBundlePluginExtensionModels();
        return this.m_extensionsModel;
    }

    private synchronized void loadBundlePluginExtensionModels() {
        boolean useNewWem;
        boolean bpmCreated = false;
        boolean wemCreated = false;
        BundlePluginModel bpm = null;
        WorkspaceExtensionsModel wem = this.m_extensionsModel;
        if (this.m_bundlePluginModel == null) {
            bpm = new BundlePluginModel();
            bpm.setBundleDescription(this.getBundleDescription());
            bpm.setBundleModel((IBundleModel)this.getBundleModel());
            bpm.setBuildModel(this.getBuildModel());
            bpm.setEnabled(true);
            bpm.setDirty(false);
            bpmCreated = true;
        }
        if (this.m_extensionsModel == null && ResourceUtility.exists((IResource)this.getPluginXmlFile())) {
            wem = new WorkspaceExtensionsModel(this.getPluginXmlFile());
            wem.load(this.getBundleDescription(), LazyPluginModel.getPdeState());
            wem.setDirty(false);
            wemCreated = true;
        }
        boolean bl = useNewWem = wemCreated && wem != null && (bpmCreated || this.m_bundlePluginModel instanceof IBundlePluginModelBase);
        if (bpmCreated && bpm != null) {
            if (useNewWem) {
                bpm.setExtensionsModel((ISharedExtensionsModel)wem);
            } else {
                bpm.setExtensionsModel((ISharedExtensionsModel)this.m_extensionsModel);
            }
            this.m_bundlePluginModel = bpm;
        }
        if (useNewWem && wem != null) {
            wem.setBundleModel((IBundlePluginModelBase)this.m_bundlePluginModel);
            this.m_extensionsModel = wem;
        }
    }

    public synchronized IPluginBase getPluginBase() {
        if (this.m_pluginBase == null) {
            this.m_pluginBase = this.getBundlePluginModel().getPluginBase(true);
        }
        return this.m_pluginBase;
    }

    public synchronized IBuildModel getBuildModel() {
        if (this.m_buildModel == null && this.getBuildPropertiesFile() != null) {
            WorkspaceBuildModel tmp = new WorkspaceBuildModel(this.getBuildPropertiesFile());
            tmp.load();
            tmp.setDirty(false);
            this.m_buildModel = tmp;
        }
        return this.m_buildModel;
    }

    public synchronized IBundle getBundle() {
        if (this.m_bundle == null) {
            this.m_bundle = this.getBundleModel().getBundle();
        }
        return this.m_bundle;
    }

    public synchronized WorkspaceBundleModel getBundleModel() {
        if (this.m_bundleModel == null) {
            WorkspaceBundleModel tmp = new WorkspaceBundleModel(this.getManifestFile());
            tmp.load();
            tmp.setDirty(false);
            this.m_bundleModel = tmp;
        }
        return this.m_bundleModel;
    }

    public static PDEState getPdeState() {
        return PDECore.getDefault().getModelManager().getState();
    }

    public static BundleDescription[] getBundles() {
        return LazyPluginModel.getPdeState().getState().getBundles();
    }

    public static BundleDescription[] getBundles(String symbolicName) {
        return LazyPluginModel.getPdeState().getState().getBundles(symbolicName);
    }

    public static BundleDescription getBundle(String symbolicName, Version version) {
        return LazyPluginModel.getPdeState().getState().getBundle(symbolicName, version);
    }

    public synchronized BundleDescription getBundleDescription() {
        if (this.m_desc == null) {
            IPluginModelBase pluginBase = PDECore.getDefault().getModelManager().findModel(this.getProject());
            if (pluginBase != null) {
                this.m_desc = pluginBase.getBundleDescription();
            }
            if (this.m_desc == null) {
                throw new IllegalArgumentException("project '" + this.getProject().getName() + "' could not be found in the workspace.");
            }
        }
        return this.m_desc;
    }

    public synchronized void save() {
        BundlePluginModelBase base;
        boolean baseSaved = false;
        if (this.m_bundlePluginModel instanceof BundlePluginModelBase && (base = (BundlePluginModelBase)this.m_bundlePluginModel).isDirty()) {
            base.save();
            baseSaved = true;
        }
        if (!baseSaved) {
            if (this.m_bundleModel != null && this.m_bundleModel.isDirty()) {
                this.m_bundleModel.save();
            }
            if (this.m_extensionsModel != null && this.m_extensionsModel.isDirty()) {
                this.m_extensionsModel.save();
            }
        }
        if (this.m_buildModel != null && this.m_buildModel.isDirty()) {
            this.m_buildModel.save();
        }
    }

    public IProject getProject() {
        return this.m_project;
    }

    public IFile getManifestFile() {
        return this.m_manifestFile;
    }

    public IFile getPluginXmlFile() {
        return this.m_pluginXmlFile;
    }

    public IFile getBuildPropertiesFile() {
        return this.m_buildPropertiesFile;
    }
}

