/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.pde;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.bundle.BundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePlugin;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.BundleClasspathHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.util.pde.LazyPluginModel;
import org.osgi.framework.Version;

public class PluginModelHelper {
    public final ManifestPart Manifest;
    public final PluginXmlPart PluginXml;
    public final BuildPropertiesPart BuildProperties;

    public PluginModelHelper(IPluginModelBase pluginModelBase) {
        this(PluginModelHelper.createPluginModel(pluginModelBase.getBundleDescription().getName()));
    }

    public PluginModelHelper(String projectName) {
        this(PluginModelHelper.createPluginModel(projectName));
    }

    private static LazyPluginModel createPluginModel(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project != null && project.isAccessible()) {
            return new LazyPluginModel(project);
        }
        IPluginModelBase model = PluginRegistry.findModel((String)projectName);
        return new LazyPluginModel(model);
    }

    public PluginModelHelper(IProject project) {
        this(new LazyPluginModel(project));
    }

    private PluginModelHelper(LazyPluginModel model) {
        this.Manifest = new ManifestPart(model);
        this.PluginXml = new PluginXmlPart(model);
        this.BuildProperties = new BuildPropertiesPart(model);
    }

    public IProject getProject() {
        return this.Manifest.m_model.getProject();
    }

    private static String getProjectRelativeResourcePath(IResource r) {
        if (r == null) {
            return null;
        }
        String entry = r.getProjectRelativePath().toString();
        if (r.getType() == 2 && !entry.endsWith("/")) {
            entry = String.valueOf(entry) + "/";
        }
        return entry;
    }

    public void save() {
        this.Manifest.m_model.save();
    }

    public static class BuildPropertiesPart {
        private static final String BINARY_BUILD_INCLUDES = "bin.includes";
        private final LazyPluginModel m_model;

        private BuildPropertiesPart(LazyPluginModel m) {
            this.m_model = m;
        }

        public void removeBinaryBuildEntry(IResource resource) throws CoreException {
            if (resource == null) {
                return;
            }
            this.removeBinaryBuildEntry(PluginModelHelper.getProjectRelativeResourcePath(resource));
        }

        public void removeBinaryBuildEntry(String token) throws CoreException {
            if (token == null || token.length() < 1) {
                return;
            }
            IBuildEntry entry = this.m_model.getBuildModel().getBuild().getEntry(BINARY_BUILD_INCLUDES);
            if (entry != null) {
                entry.removeToken(token);
            }
        }

        public String[] getBinaryBuildEntries() {
            IBuildEntry entry = this.m_model.getBuildModel().getBuild().getEntry(BINARY_BUILD_INCLUDES);
            if (entry != null) {
                return entry.getTokens();
            }
            return new String[0];
        }

        private IBuildEntry getBuildEntry(String name) throws CoreException {
            IBuildEntry entry = this.m_model.getBuildModel().getBuild().getEntry(name);
            if (entry == null) {
                entry = this.m_model.getBuildModel().getFactory().createEntry(name);
                this.m_model.getBuildModel().getBuild().add(entry);
            }
            return entry;
        }

        public boolean existsBinaryBuildEntry(IResource resource) throws CoreException {
            if (resource == null) {
                return false;
            }
            return this.existsBinaryBuildEntry(PluginModelHelper.getProjectRelativeResourcePath(resource));
        }

        public boolean existsBinaryBuildEntry(String token) throws CoreException {
            if (token == null || token.length() < 1) {
                return false;
            }
            IBuildEntry entry = this.getBuildEntry(BINARY_BUILD_INCLUDES);
            return entry.contains(token);
        }

        public void addBinaryBuildEntry(IResource resource) throws CoreException {
            if (resource == null) {
                return;
            }
            if (!resource.exists()) {
                return;
            }
            this.addBinaryBuildEntry(PluginModelHelper.getProjectRelativeResourcePath(resource));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addBinaryBuildEntry(String token) throws CoreException {
            if (token == null || token.length() < 1) {
                return;
            }
            IProject iProject = this.m_model.getProject();
            synchronized (iProject) {
                IBuildEntry entry = this.getBuildEntry(BINARY_BUILD_INCLUDES);
                if (!entry.contains(token)) {
                    entry.addToken(token);
                }
            }
        }

        public IFile getFile() {
            return this.m_model.getBuildPropertiesFile();
        }
    }

    public static class ManifestPart {
        private final LazyPluginModel m_model;

        private ManifestPart(LazyPluginModel m) {
            this.m_model = m;
        }

        public void addDependency(String pluginId) throws CoreException {
            this.addDependency(pluginId, false);
        }

        public void addDependency(String pluginId, boolean reexport) throws CoreException {
            this.addDependency(pluginId, reexport, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addDependency(String pluginId, boolean reexport, boolean optional) throws CoreException {
            if (pluginId == null || pluginId.length() < 1) {
                return;
            }
            IProject iProject = this.m_model.getProject();
            synchronized (iProject) {
                IPluginModelBase pluginModelBase;
                if (!this.existsDependency(pluginId) && (pluginModelBase = this.m_model.getBundlePluginModel()) instanceof BundlePluginModelBase) {
                    IPluginImport imp = ((BundlePluginModelBase)pluginModelBase).createImport(pluginId);
                    imp.setReexported(reexport);
                    imp.setOptional(optional);
                    this.m_model.getPluginBase().add(imp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeDependency(String pluginId) throws CoreException {
            IProject iProject = this.m_model.getProject();
            synchronized (iProject) {
                IPluginImport existing = this.getDependency(pluginId);
                if (existing != null) {
                    this.m_model.getPluginBase().remove(existing);
                    RequireBundleHeader reqHeader = this.getRequireBundleHeader();
                    reqHeader.removeBundle(pluginId);
                    this.setEntryValue("Require-Bundle", reqHeader.getValue());
                }
            }
        }

        private String getHeaderValue(IManifestHeader header) {
            if (header == null || header.getValue() == null) {
                return "";
            }
            return header.getValue();
        }

        private RequireBundleHeader getRequireBundleHeader() {
            IManifestHeader header = this.m_model.getBundle().getManifestHeader("Require-Bundle");
            return (RequireBundleHeader)this.m_model.getBundleModel().getFactory().createHeader("Require-Bundle", this.getHeaderValue(header));
        }

        public boolean existsDependency(String pluginId) {
            IPluginImport existing = this.getDependency(pluginId);
            return existing != null;
        }

        public IPluginImport[] getAllDependencies() {
            return this.m_model.getPluginBase().getImports();
        }

        private IPluginImport getDependency(String pluginId) {
            if (pluginId == null || pluginId.length() < 1) {
                return null;
            }
            IPluginImport[] iPluginImportArray = this.m_model.getPluginBase().getImports();
            int n = iPluginImportArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginImport existing = iPluginImportArray[n2];
                if (existing.getId().equals(pluginId)) {
                    return existing;
                }
                ++n2;
            }
            return null;
        }

        public boolean existsExportPackage(IPackageFragment pck) {
            if (pck == null) {
                return false;
            }
            return this.existsExportPackage(pck.getElementName());
        }

        public boolean existsExportPackage(String packageName) {
            ExportPackageDescription[] exportPackages;
            if (packageName == null || packageName.length() < 1) {
                return false;
            }
            ExportPackageDescription[] exportPackageDescriptionArray = exportPackages = this.m_model.getBundleDescription().getExportPackages();
            int n = exportPackages.length;
            int n2 = 0;
            while (n2 < n) {
                ExportPackageDescription epd = exportPackageDescriptionArray[n2];
                if (packageName.equals(epd.getName())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public ExportPackageDescription[] getAllExportedPackages() {
            return this.m_model.getBundleDescription().getExportPackages();
        }

        public boolean existsImportPackage(String packageName) {
            ImportPackageSpecification[] importedPackages;
            if (packageName == null || packageName.length() < 1) {
                return false;
            }
            ImportPackageSpecification[] importPackageSpecificationArray = importedPackages = this.m_model.getBundleDescription().getImportPackages();
            int n = importedPackages.length;
            int n2 = 0;
            while (n2 < n) {
                ImportPackageSpecification ips = importPackageSpecificationArray[n2];
                if (packageName.equals(ips.getName())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public ImportPackageSpecification[] getAllImportedPackages() {
            return this.m_model.getBundleDescription().getImportPackages();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addImportPackage(String pck, String version) {
            if (pck == null || pck.length() < 1) {
                return;
            }
            IProject iProject = this.m_model.getProject();
            synchronized (iProject) {
                if (!this.existsImportPackage(pck)) {
                    ImportPackageHeader impHeader = this.getImportPackageHeader();
                    ImportPackageObject obj = new ImportPackageObject((ManifestHeader)impHeader, pck, version, this.getVersionAttribute());
                    impHeader.addPackage((PackageObject)obj);
                    this.setEntryValue("Import-Package", impHeader.getValue());
                }
            }
        }

        private String getVersionAttribute() {
            int manifestVersion = BundlePluginBase.getBundleManifestVersion((IBundle)this.m_model.getBundle());
            return manifestVersion < 2 ? "specification-version" : "version";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addExportPackage(String packageName) {
            if (packageName == null || packageName.length() < 1) {
                return;
            }
            IProject iProject = this.m_model.getProject();
            synchronized (iProject) {
                if (!this.existsExportPackage(packageName)) {
                    ExportPackageHeader expHeader = this.getExportPackageHeader();
                    expHeader.addPackage(packageName);
                    this.setEntryValue("Export-Package", expHeader.getValue());
                }
            }
        }

        public void addExportPackage(IPackageFragment pck) {
            this.addExportPackage(pck.getElementName());
        }

        public void removeExportPackage(IPackageFragment pck) {
            if (pck == null) {
                return;
            }
            this.removeExportPackage(pck.getElementName());
        }

        public void removeExportPackage(String packageName) {
            if (packageName == null || packageName.length() < 1) {
                return;
            }
            ExportPackageHeader expHeader = this.getExportPackageHeader();
            expHeader.removePackage(packageName);
            this.setEntryValue("Export-Package", expHeader.getValue());
        }

        public void removeImportPackage(String packageName) {
            if (packageName == null || packageName.length() < 1) {
                return;
            }
            ImportPackageHeader impHeader = this.getImportPackageHeader();
            impHeader.removePackage(packageName);
            this.setEntryValue("Import-Package", impHeader.getValue());
        }

        private ExportPackageHeader getExportPackageHeader() {
            IManifestHeader header = this.m_model.getBundle().getManifestHeader("Export-Package");
            return (ExportPackageHeader)this.m_model.getBundleModel().getFactory().createHeader("Export-Package", this.getHeaderValue(header));
        }

        private ImportPackageHeader getImportPackageHeader() {
            IManifestHeader header = this.m_model.getBundle().getManifestHeader("Import-Package");
            return (ImportPackageHeader)this.m_model.getBundleModel().getFactory().createHeader("Import-Package", this.getHeaderValue(header));
        }

        private BundleClasspathHeader getBundleClasspathHeader() {
            IManifestHeader header = this.m_model.getBundle().getManifestHeader("Bundle-ClassPath");
            return (BundleClasspathHeader)this.m_model.getBundleModel().getFactory().createHeader("Bundle-ClassPath", this.getHeaderValue(header));
        }

        public void setEntryValue(String key, String value) {
            if (key == null || key.length() < 1) {
                return;
            }
            this.m_model.getBundle().setHeader(key, value);
        }

        public void removeEntry(String key) {
            this.setEntryValue(key, null);
        }

        public String getEntry(String key) {
            return this.m_model.getBundle().getHeader(key);
        }

        public String[] getAllClasspathEntries() {
            BundleClasspathHeader h = this.getBundleClasspathHeader();
            Vector names = h.getElementNames();
            return names.toArray(new String[names.size()]);
        }

        public void removeClasspathEntry(IResource resource) {
            if (resource == null) {
                return;
            }
            this.removeClasspathEntry(PluginModelHelper.getProjectRelativeResourcePath(resource));
        }

        public void removeClasspathEntry(String entry) {
            if (entry == null || entry.length() < 1) {
                return;
            }
            BundleClasspathHeader h = this.getBundleClasspathHeader();
            h.removeLibrary(entry);
            this.setEntryValue("Bundle-ClassPath", h.getValue());
        }

        public void addClasspathDefaultEntry() {
            this.addClasspathEntry(".");
        }

        public boolean existsClasspathEntry(IResource resource) {
            if (resource == null) {
                return false;
            }
            return this.existsClasspathEntry(PluginModelHelper.getProjectRelativeResourcePath(resource));
        }

        public boolean existsClasspathEntry(String entry) {
            if (entry == null || entry.length() < 1) {
                return false;
            }
            String[] stringArray = this.getAllClasspathEntries();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String e = stringArray[n2];
                if (e.equals(entry)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void addClasspathEntry(IResource resource) {
            if (resource == null) {
                return;
            }
            if (!resource.exists()) {
                return;
            }
            this.addClasspathEntry(PluginModelHelper.getProjectRelativeResourcePath(resource));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addClasspathEntry(String entry) {
            if (entry == null || entry.length() < 1) {
                return;
            }
            IProject iProject = this.m_model.getProject();
            synchronized (iProject) {
                if (!this.existsClasspathEntry(entry)) {
                    BundleClasspathHeader h = this.getBundleClasspathHeader();
                    h.addLibrary(entry);
                    this.setEntryValue("Bundle-ClassPath", h.getValue());
                }
            }
        }

        public void setVersion(Version newVersion) {
            if (newVersion == null) {
                return;
            }
            this.setVersion(newVersion.toString());
        }

        public void setVersion(String newVersion) {
            if (newVersion == null || newVersion.length() < 1) {
                return;
            }
            this.setEntryValue("Bundle-Version", newVersion);
        }

        public Version getVersion() {
            return this.m_model.getBundleDescription().getVersion();
        }

        public String getVersionAsString() {
            return this.m_model.getBundleDescription().getVersion().toString();
        }

        public IFile getFile() {
            return this.m_model.getManifestFile();
        }
    }

    public static class PluginXmlPart {
        private final LazyPluginModel m_model;

        private PluginXmlPart(LazyPluginModel m) {
            this.m_model = m;
        }

        public void addSimpleExtension(String extensionPointId, String elementName, Map<String, String> attributes) throws CoreException {
            IPluginExtension pe = null;
            IPluginExtension[] iPluginExtensionArray = this.m_model.getExtensionsModel().getExtensions().getExtensions();
            int n = iPluginExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginExtension existing = iPluginExtensionArray[n2];
                if (existing.getPoint().equals(extensionPointId)) {
                    pe = existing;
                    break;
                }
                ++n2;
            }
            if (pe == null) {
                pe = this.m_model.getExtensionsModel().createExtension();
                pe.setPoint(extensionPointId);
                this.m_model.getExtensionsModel().getExtensions().add(pe);
            }
            IPluginElement extension = this.m_model.getExtensionsModel().createElement((IPluginObject)pe);
            extension.setName(elementName);
            if (attributes != null && attributes.size() > 0) {
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    extension.setAttribute(entry.getKey(), entry.getValue());
                }
            }
            pe.add((IPluginObject)extension);
        }

        public void addSimpleExtension(String extensionPointId, String elementName) throws CoreException {
            this.addSimpleExtension(extensionPointId, elementName, null);
        }

        public void removeSimpleExtension(String extensionPointId, String elementName, Map<String, String> attributes) throws CoreException {
            IPluginElement[] toDeleteList;
            IPluginElement[] iPluginElementArray = toDeleteList = this.getSimpleExtensions(extensionPointId, elementName, attributes);
            int n = toDeleteList.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginElement toDelete = iPluginElementArray[n2];
                if (toDelete.getParent() instanceof IPluginExtension) {
                    ((IPluginExtension)toDelete.getParent()).remove((IPluginObject)toDelete);
                }
                ++n2;
            }
        }

        public void removeSimpleExtension(String extensionPointId, String elementName) throws CoreException {
            this.removeSimpleExtension(extensionPointId, elementName, null);
        }

        public void removeExtensionPoint(String extensionPointId) throws CoreException {
            List<IPluginExtension> pluginExtensionPoints = this.getPluginExtensionPoints(extensionPointId);
            for (IPluginExtension point : pluginExtensionPoints) {
                if (!(point.getParent() instanceof IBundlePlugin)) continue;
                ((IBundlePlugin)point.getParent()).remove(point);
            }
        }

        public IPluginElement[] getSimpleExtensions(String extensionPointId, String elementName, Map<String, String> attributes) {
            List<IPluginElement> candidates = this.getPluginExtensions(extensionPointId);
            Iterator<IPluginElement> it = candidates.iterator();
            block0: while (it.hasNext()) {
                IPluginElement candidate = it.next();
                if (!elementName.equals(candidate.getName())) {
                    it.remove();
                    continue;
                }
                if (attributes == null || attributes.size() <= 0) continue;
                for (Map.Entry<String, String> entry : attributes.entrySet()) {
                    IPluginAttribute a = candidate.getAttribute(entry.getKey());
                    if (a == null) {
                        it.remove();
                        continue block0;
                    }
                    if (!CompareUtility.notEquals((Object)entry.getValue(), (Object)a.getValue())) continue;
                    it.remove();
                    continue block0;
                }
            }
            return candidates.toArray(new IPluginElement[candidates.size()]);
        }

        public IPluginElement[] getSimpleExtensions(String extensionPointId, String elementName) {
            return this.getSimpleExtensions(extensionPointId, elementName, null);
        }

        private List<IPluginExtension> getPluginExtensionPoints(String extensionPointId) {
            LinkedList<IPluginExtension> result = new LinkedList<IPluginExtension>();
            IPluginExtension[] iPluginExtensionArray = this.m_model.getBundlePluginModel().getExtensions(true).getExtensions();
            int n = iPluginExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginExtension extPoint = iPluginExtensionArray[n2];
                if (extPoint.getPoint().equals(extensionPointId)) {
                    result.add(extPoint);
                }
                ++n2;
            }
            return result;
        }

        private List<IPluginElement> getPluginExtensions(String extensionPointId) {
            LinkedList<IPluginElement> result = new LinkedList<IPluginElement>();
            for (IPluginExtension extPoint : this.getPluginExtensionPoints(extensionPointId)) {
                IPluginObject[] iPluginObjectArray = extPoint.getChildren();
                int n = iPluginObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPluginObject element = iPluginObjectArray[n2];
                    if (element instanceof IPluginElement) {
                        result.add((IPluginElement)element);
                    }
                    ++n2;
                }
            }
            return result;
        }

        public IPluginElement getSimpleExtension(String extensionPointId, String elementName, Map<String, String> attributes) {
            IPluginElement[] matches = this.getSimpleExtensions(extensionPointId, elementName, attributes);
            if (matches != null && matches.length > 0) {
                return matches[0];
            }
            return null;
        }

        public IPluginElement getSimpleExtension(String extensionPointId, String elementName) {
            return this.getSimpleExtension(extensionPointId, elementName, null);
        }

        public boolean existsSimpleExtension(String extensionPointId, String elementName, Map<String, String> attributes) {
            IPluginElement[] matches = this.getSimpleExtensions(extensionPointId, elementName, attributes);
            return matches != null && matches.length > 0;
        }

        public boolean existsSimpleExtension(String extensionPointId, String elementName) {
            return this.existsSimpleExtension(extensionPointId, elementName, null);
        }

        public IFile getFile() {
            return this.m_model.getPluginXmlFile();
        }
    }
}

