/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.resources;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;

public class ResourceProxy
implements IResourceProxy {
    private final IResource m_resource;

    public ResourceProxy(IResource r) {
        this.m_resource = r;
    }

    public long getModificationStamp() {
        return this.m_resource.getModificationStamp();
    }

    public boolean isAccessible() {
        return this.m_resource.isAccessible();
    }

    public boolean isDerived() {
        return this.m_resource.isDerived();
    }

    public boolean isLinked() {
        return this.m_resource.isLinked();
    }

    public boolean isPhantom() {
        return this.m_resource.isPhantom();
    }

    public boolean isHidden() {
        return this.m_resource.isHidden();
    }

    public boolean isTeamPrivateMember() {
        return this.m_resource.isTeamPrivateMember();
    }

    public String getName() {
        return this.m_resource.getName();
    }

    public Object getSessionProperty(QualifiedName key) {
        try {
            return this.m_resource.getSessionProperty(key);
        }
        catch (CoreException e) {
            SdkUtilActivator.logError("unable to retrieve session property '" + key.toString() + "' from resource '" + this.m_resource.getFullPath().toOSString() + "'.", e);
            return null;
        }
    }

    public int getType() {
        return this.m_resource.getType();
    }

    public IPath requestFullPath() {
        return this.m_resource.getFullPath();
    }

    public IResource requestResource() {
        return this.m_resource;
    }
}

