/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.signature.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.scout.sdk.util.signature.ITypeGenericMapping;

public class TypeGenericMapping
implements ITypeGenericMapping {
    private final String m_fullyQualifiedName;
    private final Map<String, String> m_parameters;

    public TypeGenericMapping(String fullyQualliefiedName) {
        this.m_fullyQualifiedName = fullyQualliefiedName;
        this.m_parameters = new LinkedHashMap<String, String>();
    }

    @Override
    public String getFullyQualifiedName() {
        return this.m_fullyQualifiedName;
    }

    public void addParameter(String name, String signature) {
        this.m_parameters.put(name, signature);
    }

    @Override
    public String getParameterSignature(String paramName) {
        return this.m_parameters.get(paramName);
    }

    @Override
    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.m_parameters);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getFullyQualifiedName());
        builder.append('{');
        if (!this.m_parameters.isEmpty()) {
            Iterator<Map.Entry<String, String>> iterator = this.m_parameters.entrySet().iterator();
            Map.Entry<String, String> e = iterator.next();
            builder.append(e.getKey()).append(" -> ").append(e.getValue());
            while (iterator.hasNext()) {
                e = iterator.next();
                builder.append(" | ").append(e.getKey()).append(" -> ").append(e.getValue());
            }
        }
        builder.append('}');
        return builder.toString();
    }
}

