/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.service.IService;
import org.eclipse.scout.service.IServiceInitializer;
import org.eclipse.scout.service.IServiceInitializerFactory;
import org.eclipse.scout.service.internal.Activator;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractService
implements IService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractService.class);

    @Override
    public void initializeService(ServiceRegistration registration) {
        Activator activator = Activator.getDefault();
        if (activator == null || activator.getServicesExtensionManager() == null) {
            LOG.error("Could not initialize service. " + this.getClass().getName());
            return;
        }
        ArrayList<IServiceInitializer> initializers = new ArrayList<IServiceInitializer>();
        Collection<IServiceInitializerFactory> factories = activator.getServicesExtensionManager().getServiceIntializerFactories();
        for (IServiceInitializerFactory factory : factories) {
            IServiceInitializer serviceInitializer = factory.createInstance(this);
            if (serviceInitializer == null) continue;
            initializers.add(serviceInitializer);
        }
        Comparator<IServiceInitializer> priorityComparator = new Comparator<IServiceInitializer>(){

            @Override
            public int compare(IServiceInitializer o1, IServiceInitializer o2) {
                return (int)((o1.getRunOrder() - o2.getRunOrder()) * 100.0);
            }
        };
        Collections.sort(initializers, priorityComparator);
        for (IServiceInitializer initializer : initializers) {
            IServiceInitializer.ServiceInitializerResult res = initializer.initializeService(this);
            if (IServiceInitializer.ServiceInitializerResult.STOP.equals((Object)res)) break;
        }
    }

    public void disposeServices() {
    }
}

