/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.ui.tools.api.profiler.view;

import java.text.Collator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.profiler.ProfilerEvent;
import org.eclipse.sirius.common.tools.api.profiler.ProfilerListener;
import org.eclipse.sirius.common.tools.api.profiler.TimeProfiler2;
import org.eclipse.sirius.common.ui.tools.api.profiler.InitProfilerAction;
import org.eclipse.sirius.common.ui.tools.api.profiler.view.TimeProfiler2TreeViewContentProvider;
import org.eclipse.sirius.common.ui.tools.api.profiler.view.TimeProfiler2ViewLabelProvider;
import org.eclipse.sirius.common.ui.tools.api.profiler.view.TimeProfilerViewItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.part.ViewPart;

public class TimeProfilerView
extends ViewPart
implements ProfilerListener {
    public static final String ID = "org.eclipse.sirius.common.ui.view.timeProfiler";
    private TreeViewer viewer;
    private InitProfilerAction initProfilerAction;
    private IAction refreshAction;
    private IAction printAction;
    private ViewerSorter categorySorter = new ViewerSorter(){

        public int compare(Viewer v, Object e1, Object e2) {
            int result;
            if (e1 instanceof TimeProfilerViewItem && e2 instanceof TimeProfilerViewItem) {
                String category1 = ((TimeProfilerViewItem)e1).getTask().getCategory();
                String category2 = ((TimeProfilerViewItem)e2).getTask().getCategory();
                result = Collator.getInstance().compare(category1, category2);
            } else if (e1 instanceof TimeProfiler2.CompositeTask && e2 instanceof TimeProfiler2.CompositeTask) {
                if (e1 == TimeProfiler2.OTHER_TASK) {
                    result = 1;
                } else if (e2 == TimeProfiler2.OTHER_TASK) {
                    result = -1;
                } else {
                    String category1 = ((TimeProfiler2.CompositeTask)e1).getProfilerTask().getCategory();
                    String category2 = ((TimeProfiler2.CompositeTask)e2).getProfilerTask().getCategory();
                    result = Collator.getInstance().compare(category1, category2);
                }
            } else {
                result = super.compare(v, e1, e2);
            }
            return result;
        }
    };
    private ViewerSorter nameSorter = new ViewerSorter(){

        public int compare(Viewer v, Object e1, Object e2) {
            int comparison;
            if (e1 instanceof TimeProfilerViewItem && e2 instanceof TimeProfilerViewItem) {
                String task1 = ((TimeProfilerViewItem)e1).getTask().getName();
                String task2 = ((TimeProfilerViewItem)e2).getTask().getName();
                comparison = Collator.getInstance().compare(task1, task2);
            } else if (e1 instanceof TimeProfiler2.CompositeTask && e2 instanceof TimeProfiler2.CompositeTask) {
                if (e1 == TimeProfiler2.OTHER_TASK) {
                    comparison = 1;
                } else if (e2 == TimeProfiler2.OTHER_TASK) {
                    comparison = -1;
                } else {
                    String task1 = ((TimeProfiler2.CompositeTask)e1).getProfilerTask().getName();
                    String task2 = ((TimeProfiler2.CompositeTask)e2).getProfilerTask().getName();
                    comparison = Collator.getInstance().compare(task1, task2);
                }
            } else {
                comparison = super.compare(v, e1, e2);
            }
            return comparison;
        }
    };
    private ViewerSorter timeSorter = new ViewerSorter(){

        public int compare(Viewer v, Object e1, Object e2) {
            long time2;
            long time1;
            long tmp;
            int comparison = e1 instanceof TimeProfilerViewItem && e2 instanceof TimeProfilerViewItem ? ((tmp = (time1 = ((TimeProfilerViewItem)e1).getTime().longValue()) - (time2 = ((TimeProfilerViewItem)e2).getTime().longValue())) > Integer.MAX_VALUE ? 1 : (tmp < Integer.MIN_VALUE ? -1 : (int)tmp)) : (e1 instanceof TimeProfiler2.CompositeTask && e2 instanceof TimeProfiler2.CompositeTask ? ((tmp = (time1 = ((TimeProfiler2.CompositeTask)e1).getEllapsedTime()) - (time2 = ((TimeProfiler2.CompositeTask)e2).getEllapsedTime())) > Integer.MAX_VALUE ? 1 : (tmp < Integer.MIN_VALUE ? -1 : (int)tmp)) : super.compare(v, e1, e2));
            return comparison;
        }
    };
    private ViewerSorter occurencesSorter = new ViewerSorter(){

        public int compare(Viewer v, Object e1, Object e2) {
            long occurences2;
            int occurences1;
            long tmp;
            int comparison = e1 instanceof TimeProfilerViewItem && e2 instanceof TimeProfilerViewItem ? ((tmp = (long)(occurences1 = ((TimeProfilerViewItem)e1).getOccurences().intValue()) - (occurences2 = (long)((TimeProfilerViewItem)e2).getOccurences().intValue())) > Integer.MAX_VALUE ? 1 : (tmp < Integer.MIN_VALUE ? -1 : (int)tmp)) : (e1 instanceof TimeProfiler2.CompositeTask && e2 instanceof TimeProfiler2.CompositeTask ? (e1 == TimeProfiler2.OTHER_TASK ? 1 : (e2 == TimeProfiler2.OTHER_TASK ? -1 : ((tmp = (long)(occurences1 = ((TimeProfiler2.CompositeTask)e1).getOccurences()) - (occurences2 = (long)((TimeProfiler2.CompositeTask)e2).getOccurences())) > Integer.MAX_VALUE ? 1 : (tmp < Integer.MIN_VALUE ? -1 : (int)tmp)))) : super.compare(v, e1, e2));
            return comparison;
        }
    };
    private InverseViewerSorter inverseSorter = new InverseViewerSorter();

    public TimeProfilerView() {
        DslCommonPlugin.PROFILER.addProfilerListener((ProfilerListener)this);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 66304);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.setLabelProvider((IBaseLabelProvider)new TimeProfiler2ViewLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new TimeProfiler2TreeViewContentProvider());
        String[] columnNames = new String[]{"Task Category", "Task Name", "Time (ms)", "Occurences", "Minimum", "Maximum", "Average"};
        int[] columnWidths = new int[]{100, 100, 100, 100, 100, 100, 100};
        int[] columnAlignments = new int[]{16384, 16384, 131072, 131072, 131072, 131072, 131072};
        int i = 0;
        while (i < columnNames.length) {
            final TreeColumn treeColumn = new TreeColumn(this.viewer.getTree(), 0x10000 | columnAlignments[i]);
            treeColumn.setText(columnNames[i]);
            treeColumn.setWidth(columnWidths[i]);
            final int index = i++;
            treeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TimeProfilerView.this.setSorter(index);
                    TimeProfilerView.this.viewer.getTree().setSortDirection(TimeProfilerView.this.viewer.getTree().getSortDirection() == 128 ? 1024 : 128);
                    TimeProfilerView.this.viewer.getTree().setSortColumn(treeColumn);
                }
            });
        }
        this.createActions();
        this.createContextMenu();
        this.createToolbarButtons();
        this.viewer.setSorter(this.categorySorter);
        this.viewer.setInput((Object)DslCommonPlugin.PROFILER);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void taskStarted(ProfilerEvent event) {
    }

    public void taskStopped(ProfilerEvent event) {
    }

    private void createActions() {
        this.initProfilerAction = new InitProfilerAction(this.viewer);
        this.initProfilerAction.setText("Reinit profiler");
        this.refreshAction = new Action(){

            public void run() {
                TimeProfilerView.this.viewer.refresh();
            }
        };
        this.refreshAction.setText("Refresh View");
        this.printAction = new Action(){

            public void run() {
                System.out.println(DslCommonPlugin.PROFILER.getStatus());
            }
        };
        this.printAction.setText("Print to console");
    }

    private void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TimeProfilerView.this.fillContextMenu(manager);
            }
        });
    }

    private void fillContextMenu(IMenuManager menuManager) {
        menuManager.add((IAction)this.initProfilerAction);
        menuManager.add(this.refreshAction);
        menuManager.add(this.printAction);
        menuManager.add((IContributionItem)new Separator("additions"));
    }

    private void createToolbarButtons() {
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.initProfilerAction);
        this.getViewSite().getActionBars().getToolBarManager().add(this.refreshAction);
        this.getViewSite().getActionBars().getToolBarManager().add(this.printAction);
    }

    public void profilerReinited(ProfilerEvent event) {
    }

    private void setSorter(int column) {
        switch (column) {
            case 0: {
                if (this.viewer.getSorter() != this.categorySorter) {
                    this.viewer.setSorter(this.categorySorter);
                    break;
                }
                this.inverseSorter.setSorter(this.categorySorter);
                this.viewer.setSorter((ViewerSorter)this.inverseSorter);
                break;
            }
            case 1: {
                if (this.viewer.getSorter() != this.nameSorter) {
                    this.viewer.setSorter(this.nameSorter);
                    break;
                }
                this.inverseSorter.setSorter(this.nameSorter);
                this.viewer.setSorter((ViewerSorter)this.inverseSorter);
                break;
            }
            case 2: {
                if (this.viewer.getSorter() != this.timeSorter) {
                    this.viewer.setSorter(this.timeSorter);
                    break;
                }
                this.inverseSorter.setSorter(this.timeSorter);
                this.viewer.setSorter((ViewerSorter)this.inverseSorter);
                break;
            }
            case 3: {
                if (this.viewer.getSorter() != this.occurencesSorter) {
                    this.viewer.setSorter(this.occurencesSorter);
                    break;
                }
                this.inverseSorter.setSorter(this.occurencesSorter);
                this.viewer.setSorter((ViewerSorter)this.inverseSorter);
                break;
            }
        }
    }

    private static class InverseViewerSorter
    extends ViewerSorter {
        private ViewerSorter sorter;

        private InverseViewerSorter() {
        }

        public void setSorter(ViewerSorter sorter) {
            this.sorter = sorter;
        }

        public int compare(Viewer v, Object e1, Object e2) {
            return this.sorter == null ? super.compare(v, e1, e2) : -this.sorter.compare(v, e1, e2);
        }
    }
}

