/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.resource;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.sirius.common.tools.api.query.NotificationQuery;
import org.eclipse.sirius.common.tools.api.resource.AbstractResourceSyncBackend;
import org.eclipse.sirius.common.tools.api.resource.FileModificationValidatorProvider;
import org.eclipse.sirius.common.tools.api.resource.IFileModificationValidator;
import org.eclipse.sirius.common.tools.api.resource.ResourceSyncClient;
import org.eclipse.sirius.common.tools.internal.resource.WorkspaceBackend;

public final class ResourceSetSync
extends ResourceSetListenerImpl
implements ResourceSyncClient {
    public static final String CDO_URI_SCHEME = "cdo";
    private static final String FILE_MODIFICATION_VALIDATION_STATUS = "File modification validation status";
    private boolean notificationIsRequired = true;
    private final List<AbstractResourceSyncBackend> backends = Lists.newArrayList();
    private final List<ResourceSyncClient> clients = Lists.newArrayList();
    private final Map<Resource, ResourceStatus> statuses = Maps.newHashMap();
    private Collection<Resource> savedResources = Sets.newLinkedHashSet();
    private final ArrayList<IFileModificationValidator> fileModificationValidators;

    private ResourceSetSync() {
        super(NotificationFilter.ANY);
        this.addDefaultBackends();
        this.fileModificationValidators = FileModificationValidatorProvider.INSTANCE.getFileModificationValidator();
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        ArrayList changes = Lists.newArrayList();
        for (Notification notif : Iterables.filter((Iterable)event.getNotifications(), Notification.class)) {
            if (!this.isCustom(notif)) {
                this.notifyChanged(notif, changes);
            }
            if (!(notif.getNotifier() instanceof ResourceSet) || !(notif.getNewValue() instanceof Resource)) continue;
            if (notif.getEventType() == 3) {
                this.newResourceOnTheResourceSet((Resource)notif.getNewValue(), changes);
                continue;
            }
            if (notif.getEventType() != 4) continue;
            this.removeResource((Resource)notif.getNewValue());
        }
        this.notifyClientsInBatch(changes);
    }

    private boolean isCustom(Notification notif) {
        return notif.getEventType() == -1;
    }

    public static ResourceSetSync getOrInstallResourceSetSync(TransactionalEditingDomain domain) {
        ResourceSetSync sync = ResourceSetSync.getResourceSetSync(domain.getResourceSet());
        if (sync == null) {
            sync = new ResourceSetSync();
            sync.setTarget(domain.getResourceSet());
            sync.install();
            domain.addResourceSetListener((ResourceSetListener)sync);
        }
        return sync;
    }

    private static ResourceSetSync getResourceSetSync(ResourceSet resourceSet) {
        UnmodifiableIterator it;
        if (resourceSet != null && (it = Iterators.filter((Iterator)resourceSet.eAdapters().iterator(), MarkerAdapter.class)).hasNext()) {
            return ((MarkerAdapter)((Object)it.next())).getSync();
        }
        return null;
    }

    public static ResourceStatus getStatus(Resource res) {
        ResourceSetSync rss;
        ResourceSet rs;
        ResourceStatus result = ResourceStatus.UNKNOWN;
        if (res.isModified()) {
            result = ResourceStatus.CHANGED;
        }
        if ((rs = res.getResourceSet()) != null && (rss = ResourceSetSync.getResourceSetSync(rs)) != null) {
            result = rss.getResourceStatus(res);
        }
        return result;
    }

    public static boolean isReadOnly(Resource resource) {
        boolean readonly = false;
        URI resourceURI = resource.getURI();
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceURI != null && (EPackage.Registry.INSTANCE.containsKey((Object)resourceURI.toString()) || resourceSet != null && Boolean.TRUE.equals(resourceSet.getURIConverter().getAttributes(resourceURI, null).get("readOnly")))) {
            readonly = true;
        }
        return readonly;
    }

    public static void uninstallResourceSetSync(TransactionalEditingDomain domain) {
        ResourceSetSync sync = ResourceSetSync.getResourceSetSync(domain.getResourceSet());
        if (sync != null) {
            sync.uninstall();
            for (MarkerAdapter adapter : Lists.newArrayList((Iterable)Iterables.filter((Iterable)domain.getResourceSet().eAdapters(), MarkerAdapter.class))) {
                domain.getResourceSet().eAdapters().remove((Object)adapter);
            }
            domain.removeResourceSetListener((ResourceSetListener)sync);
        }
    }

    private void addDefaultBackends() {
        this.backends.add(new WorkspaceBackend(this));
    }

    private ResourceStatus getResourceStatus(Resource res) {
        return this.retrieveOldStatus(res);
    }

    protected void install() {
        for (AbstractResourceSyncBackend backend : this.backends) {
            backend.install();
        }
    }

    private boolean isLoading(Resource resource) {
        if (resource instanceof ResourceImpl) {
            return ((ResourceImpl)resource).isLoading();
        }
        return false;
    }

    private void newResourceOnTheResourceSet(Resource res, Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        if (res.isModified()) {
            this.resourceNewStatus(res, ResourceStatus.CHANGED, changes);
        }
    }

    private void removeResource(Resource newValue) {
        this.statuses.remove(newValue);
    }

    public void notifyChanged(Notification notification, Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof EObject && !notification.isTouch() && !new NotificationQuery(notification).isTransientNotification()) {
            Resource resource = ((EObject)notifier).eResource();
            if (resource != null) {
                this.handleResourceChange(resource, changes);
            }
        } else if (notifier instanceof Resource) {
            Resource res = (Resource)notifier;
            if (notification.getFeatureID(null) == 3 && !res.isModified()) {
                this.resourceNewStatus(res, ResourceStatus.SYNC, changes);
            } else if (notification.getFeatureID(null) == 2) {
                this.handleResourceChange(res, changes);
            }
        }
    }

    private void handleResourceChange(Resource resource, Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        if (resource.isLoaded() && !this.isLoading(resource)) {
            this.resourceNewStatus(resource, ResourceStatus.CHANGED, changes);
        } else {
            this.resourceNewStatus(resource, ResourceStatus.SYNC, changes);
        }
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public void registerClient(ResourceSyncClient client) {
        this.clients.add(client);
    }

    private ResourceStatus retrieveOldStatus(Resource resource) {
        ResourceStatus status = this.statuses.get(resource);
        if (status == null) {
            status = ResourceStatus.UNKNOWN;
        }
        return status;
    }

    public void setNotificationIsRequired(boolean newValue) {
        this.notificationIsRequired = newValue;
    }

    private void resourceNewStatus(Resource resource, ResourceStatus newStatus, Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        ResourceStatus oldStatus = this.retrieveOldStatus(resource);
        if (!(oldStatus == newStatus || resource.getURI() != null && resource.getURI().isPlatformPlugin())) {
            this.statuses.put(resource, newStatus);
            changes.add(new ResourceSyncClient.ResourceStatusChange(resource, newStatus, oldStatus));
            this.notifyClientsWhileProcessing(resource, newStatus, oldStatus);
        }
    }

    private void notifyClientsWhileProcessing(Resource resource, ResourceStatus newStatus, ResourceStatus oldStatus) {
        if (this.notificationIsRequired) {
            for (ResourceSyncClient client : Lists.newArrayList(this.clients)) {
                client.statusChanged(resource, oldStatus, newStatus);
            }
        }
    }

    private void notifyClientsInBatch(Collection<ResourceSyncClient.ResourceStatusChange> changes) {
        if (this.notificationIsRequired && changes.size() > 0) {
            for (ResourceSyncClient client : Lists.newArrayList(this.clients)) {
                client.statusesChanged(changes);
            }
        }
    }

    protected void setTarget(ResourceSet target) {
        target.eAdapters().add((Object)new MarkerAdapter(this));
        for (AbstractResourceSyncBackend backend : this.backends) {
            backend.setResourceSet(target);
        }
    }

    @Override
    public void statusChanged(Resource resource, ResourceStatus oldStatus, ResourceStatus newStatus) {
        this.statusesChanged(Collections.singletonList(new ResourceSyncClient.ResourceStatusChange(resource, newStatus, oldStatus)));
    }

    @Override
    public void statusesChanged(Collection<ResourceSyncClient.ResourceStatusChange> changesFromBackend) {
        LinkedHashSet changesToTransmit = Sets.newLinkedHashSet();
        for (ResourceSyncClient.ResourceStatusChange changeFromWorkspace : changesFromBackend) {
            if (this.itsAChangeWeReExpectingFromOurSave(changeFromWorkspace.getResource(), changeFromWorkspace.getNewStatus())) continue;
            this.resourceNewStatus(changeFromWorkspace.getResource(), changeFromWorkspace.getNewStatus(), changesToTransmit);
        }
        this.notifyClientsInBatch(changesToTransmit);
    }

    private boolean itsAChangeWeReExpectingFromOurSave(Resource resource, ResourceStatus newStatus) {
        return (newStatus == ResourceStatus.EXTERNAL_CHANGED || newStatus == ResourceStatus.CONFLICTING_CHANGED || newStatus == ResourceStatus.SYNC) && this.savedResources.remove(resource);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (Map.Entry<Resource, ResourceStatus> entry : this.statuses.entrySet()) {
            buff.append(entry.getKey().getURI());
            buff.append(":");
            buff.append((Object)entry.getValue());
        }
        return buff.toString();
    }

    protected void uninstall() {
        for (AbstractResourceSyncBackend backend : this.backends) {
            backend.uninstall();
        }
        this.statuses.clear();
    }

    public void unregisterClient(ResourceSyncClient client) {
        this.clients.remove(client);
    }

    public void save(Iterable<Resource> resourcesToSave, Iterable<Resource> resourcesToUpdateStatus, Map<?, ?> saveOptions) throws IOException, InterruptedException {
        LinkedHashSet changesToTransmit = Sets.newLinkedHashSet();
        this.doSave(resourcesToSave, saveOptions, changesToTransmit);
        for (Resource resource : resourcesToUpdateStatus) {
            ResourceStatus oldStatus = this.retrieveOldStatus(resource);
            if (oldStatus != ResourceStatus.UNKNOWN && oldStatus != ResourceStatus.CHANGED) continue;
            this.resourceNewStatus(resource, ResourceStatus.SYNC, changesToTransmit);
        }
        this.notifyClientsInBatch(changesToTransmit);
    }

    private void doSave(Iterable<Resource> resourcesToSave, Map<?, ?> saveOptions, Collection<ResourceSyncClient.ResourceStatusChange> changesToTransmit) throws InterruptedException, IOException {
        ArrayList files2Validate = Lists.newArrayList();
        for (Resource nextResource : resourcesToSave) {
            IFile file = WorkspaceSynchronizer.getFile((Resource)nextResource);
            if (file == null || !file.isReadOnly()) continue;
            files2Validate.add(file);
        }
        if (files2Validate.size() > 0) {
            MultiStatus status = new MultiStatus("org.eclipse.sirius.common", 4, FILE_MODIFICATION_VALIDATION_STATUS, null);
            if (this.fileModificationValidators.size() == 0) {
                status.add(ResourcesPlugin.getWorkspace().validateEdit(files2Validate.toArray(new IFile[files2Validate.size()]), IWorkspace.VALIDATE_PROMPT));
            } else {
                for (IFileModificationValidator fileModificationValidator : this.fileModificationValidators) {
                    IStatus validationStatus = fileModificationValidator.validateEdit(files2Validate);
                    if (validationStatus == null) continue;
                    status.add(validationStatus);
                    if (!validationStatus.isOK()) break;
                }
            }
            if (status.getChildren().length == 0 || !status.isOK()) {
                throw new InterruptedException(String.valueOf(status.getPlugin()) + ":" + status.getMessage());
            }
        }
        this.savedResources = Sets.newLinkedHashSet();
        for (Resource resource : resourcesToSave) {
            try {
                this.savedResources.add(resource);
                resource.save(saveOptions);
                resource.setModified(false);
            }
            catch (UnknownServiceException unknownServiceException) {}
        }
        for (Resource res : resourcesToSave) {
            this.resourceNewStatus(res, ResourceStatus.SYNC, changesToTransmit);
        }
    }

    public void addFileModificationValidator(IFileModificationValidator fileModificationValidator) {
        this.fileModificationValidators.add(fileModificationValidator);
    }

    public void removeFileModificationValidator(IFileModificationValidator fileModificationValidator) {
        this.fileModificationValidators.remove(fileModificationValidator);
    }

    class MarkerAdapter
    extends AdapterImpl {
        private ResourceSetSync synchronizer;

        public MarkerAdapter(ResourceSetSync synchronizer) {
            this.synchronizer = synchronizer;
        }

        public ResourceSetSync getSync() {
            return this.synchronizer;
        }
    }

    public static enum ResourceStatus {
        CHANGED,
        EXTERNAL_CHANGED,
        CONFLICTING_CHANGED,
        CONFLICTING_DELETED,
        DELETED,
        SYNC,
        UNKNOWN;

    }
}

