/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.operation;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerInterpreter;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.InstanceRole;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.RefreshOrderingHelper;
import org.eclipse.sirius.diagram.sequence.description.DescriptionPackage;
import org.eclipse.sirius.diagram.sequence.description.SequenceDiagramDescription;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.EventEndsOrdering;
import org.eclipse.sirius.diagram.sequence.ordering.InstanceRolesOrdering;
import org.eclipse.sirius.diagram.ui.business.internal.operation.AbstractModelChangeOperation;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;

public class RefreshSemanticOrderingsOperation
extends AbstractModelChangeOperation<Void> {
    private static final String EVENT_ENDS_TO_SORT_VARIABLE = "eventEnds";
    private final SequenceDDiagram sequenceDDiagram;

    public RefreshSemanticOrderingsOperation(SequenceDDiagram diagram) {
        super("Refresh semantic ordering");
        this.sequenceDDiagram = (SequenceDDiagram)Preconditions.checkNotNull((Object)diagram);
    }

    public Void execute() {
        EventEndsOrdering semanticOrdering = this.sequenceDDiagram.getSemanticOrdering();
        if (semanticOrdering != null) {
            this.refreshGlobalOrdering(semanticOrdering);
        }
        InstanceRolesOrdering irSemanticOrdering = this.sequenceDDiagram.getInstanceRoleSemanticOrdering();
        if (semanticOrdering != null) {
            this.refreshGlobalOrdering(irSemanticOrdering);
        }
        return null;
    }

    private void refreshGlobalOrdering(EventEndsOrdering semanticOrdering) {
        Iterable<? extends EventEnd> allEnds = RefreshOrderingHelper.getAllEventEnds(this.sequenceDDiagram);
        RefreshOrderingHelper.updateIfNeeded(semanticOrdering.getEventEnds(), this.computeEventEndsOrdering(semanticOrdering, allEnds));
    }

    private List<EventEnd> computeEventEndsOrdering(EventEndsOrdering semanticOrdering, Iterable<? extends EventEnd> allEnds) {
        HashMap index = Maps.newHashMap();
        for (EventEnd eventEnd : allEnds) {
            index.put(eventEnd.getSemanticEnd(), eventEnd);
        }
        Iterable iterable = Iterables.transform(allEnds, (Function)new Function<EventEnd, EObject>(){

            public EObject apply(EventEnd from) {
                return from.getSemanticEnd();
            }
        });
        List<EObject> orderedSemanticEnds = this.computeOrdering(iterable, DescriptionPackage.eINSTANCE.getSequenceDiagramDescription_EndsOrdering(), true);
        ArrayList<EventEnd> result = new ArrayList<EventEnd>();
        for (EObject semanticEnd : orderedSemanticEnds) {
            EventEnd ee = (EventEnd)index.get(semanticEnd);
            if (ee == null) continue;
            result.add(ee);
        }
        return result;
    }

    private void refreshGlobalOrdering(InstanceRolesOrdering semanticOrdering) {
        Iterable allInstanceRoles = Iterables.filter((Iterable)this.sequenceDDiagram.getNodes(), InstanceRole.viewpointElementPredicate());
        RefreshOrderingHelper.updateIfNeeded(semanticOrdering.getSemanticInstanceRoles(), this.computeInstanceRolesOrdering(semanticOrdering, allInstanceRoles));
    }

    private List<EObject> computeInstanceRolesOrdering(InstanceRolesOrdering semanticOrdering, Iterable<? extends DNode> allInstanceRoles) {
        ArrayList semanticInstanceRoles = Lists.newArrayList();
        for (DNode dNode : allInstanceRoles) {
            semanticInstanceRoles.add(dNode.getTarget());
        }
        List<EObject> list = this.computeOrdering(semanticInstanceRoles, DescriptionPackage.eINSTANCE.getSequenceDiagramDescription_InstanceRolesOrdering(), false);
        return list;
    }

    private List<EObject> computeOrdering(Iterable<EObject> semanticEnds, EAttribute expressionAttribute, boolean declareEventEndsVariable) {
        if (StringUtil.isEmpty((String)((String)this.getSequenceDescription().eGet((EStructuralFeature)expressionAttribute)))) {
            return Lists.newArrayList(semanticEnds);
        }
        IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)this.sequenceDDiagram);
        if (declareEventEndsVariable) {
            interpreter.setVariable(EVENT_ENDS_TO_SORT_VARIABLE, (Object)Lists.newArrayList(semanticEnds));
        }
        try {
            RuntimeLoggerInterpreter loggerInterpreter = RuntimeLoggerManager.INSTANCE.decorate(interpreter);
            Collection result = loggerInterpreter.evaluateCollection(this.sequenceDDiagram.getTarget(), (EObject)this.getSequenceDescription(), (EStructuralFeature)expressionAttribute);
            ArrayList arrayList = Lists.newArrayList((Iterable)result);
            return arrayList;
        }
        finally {
            if (declareEventEndsVariable) {
                interpreter.unSetVariable(EVENT_ENDS_TO_SORT_VARIABLE);
            }
        }
    }

    private SequenceDiagramDescription getSequenceDescription() {
        if (this.sequenceDDiagram != null) {
            DiagramDescription desc = this.sequenceDDiagram.getDescription();
            return (SequenceDiagramDescription)SequenceDiagramDescription.class.cast(desc);
        }
        return null;
    }
}

