/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.internal.part;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.DeleteFromDiagramEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.HideSiriusElementEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.LaunchBehaviorToolEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.LaunchToolEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.NodeCreationEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.NodeDeletionEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.RefreshSiriusElementEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusGraphicalNodeEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusPopupBarEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusPropertyHandlerEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNode2EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNode3EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNode4EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.BorderItemLocatorProvider;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IStyleConfigurationRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.StyleConfiguration;
import org.eclipse.sirius.diagram.ui.tools.api.part.NodePlateProvider;
import org.eclipse.sirius.diagram.ui.tools.api.policy.CompoundEditPolicy;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.sirius.viewpoint.Style;

public final class AbstractDiagramNodeEditPartOperation {
    private AbstractDiagramNodeEditPartOperation() {
    }

    public static void handleNotificationEvent(IAbstractDiagramNodeEditPart self, Notification notification) {
        EditPart parent;
        EAttribute feature;
        if (notification.getEventType() == 1 || notification.getEventType() == 2 || notification.getEventType() == 3) {
            AbstractDiagramNodeEditPartOperation.safeRefresh((EditPart)self);
        }
        if (notification.getEventType() == 4 && DiagramPackage.Literals.DDIAGRAM_ELEMENT__GRAPHICAL_FILTERS.equals(notification.getFeature())) {
            AbstractDiagramNodeEditPartOperation.safeRefresh((EditPart)self);
        }
        if (notification.getEventType() == 1 && notification.getFeature() instanceof EAttribute && "visible".equals((feature = (EAttribute)notification.getFeature()).getName()) && (parent = self.getParent()) != null) {
            AbstractDiagramNodeEditPartOperation.safeRefresh(parent);
        }
    }

    private static void safeRefresh(EditPart editPart) {
        if (editPart.getParent() != null) {
            editPart.refresh();
        }
    }

    public static void createDefaultEditPolicies(IAbstractDiagramNodeEditPart self) {
        self.removeEditPolicy("PopupBarEditPolicy");
        self.installEditPolicy("PopupBarEditPolicy", (EditPolicy)new SiriusPopupBarEditPolicy());
        self.removeEditPolicy("GraphicalNodeEditPolicy");
        self.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new SiriusGraphicalNodeEditPolicy());
        CompoundEditPolicy compoundEditPolicy = new CompoundEditPolicy();
        compoundEditPolicy.addEditPolicy((EditPolicy)new RefreshSiriusElementEditPolicy());
        compoundEditPolicy.addEditPolicy((EditPolicy)new HideSiriusElementEditPolicy());
        compoundEditPolicy.addEditPolicy((EditPolicy)new NodeDeletionEditPolicy(self.getEditingDomain()));
        compoundEditPolicy.addEditPolicy((EditPolicy)new LaunchBehaviorToolEditPolicy());
        compoundEditPolicy.addEditPolicy((EditPolicy)new DeleteFromDiagramEditPolicy());
        self.installEditPolicy("ComponentEditPolicy", compoundEditPolicy);
        CompoundEditPolicy compoundEditPolicy2 = new CompoundEditPolicy();
        compoundEditPolicy2.addEditPolicy((EditPolicy)new NodeCreationEditPolicy());
        if (self.getEditPolicy("ContainerEditPolicy") != null) {
            compoundEditPolicy2.addEditPolicy(self.getEditPolicy("ContainerEditPolicy"));
            self.removeEditPolicy("ContainerEditPolicy");
        }
        self.installEditPolicy("ContainerEditPolicy", compoundEditPolicy2);
        self.installEditPolicy("launchTool", (EditPolicy)new LaunchToolEditPolicy());
        self.removeEditPolicy("PropertyHandlerPolicy");
        self.installEditPolicy("PropertyHandlerPolicy", (EditPolicy)new SiriusPropertyHandlerEditPolicy());
    }

    public static IBorderItemLocator createBorderItemLocator(IAbstractDiagramNodeEditPart self, IFigure figure, DDiagramElement vpElementBorderItem) {
        EObject semantic = self.resolveSemanticElement();
        if (semantic != null && self.getMetamodelType().isInstance(semantic) && semantic instanceof DDiagramElement) {
            DDiagramElement element = (DDiagramElement)semantic;
            DiagramElementMapping mapping = element.getDiagramElementMapping();
            Style style = ((DStylizable)semantic).getStyle();
            StyleConfiguration styleConfiguration = IStyleConfigurationRegistry.INSTANCE.getStyleConfiguration(mapping, style);
            BorderItemLocatorProvider provider = styleConfiguration.getBorderItemLocatorProvider();
            return provider.getBorderItemLocator(figure, (DDiagramElement)semantic, vpElementBorderItem);
        }
        return null;
    }

    public static void setChildrenSize(IAbstractDiagramNodeEditPart self, Dimension d) {
        for (EditPart child : self.getChildren()) {
            if (child instanceof ShapeNodeEditPart && !AbstractDiagramNodeEditPartOperation.isBordered(child)) {
                ((ShapeNodeEditPart)child).getContentPane().setSize(d.width, d.height);
                ((ShapeNodeEditPart)child).getContentPane().setMinimumSize(d);
                ((ShapeNodeEditPart)child).getContentPane().setMaximumSize(d);
                ((ShapeNodeEditPart)child).getContentPane().setPreferredSize(d);
                ((ShapeNodeEditPart)child).getFigure().setSize(d.width, d.height);
                ((ShapeNodeEditPart)child).getFigure().setMinimumSize(d);
                ((ShapeNodeEditPart)child).getFigure().setMaximumSize(d);
                ((ShapeNodeEditPart)child).getFigure().setPreferredSize(d);
                ((ShapeNodeEditPart)child).getContentPane().setBounds(new Rectangle(((ShapeNodeEditPart)child).getContentPane().getBounds().getLocation(), d));
                self.setLayoutConstraint(child, ((ShapeNodeEditPart)child).getFigure(), new Rectangle(0, 0, d.width, d.height));
            }
            if (!(child instanceof NodePlateProvider) || ((NodePlateProvider)child).getNodePlate() == null) continue;
            ((NodePlateProvider)child).getNodePlate().setSize(d.width, d.height);
            ((NodePlateProvider)child).getNodePlate().setMaximumSize(d);
            ((NodePlateProvider)child).getNodePlate().setMinimumSize(d);
            ((NodePlateProvider)child).getNodePlate().setPreferredSize(d);
        }
    }

    public static boolean isBordered(EditPart editPart) {
        return editPart instanceof IDiagramBorderNodeEditPart;
    }

    public static DefaultSizeNodeFigure getNodePlate(IAbstractDiagramNodeEditPart viewNodeEditPart) {
        IFigure nodePlate = null;
        if (viewNodeEditPart instanceof DNode2EditPart) {
            nodePlate = ((DNode2EditPart)viewNodeEditPart).getNodePlate();
        } else if (viewNodeEditPart instanceof DNode3EditPart) {
            nodePlate = ((DNode3EditPart)viewNodeEditPart).getNodePlate();
        } else if (viewNodeEditPart instanceof DNodeEditPart) {
            nodePlate = ((DNodeEditPart)viewNodeEditPart).getNodePlate();
        } else if (viewNodeEditPart instanceof DNode4EditPart) {
            nodePlate = ((DNode4EditPart)viewNodeEditPart).getNodePlate();
        }
        return (DefaultSizeNodeFigure)nodePlate;
    }

    public static void setTooltipText(IAbstractDiagramNodeEditPart self, String text) {
        if (!StringUtil.isEmpty((String)text)) {
            IFigure tt = self.getFigure().getToolTip();
            if (tt instanceof Label) {
                ((Label)tt).setText(text);
            } else {
                self.getFigure().setToolTip((IFigure)new Label(text));
            }
        } else {
            self.getFigure().setToolTip(null);
        }
    }

    public static ZoomManager getZoomManager(IAbstractDiagramNodeEditPart self) {
        return (ZoomManager)self.getViewer().getProperty(ZoomManager.class.toString());
    }
}

