/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.properties;

import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractModelerPropertySection;
import org.eclipse.gmf.runtime.emf.ui.properties.sections.UndoableModelPropertySheetEntry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetSorter;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class AbstractPropertySection
extends AbstractModelerPropertySection {
    protected PropertySheetPage page;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormData data = null;
        String tableLabelStr = this.getTableLabel();
        CLabel tableLabel = null;
        if (tableLabelStr != null && tableLabelStr.length() > 0) {
            tableLabel = this.getWidgetFactory().createCLabel(composite, tableLabelStr);
            data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.top = new FormAttachment(0, 0);
            tableLabel.setLayoutData((Object)data);
        }
        this.page = new SortedPropertySheetPage();
        UndoableModelPropertySheetEntry root = new UndoableModelPropertySheetEntry(OperationHistoryFactory.getOperationHistory());
        root.setPropertySourceProvider(this.getPropertySourceProvider());
        this.page.setRootEntry((IPropertySheetEntry)root);
        this.page.createControl(composite);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = tableLabel == null ? new FormAttachment(0, 0) : new FormAttachment((Control)tableLabel, 0, 1024);
        data.bottom = new FormAttachment(100, 0);
        data.height = 100;
        data.width = 100;
        this.page.getControl().setLayoutData((Object)data);
        this.setActionBars(aTabbedPropertySheetPage.getSite().getActionBars());
        ((SortedPropertySheetPage)this.page).setSorter(new AirPropertySorter());
    }

    public void setActionBars(IActionBars actionBars) {
        actionBars.getMenuManager().removeAll();
        actionBars.getToolBarManager().removeAll();
        actionBars.getStatusLineManager().removeAll();
        this.page.makeContributions(actionBars.getMenuManager(), actionBars.getToolBarManager(), actionBars.getStatusLineManager());
        actionBars.getToolBarManager().update(true);
    }

    protected IPropertySourceProvider getPropertySourceProvider() {
        return propertiesProvider;
    }

    protected String getTableLabel() {
        return null;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject adapted;
        Object firstElement;
        EditingDomain theEditingDomain;
        IEditingDomainProvider provider = (IEditingDomainProvider)part.getAdapter(IEditingDomainProvider.class);
        if (provider != null && (theEditingDomain = provider.getEditingDomain()) instanceof TransactionalEditingDomain) {
            this.setEditingDomain((TransactionalEditingDomain)theEditingDomain);
        }
        if (!selection.isEmpty() && selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) != null && (adapted = this.unwrap(firstElement)) != null) {
            this.setEObject(adapted);
        }
        try {
            this.page.selectionChanged(part, selection);
        }
        catch (RuntimeException runtimeException) {}
    }

    public void dispose() {
        super.dispose();
        if (this.page != null) {
            this.page.dispose();
            this.page = null;
        }
    }

    public void refresh() {
        try {
            this.page.refresh();
        }
        catch (RuntimeException runtimeException) {}
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void update(final Notification notification, EObject element) {
        if (!this.isDisposed()) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!AbstractPropertySection.this.isDisposed() && !AbstractPropertySection.this.isNotifierDeleted(notification)) {
                        AbstractPropertySection.this.refresh();
                    }
                }
            });
        }
    }

    public NotificationFilter getFilter() {
        return NotificationFilter.createEventTypeFilter((int)1).or(NotificationFilter.createEventTypeFilter((int)2)).or(NotificationFilter.createEventTypeFilter((int)3)).or(NotificationFilter.createEventTypeFilter((int)5)).or(NotificationFilter.createEventTypeFilter((int)4)).or(NotificationFilter.createEventTypeFilter((int)6)).and(NotificationFilter.createNotifierTypeFilter(EObject.class));
    }

    protected boolean addToEObjectList(Object object) {
        return true;
    }

    public abstract Object getSelectedObject();

    private class AirPropertySorter
    extends PropertySheetSorter {
        private AirPropertySorter() {
        }

        public int compare(IPropertySheetEntry entryA, IPropertySheetEntry entryB) {
            return super.compare(entryA, entryB);
        }

        public int compareCategories(String categoryA, String categoryB) {
            int result = Integer.MIN_VALUE;
            IPropertySource propertySource = null;
            if (AbstractPropertySection.this.getPropertySourceProvider() != null && AbstractPropertySection.this.getSelectedObject() != null) {
                propertySource = AbstractPropertySection.this.getPropertySourceProvider().getPropertySource(AbstractPropertySection.this.getSelectedObject());
            }
            if (propertySource == null) {
                result = super.compareCategories(categoryA, categoryB);
            }
            if (categoryA == null) {
                int n = result = categoryB == null ? 0 : 1;
            }
            if (categoryB == null) {
                int n = result = categoryA == null ? 0 : -1;
            }
            if (categoryA != null && categoryA.equals(categoryB)) {
                result = 0;
            }
            if (propertySource != null) {
                IPropertyDescriptor[] descriptors = propertySource.getPropertyDescriptors();
                int i = 0;
                while (i < descriptors.length && result == Integer.MIN_VALUE) {
                    if (descriptors[i].getCategory() != null && descriptors[i].getCategory().equals(categoryA)) {
                        result = -1;
                    } else if (descriptors[i].getCategory() != null && descriptors[i].getCategory().equals(categoryB)) {
                        result = 1;
                    }
                    ++i;
                }
            }
            return result;
        }

        public void sort(IPropertySheetEntry[] entries) {
            super.sort(entries);
        }
    }

    private static class SortedPropertySheetPage
    extends PropertySheetPage {
        private SortedPropertySheetPage() {
        }

        public void setSorter(PropertySheetSorter sorter) {
            super.setSorter(sorter);
        }
    }
}

