/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.layout;

import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.layout.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.AbstractCopyPasteLayoutAction;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.data.extension.LayoutDataManagerRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class CopyLayoutAction
extends AbstractCopyPasteLayoutAction {
    public CopyLayoutAction(IWorkbenchPage workbenchPage, IWorkbenchPart actionWorkbenchPart) {
        super(workbenchPage, actionWorkbenchPart);
        this.setText("Copy layout");
        this.setAccelerator(458819);
        this.setId("copyLayoutAction");
        this.setToolTipText("Copy the layout of the selected diagram elements");
        this.setImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/copyLayout.gif"));
        this.setDisabledImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/copyLayoutDisabled.gif"));
        this.setHoverImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/copyLayout.gif"));
    }

    public CopyLayoutAction(IWorkbenchPage workbenchPage) {
        this(workbenchPage, null);
    }

    protected String getCommandLabel() {
        return "Copy Layout";
    }

    protected Command getCommand() {
        CompoundCommand doStoreLayoutsCmd = new CompoundCommand("Store layouts");
        doStoreLayoutsCmd.add(new Command("Clear previous layout data"){

            public boolean canUndo() {
                return false;
            }

            public boolean canExecute() {
                return super.canExecute();
            }

            public void execute() {
                for (SiriusLayoutDataManager layoutDataManager : LayoutDataManagerRegistry.getAllSiriusLayoutDataManagers()) {
                    layoutDataManager.clearLayoutData();
                }
            }
        });
        Iterator iter = this.getSelectedObjects().iterator();
        DiagramEditPart diagramEditPart = this.getDiagramEditPart();
        if (diagramEditPart instanceof IDDiagramEditPart) {
            final Option<DDiagram> diagram = ((IDDiagramEditPart)diagramEditPart).resolveDDiagram();
            while (iter.hasNext() && diagram.some()) {
                Object next = iter.next();
                if (!(next instanceof IGraphicalEditPart)) continue;
                final IGraphicalEditPart toStore = (IGraphicalEditPart)next;
                doStoreLayoutsCmd.add((Command)new ICommandProxy((ICommand)new AbstractTransactionalCommand(toStore.getEditingDomain(), "Copy layout data", null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        for (SiriusLayoutDataManager layoutDataManager : LayoutDataManagerRegistry.getSiriusLayoutDataManagers((DDiagram)diagram.get())) {
                            layoutDataManager.storeLayoutData(toStore);
                        }
                        return CommandResult.newOKCommandResult();
                    }

                    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        for (SiriusLayoutDataManager layoutDataManager : LayoutDataManagerRegistry.getSiriusLayoutDataManagers((DDiagram)diagram.get())) {
                            layoutDataManager.clearLayoutData();
                        }
                        return super.doUndo(monitor, info);
                    }
                }));
            }
        }
        return doStoreLayoutsCmd.unwrap();
    }
}

