/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AlignmentKind implements Enumerator
{
    VERTICAL_LITERAL(0, "VERTICAL", "VERTICAL"),
    HORIZONTAL_LITERAL(1, "HORIZONTAL", "HORIZONTAL"),
    SQUARE_LITERAL(2, "SQUARE", "SQUARE");

    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int SQUARE = 2;
    private static final AlignmentKind[] VALUES_ARRAY;
    public static final List<AlignmentKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AlignmentKind[]{VERTICAL_LITERAL, HORIZONTAL_LITERAL, SQUARE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AlignmentKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AlignmentKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AlignmentKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AlignmentKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AlignmentKind get(int value) {
        switch (value) {
            case 0: {
                return VERTICAL_LITERAL;
            }
            case 1: {
                return HORIZONTAL_LITERAL;
            }
            case 2: {
                return SQUARE_LITERAL;
            }
        }
        return null;
    }

    private AlignmentKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

