/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ContainerLayout implements Enumerator
{
    FREE_FORM(0, "FreeForm", "FreeForm"),
    LIST(1, "List", "List"),
    HORIZONTAL_STACK(2, "HorizontalStack", "HorizontalStack"),
    VERTICAL_STACK(3, "VerticalStack", "VerticalStack");

    public static final int FREE_FORM_VALUE = 0;
    public static final int LIST_VALUE = 1;
    public static final int HORIZONTAL_STACK_VALUE = 2;
    public static final int VERTICAL_STACK_VALUE = 3;
    private static final ContainerLayout[] VALUES_ARRAY;
    public static final List<ContainerLayout> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ContainerLayout[]{FREE_FORM, LIST, HORIZONTAL_STACK, VERTICAL_STACK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ContainerLayout get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContainerLayout result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContainerLayout getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ContainerLayout result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ContainerLayout get(int value) {
        switch (value) {
            case 0: {
                return FREE_FORM;
            }
            case 1: {
                return LIST;
            }
            case 2: {
                return HORIZONTAL_STACK;
            }
            case 3: {
                return VERTICAL_STACK;
            }
        }
        return null;
    }

    private ContainerLayout(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

