/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.experimental.sync;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DNodeListElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.helper.SiriusDiagramHelper;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayMode;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayService;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.business.api.query.ContainerMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.DiagramDescriptionMappingManagerQuery;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.business.internal.componentization.mappings.DiagramDescriptionMappingsManagerImpl;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.AbstractDNodeCandidate;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.AbstractSynchronizerHelper;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.DEdgeCandidate;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.DiagramElementMappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.StyleHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.MappingBasedDecoration;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.style.ContainerStyleDescription;
import org.eclipse.sirius.diagram.description.style.EdgeStyleDescription;
import org.eclipse.sirius.diagram.description.style.EllipseNodeDescription;
import org.eclipse.sirius.diagram.description.style.LozengeNodeDescription;
import org.eclipse.sirius.diagram.description.style.NodeStyleDescription;
import org.eclipse.sirius.diagram.description.style.SquareDescription;
import org.eclipse.sirius.diagram.description.style.WorkspaceImageDescription;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Decoration;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.ViewpointFactory;
import org.eclipse.sirius.viewpoint.description.DecorationDescription;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.SemanticBasedDecoration;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.description.style.BasicLabelStyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;
import org.eclipse.sirius.viewpoint.description.style.TooltipStyleDescription;

public class DDiagramElementSynchronizer {
    private final IInterpreter interpreter;
    private final DSemanticDiagram diagram;
    private final ModelAccessor accessor;
    private final StyleHelper styleHelper;
    private final MappingHelper mappingHelper;

    public DDiagramElementSynchronizer(DSemanticDiagram diagram, IInterpreter interpreter, ModelAccessor accessor) {
        this.diagram = diagram;
        this.interpreter = interpreter;
        this.accessor = accessor;
        this.styleHelper = new StyleHelper(interpreter);
        this.mappingHelper = new MappingHelper(interpreter);
    }

    public AbstractDNode createNewNode(DiagramMappingsManager mappingManager, AbstractDNodeCandidate candidate, boolean isBorder) {
        return this.createNewNode(mappingManager, candidate, isBorder, -1);
    }

    public AbstractDNode createNewNode(DiagramMappingsManager mappingManager, AbstractDNodeCandidate candidate, boolean isBorder, int insertionIndex) {
        DragAndDropTarget container = candidate.getViewContainer();
        AbstractDNode newNode = this.createAbstractNode(container, candidate, isBorder);
        if (insertionIndex > 0) {
            SiriusDiagramHelper.addNodeInContainer(container, isBorder, newNode, insertionIndex);
        } else {
            SiriusDiagramHelper.addNodeInContainer(container, isBorder, newNode);
        }
        this.refresh(newNode);
        this.refreshSemanticElements(newNode, candidate.getMapping());
        this.createStyle(newNode, candidate.getMapping());
        this.computeVisibilityOnCreation(mappingManager, newNode);
        return newNode;
    }

    private AbstractDNode createAbstractNode(DragAndDropTarget container, AbstractDNodeCandidate candidate, boolean border) {
        AbstractDNode result = null;
        if (candidate.getMapping() instanceof NodeMapping) {
            NodeMapping mapping = (NodeMapping)candidate.getMapping();
            if (container instanceof DNodeList) {
                if (!border) {
                    DNodeListElement newNode = DiagramFactory.eINSTANCE.createDNodeListElement();
                    newNode.setTarget(candidate.getSemantic());
                    newNode.setActualMapping(mapping);
                    result = newNode;
                } else {
                    DNode newNode = DiagramFactory.eINSTANCE.createDNode();
                    newNode.setTarget(candidate.getSemantic());
                    newNode.setActualMapping(mapping);
                    result = newNode;
                }
            } else {
                DNode newNode = DiagramFactory.eINSTANCE.createDNode();
                newNode.setTarget(candidate.getSemantic());
                newNode.setActualMapping(mapping);
                result = newNode;
            }
        } else if (candidate.getMapping() instanceof ContainerMapping) {
            ContainerMapping mapping = (ContainerMapping)candidate.getMapping();
            DDiagramElementContainer newContainer = null;
            if (new ContainerMappingQuery(mapping).isListContainer()) {
                newContainer = DiagramFactory.eINSTANCE.createDNodeList();
            } else {
                DNodeContainer nodeContainer = DiagramFactory.eINSTANCE.createDNodeContainer();
                nodeContainer.setChildrenPresentation(mapping.getChildrenPresentation());
                newContainer = nodeContainer;
            }
            newContainer.setTarget(candidate.getSemantic());
            newContainer.setActualMapping(mapping);
            result = newContainer;
        }
        return result;
    }

    public Map<DiagramElementMapping, Collection<EdgeTarget>> computeMappingsToEdgeTargets(Collection<Viewpoint> enabledVp) {
        HashMap<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets = new HashMap<DiagramElementMapping, Collection<EdgeTarget>>();
        DiagramDescription description = this.diagram.getDescription();
        DiagramDescriptionMappingsManagerImpl mappingsManager = new DiagramDescriptionMappingsManagerImpl(description);
        mappingsManager.computeMappings(enabledVp);
        Set<DiagramElementMapping> allMappings = new DiagramDescriptionMappingManagerQuery(mappingsManager).computeAllMappings();
        Iterable allNodeMappings = Iterables.filter(allMappings, NodeMapping.class);
        Iterable allContainerMappings = Iterables.filter(allMappings, ContainerMapping.class);
        Iterable allEdgeMappings = Iterables.filter(allMappings, EdgeMapping.class);
        for (NodeMapping nodeMapping : allNodeMappings) {
            EList<DNode> nodes = this.diagram.getNodesFromMapping(nodeMapping);
            if (nodes.isEmpty()) continue;
            mappingsToEdgeTargets.put(nodeMapping, DDiagramElementSynchronizer.convertNodesAndContainersToEdgeTarget(nodes));
        }
        for (ContainerMapping containerMapping : allContainerMappings) {
            EList<DDiagramElementContainer> containers = this.diagram.getContainersFromMapping(containerMapping);
            if (containers.isEmpty()) continue;
            mappingsToEdgeTargets.put(containerMapping, DDiagramElementSynchronizer.convertNodesAndContainersToEdgeTarget(containers));
        }
        for (EdgeMapping edgeMapping : allEdgeMappings) {
            EList<DEdge> edges = this.diagram.getEdgesFromMapping(edgeMapping);
            if (edges.isEmpty()) continue;
            mappingsToEdgeTargets.put(edgeMapping, DDiagramElementSynchronizer.convertNodesAndContainersToEdgeTarget(edges));
        }
        return mappingsToEdgeTargets;
    }

    private static Collection<EdgeTarget> convertNodesAndContainersToEdgeTarget(Collection<? extends DDiagramElement> diagramElements) {
        return ImmutableSet.copyOf((Iterable)Iterables.filter(diagramElements, EdgeTarget.class));
    }

    public DEdge createNewEdge(DiagramMappingsManager mappingManager, DEdgeCandidate candidate, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, Map<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration, Map<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration) {
        DslCommonPlugin.PROFILER.startWork("Create missing edges from viewpoint");
        DEdge newEdge = this.createEdge(candidate);
        this.diagram.getOwnedDiagramElements().add((Object)newEdge);
        Option<EdgeMapping> edgeMapping = new IEdgeMappingQuery(candidate.getMapping()).getEdgeMapping();
        if (edgeMapping.some()) {
            this.refreshSemanticElements(newEdge, (DiagramElementMapping)edgeMapping.get());
            this.createStyle(newEdge, (EdgeMapping)edgeMapping.get(), this.diagram);
            this.refresh(newEdge);
            this.updatePath(newEdge, (EdgeMapping)edgeMapping.get(), mappingsToEdgeTargets);
        }
        this.computeEdgeDecorations(newEdge, edgeToMappingBasedDecoration, edgeToSemanticBasedDecoration);
        this.computeVisibilityOnCreation(mappingManager, newEdge);
        DslCommonPlugin.PROFILER.stopWork("Create missing edges from viewpoint");
        return newEdge;
    }

    private DEdge createEdge(DEdgeCandidate candidate) {
        DEdge newEdge = DiagramFactory.eINSTANCE.createDEdge();
        newEdge.setTarget(candidate.getSemantic());
        newEdge.setActualMapping(candidate.getMapping());
        newEdge.setSourceNode(candidate.getSourceView());
        newEdge.setTargetNode(candidate.getTargetView());
        return newEdge;
    }

    private void computeVisibilityOnCreation(DiagramMappingsManager mappingManager, DDiagramElement element) {
        DisplayService service = DisplayServiceManager.INSTANCE.getDisplayService(DisplayMode.CREATION);
        if (service == null) {
            return;
        }
        DslCommonPlugin.PROFILER.startWork("Display Service : is the element displayed ?");
        element.setVisible(service.computeVisibility(mappingManager, this.diagram, element));
        if (!service.computeLabelVisibility(this.diagram, element)) {
            HideFilterHelper.INSTANCE.hideLabel(element);
        }
        DslCommonPlugin.PROFILER.stopWork("Display Service : is the element displayed ?");
    }

    public void computeEdgeDecorations(DEdge edge, Map<EdgeMapping, Collection<MappingBasedDecoration>> edgeToMappingBasedDecoration, Map<String, Collection<SemanticBasedDecoration>> edgeToSemanticBasedDecoration) {
        Option<EdgeMapping> actualMapping = new IEdgeMappingQuery(edge.getActualMapping()).getEdgeMapping();
        if (actualMapping.some() && ((EdgeMapping)actualMapping.get()).isUseDomainElement() && edgeToSemanticBasedDecoration.containsKey(((EdgeMapping)actualMapping.get()).getDomainClass())) {
            Collection<SemanticBasedDecoration> semanticBasedDecorations = edgeToSemanticBasedDecoration.get(((EdgeMapping)actualMapping.get()).getDomainClass());
            for (SemanticBasedDecoration semanticBasedDecoration : semanticBasedDecorations) {
                this.addDecoration(edge, (DecorationDescription)semanticBasedDecoration);
            }
        }
        if (edgeToMappingBasedDecoration.containsKey(edge.getActualMapping())) {
            Collection<MappingBasedDecoration> mappingBasedDecorations = edgeToMappingBasedDecoration.get(edge.getActualMapping());
            for (MappingBasedDecoration mappingBasedDecoration : mappingBasedDecorations) {
                this.addDecoration(edge, mappingBasedDecoration);
            }
        }
    }

    protected void refresh(DEdge edge) {
        Option<EdgeMapping> actualMapping;
        EObject containerVariable = null;
        if (edge.eContainer() instanceof DSemanticDecorator) {
            containerVariable = ((DSemanticDecorator)edge.eContainer()).getTarget();
        }
        this.interpreter.setVariable("diagram", (Object)this.diagram);
        this.interpreter.setVariable("view", (Object)edge);
        this.interpreter.setVariable("sourceView", (Object)edge.getSourceNode());
        this.interpreter.setVariable("targetView", (Object)edge.getTargetNode());
        this.mappingHelper.affectAndRefreshStyle(edge.getDiagramElementMapping(), edge, edge.getTarget(), containerVariable, (DDiagram)edge.eContainer());
        this.interpreter.unSetVariable("diagram");
        this.interpreter.unSetVariable("view");
        this.interpreter.unSetVariable("sourceView");
        this.interpreter.unSetVariable("targetView");
        EdgeStyle edgeStyle = edge.getOwnedStyle();
        if (edgeStyle != null) {
            EdgeStyleDescription edgeStyleDescription = (EdgeStyleDescription)edgeStyle.getDescription();
            this.refreshCenterLabel(edge, edgeStyleDescription);
            this.refreshBeginLabel(edge, edgeStyleDescription);
            this.refreshEndLabel(edge, edgeStyleDescription);
        }
        if ((actualMapping = new IEdgeMappingQuery(edge.getActualMapping()).getEdgeMapping()).some()) {
            this.refreshSemanticElements(edge, (DiagramElementMapping)actualMapping.get());
        }
        this.cleanDecoration(edge);
    }

    private void refreshEndLabel(DEdge edge, EdgeStyleDescription edgeStyleDescription) {
        if (edgeStyleDescription.getEndLabelStyleDescription() != null) {
            if (!StringUtil.isEmpty((String)edgeStyleDescription.getEndLabelStyleDescription().getLabelExpression())) {
                String label = this.computeLabel(edge, (EObject)edgeStyleDescription.getEndLabelStyleDescription());
                edge.setEndLabel(label);
                if (!"".equals(edge.getEndLabel()) || label != null) {
                    edge.setEndLabel(label);
                }
            } else if (!StringUtil.isEmpty((String)edge.getName())) {
                edge.setName("");
            }
        } else if (!StringUtil.isEmpty((String)edge.getEndLabel())) {
            edge.setEndLabel("");
        }
    }

    private void refreshBeginLabel(DEdge edge, EdgeStyleDescription edgeStyleDescription) {
        if (edgeStyleDescription.getBeginLabelStyleDescription() != null) {
            if (!StringUtil.isEmpty((String)edgeStyleDescription.getBeginLabelStyleDescription().getLabelExpression())) {
                String label = this.computeLabel(edge, (EObject)edgeStyleDescription.getBeginLabelStyleDescription());
                if (!"".equals(edge.getBeginLabel()) || label != null) {
                    edge.setBeginLabel(label);
                }
            } else if (!StringUtil.isEmpty((String)edge.getName())) {
                edge.setName("");
            }
        } else if (!StringUtil.isEmpty((String)edge.getBeginLabel())) {
            edge.setBeginLabel("");
        }
    }

    private void refreshCenterLabel(DEdge edge, EdgeStyleDescription edgeStyleDescription) {
        if (edgeStyleDescription.getCenterLabelStyleDescription() != null) {
            if (!StringUtil.isEmpty((String)edgeStyleDescription.getCenterLabelStyleDescription().getLabelExpression())) {
                String label = this.computeLabel(edge, (EObject)edgeStyleDescription.getCenterLabelStyleDescription());
                if (!"".equals(edge.getName()) || label != null) {
                    edge.setName(label);
                }
            } else if (!StringUtil.isEmpty((String)edge.getName())) {
                edge.setName("");
            }
        } else if (!StringUtil.isEmpty((String)edge.getName())) {
            edge.setName("");
        }
    }

    public void refresh(DDiagramElement dde) {
        if (this.accessor.getPermissionAuthority().canEditInstance((EObject)dde)) {
            if (dde instanceof DNode) {
                this.refresh((DNode)dde);
            } else if (dde instanceof DNodeListElement) {
                this.refresh((DNodeListElement)dde);
            } else if (dde instanceof DDiagramElementContainer) {
                this.refresh((DDiagramElementContainer)dde);
            } else if (dde instanceof DEdge) {
                this.refresh((DEdge)dde);
            }
        }
    }

    protected void refresh(DNodeListElement newNode) {
        NodeStyleDescription style;
        DSemanticDecorator container = (DSemanticDecorator)newNode.eContainer();
        if (container != null && (style = (NodeStyleDescription)this.mappingHelper.getBestStyleDescription(newNode.getActualMapping(), newNode.getTarget(), (EObject)newNode, container.getTarget(), this.diagram)) != null) {
            if (!(StringUtil.isEmpty((String)style.getLabelExpression()) || "".equals(newNode.getName()) && this.computeLabel(newNode, (EObject)style) == null)) {
                newNode.setName(this.computeLabel(newNode, (EObject)style));
            }
            this.refreshTooltip(newNode, style);
        }
        if (newNode.getOwnedStyle() != null) {
            Option noPreviousStyle = Options.newNone();
            this.styleHelper.refreshStyle(newNode.getOwnedStyle(), (Option<? extends Style>)noPreviousStyle);
        }
        this.refreshSemanticElements(newNode, newNode.getDiagramElementMapping());
    }

    protected void refresh(DDiagramElementContainer container) {
        DSemanticDecorator cContainer = (DSemanticDecorator)container.eContainer();
        if (cContainer != null) {
            ContainerStyleDescription containerStyleDescription = null;
            if (AbstractSynchronizerHelper.isTargetDying((DSemanticDecorator)container) && AbstractSynchronizerHelper.isTargetDying(cContainer)) {
                containerStyleDescription = (ContainerStyleDescription)this.mappingHelper.getBestStyleDescription(container.getActualMapping(), container.getTarget(), container, cContainer.getTarget(), this.diagram);
            }
            if (containerStyleDescription != null) {
                if (!StringUtil.isEmpty((String)containerStyleDescription.getLabelExpression())) {
                    String computeLabel = this.computeLabel(container, (EObject)containerStyleDescription);
                    if (!"".equals(container.getName()) || computeLabel != null) {
                        container.setName(computeLabel);
                    }
                }
                this.refreshTooltip(container, containerStyleDescription);
                this.refreshStyle(container, container.getActualMapping());
            }
        }
        this.cleanDecoration(container);
        this.refreshSemanticElements(container, container.getDiagramElementMapping());
    }

    private void cleanDecoration(DDiagramElement element) {
        Iterator it = element.getDecorations().iterator();
        while (it.hasNext()) {
            Decoration decoration = (Decoration)it.next();
            DecorationDescription description = decoration.getDescription();
            if (this.diagram.getActivatedLayers().contains((Object)LayerHelper.getParentLayer(description)) && this.checkDecoratorPrecondition(element.getTarget(), (DSemanticDecorator)element.eContainer(), description)) continue;
            it.remove();
        }
    }

    protected void refresh(DNode newNode) {
        DSemanticDecorator container = (DSemanticDecorator)newNode.eContainer();
        if (container != null) {
            NodeStyleDescription nodeStyleDescription = null;
            if (AbstractSynchronizerHelper.isTargetDying((DSemanticDecorator)newNode)) {
                nodeStyleDescription = (NodeStyleDescription)this.mappingHelper.getBestStyleDescription(newNode.getActualMapping(), newNode.getTarget(), newNode, container.getTarget(), this.diagram);
            }
            if (nodeStyleDescription != null) {
                boolean customSizeRefresh;
                if (!StringUtil.isEmpty((String)nodeStyleDescription.getLabelExpression())) {
                    String computeLabel = this.computeLabel(newNode, (EObject)nodeStyleDescription);
                    if (!"".equals(newNode.getName()) || computeLabel != null) {
                        newNode.setName(computeLabel);
                    }
                }
                newNode.setResizeKind(nodeStyleDescription.getResizeKind());
                boolean bl = customSizeRefresh = nodeStyleDescription instanceof EllipseNodeDescription || nodeStyleDescription instanceof LozengeNodeDescription || nodeStyleDescription instanceof SquareDescription || nodeStyleDescription instanceof WorkspaceImageDescription;
                if (!StringUtil.isEmpty((String)nodeStyleDescription.getSizeComputationExpression()) && !customSizeRefresh) {
                    this.styleHelper.setComputedSize(newNode, nodeStyleDescription);
                }
                this.refreshTooltip(newNode, nodeStyleDescription);
                this.refreshStyle(newNode, newNode.getActualMapping());
            }
        }
        this.cleanDecoration(newNode);
        this.refreshSemanticElements(newNode, newNode.getDiagramElementMapping());
    }

    private void refreshTooltip(DDiagramElement elt, TooltipStyleDescription style) {
        if (!StringUtil.isEmpty((String)style.getTooltipExpression())) {
            String oldValue = elt.getTooltipText();
            String newValue = this.computeTooltip((DSemanticDecorator)elt, (EObject)style);
            if (!Objects.equal((Object)newValue, (Object)oldValue)) {
                elt.setTooltipText(newValue);
            }
        }
    }

    public void refreshStyle(AbstractDNode node, AbstractNodeMapping mapping) {
        Style style;
        EObject containerVariable = null;
        if (node.eContainer() != null) {
            this.interpreter.setVariable("containerView", (Object)node.eContainer());
            if (node.eContainer() instanceof DSemanticDecorator) {
                containerVariable = ((DSemanticDecorator)node.eContainer()).getTarget();
                this.interpreter.setVariable("container", (Object)containerVariable);
            }
        }
        this.interpreter.setVariable("viewpoint", (Object)this.diagram);
        this.interpreter.setVariable("diagram", (Object)this.diagram);
        this.interpreter.setVariable("view", (Object)node);
        StyleDescription bestStyleDescription = null;
        if (AbstractSynchronizerHelper.isTargetDying((DSemanticDecorator)node)) {
            bestStyleDescription = this.mappingHelper.getBestStyleDescription(mapping, node.getTarget(), (EObject)node, containerVariable, this.diagram);
        }
        if ((style = node.getStyle()) != null) {
            Style bestStyle = this.mappingHelper.getBestStyle(mapping, node.getTarget(), (EObject)node, containerVariable, this.diagram);
            if (bestStyleDescription != null && !this.isSameDescription(bestStyleDescription, style, bestStyle)) {
                Style currentStyle = style;
                if (this.isCustomizedWorkspaceImageWorkspacePath(currentStyle)) {
                    this.styleHelper.refreshStyle(style);
                } else {
                    this.styleHelper.setAndRefreshStyle(node, currentStyle, this.styleHelper.createStyle(bestStyleDescription));
                }
            } else {
                this.styleHelper.refreshStyle(style);
            }
        } else {
            this.styleHelper.setAndRefreshStyle(node, null, this.styleHelper.createStyle(bestStyleDescription));
        }
        this.interpreter.unSetVariable("view");
        this.interpreter.unSetVariable("diagram");
        this.interpreter.unSetVariable("viewpoint");
        if (node.eContainer() != null) {
            this.interpreter.unSetVariable("containerView");
            if (node.eContainer() instanceof DSemanticDecorator) {
                this.interpreter.unSetVariable("container");
            }
        }
    }

    private boolean isCustomizedWorkspaceImageWorkspacePath(Style style) {
        boolean isCustomizedWorkspaceImageWorkspacePath = false;
        if (style instanceof WorkspaceImage) {
            WorkspaceImage workspaceImage = (WorkspaceImage)style;
            isCustomizedWorkspaceImageWorkspacePath = workspaceImage.getCustomFeatures().contains((Object)DiagramPackage.Literals.WORKSPACE_IMAGE__WORKSPACE_PATH.getName());
        }
        return isCustomizedWorkspaceImageWorkspacePath;
    }

    private boolean isSameDescription(StyleDescription bestStyleDescription, Style style, Style bestStyle) {
        return bestStyleDescription == style.getDescription() && bestStyle.eClass().equals(style.eClass());
    }

    public void refreshStyle(DEdge edge, EdgeMapping mapping, DDiagram parentDiagram) {
        this.interpreter.setVariable("diagram", (Object)this.diagram);
        this.interpreter.setVariable("view", (Object)edge);
        this.interpreter.setVariable("sourceView", (Object)edge.getSourceNode());
        this.interpreter.setVariable("targetView", (Object)edge.getTargetNode());
        EObject containerVariable = null;
        if (edge.eContainer() instanceof DSemanticDecorator) {
            containerVariable = ((DSemanticDecorator)edge.eContainer()).getTarget();
        }
        StyleDescription bestStyleDescription = null;
        if (edge.getTarget() != null) {
            bestStyleDescription = this.mappingHelper.getBestStyleDescription(mapping, edge.getTarget(), edge, containerVariable, parentDiagram);
        }
        if (bestStyleDescription != null && bestStyleDescription != edge.getStyle().getDescription()) {
            Style currentStyle = edge.getStyle();
            this.styleHelper.setAndRefreshStyle(edge, currentStyle, this.styleHelper.createStyle(bestStyleDescription));
        } else if (edge.getStyle() != null) {
            this.styleHelper.refreshStyle(edge.getStyle());
        }
        this.interpreter.unSetVariable("diagram");
        this.interpreter.unSetVariable("view");
        this.interpreter.unSetVariable("sourceView");
        this.interpreter.unSetVariable("targetView");
    }

    public void createStyle(AbstractDNode node, AbstractNodeMapping mapping) {
        EObject containerVariable = null;
        if (node.eContainer() != null) {
            this.interpreter.setVariable("containerView", (Object)node.eContainer());
            if (node.eContainer() instanceof DSemanticDecorator) {
                containerVariable = ((DSemanticDecorator)node.eContainer()).getTarget();
                this.interpreter.setVariable("container", (Object)containerVariable);
            }
        }
        this.interpreter.setVariable("viewpoint", (Object)this.diagram);
        this.interpreter.setVariable("diagram", (Object)this.diagram);
        this.interpreter.setVariable("view", (Object)node);
        this.mappingHelper.affectAndRefreshStyle(mapping, node, node.getTarget(), containerVariable, this.diagram);
        if (node.eContainer() != null) {
            this.interpreter.unSetVariable("containerView");
            if (node.eContainer() instanceof DSemanticDecorator) {
                this.interpreter.unSetVariable("container");
            }
        }
        this.interpreter.unSetVariable("view");
        this.interpreter.unSetVariable("diagram");
        this.interpreter.unSetVariable("viewpoint");
    }

    public void createStyle(DEdge edge, EdgeMapping mapping, DDiagram parentDiagram) {
        this.interpreter.setVariable("diagram", (Object)this.diagram);
        this.interpreter.setVariable("view", (Object)edge);
        this.interpreter.setVariable("sourceView", (Object)edge.getSourceNode());
        this.interpreter.setVariable("targetView", (Object)edge.getTargetNode());
        if (edge.getStyle() == null || edge.getStyle().getCustomFeatures().isEmpty()) {
            EObject containerVariable = null;
            if (edge.eContainer() instanceof DSemanticDecorator) {
                containerVariable = ((DSemanticDecorator)edge.eContainer()).getTarget();
            }
            this.mappingHelper.affectAndRefreshStyle(mapping, edge, edge.getTarget(), containerVariable, parentDiagram);
        } else if (edge.getStyle().getCustomFeatures().isEmpty()) {
            Option noPreviousStyle = Options.newNone();
            this.styleHelper.refreshStyle(edge.getOwnedStyle(), (Option<? extends Style>)noPreviousStyle);
        } else {
            this.styleHelper.refreshStyle(edge.getOwnedStyle(), (Option<? extends Style>)Options.newSome((Object)edge.getOwnedStyle()));
        }
        this.interpreter.unSetVariable("diagram");
        this.interpreter.unSetVariable("view");
        this.interpreter.unSetVariable("sourceView");
        this.interpreter.unSetVariable("targetView");
    }

    private String computeLabel(DDiagramElement view, EObject descriptionObject) {
        String result = "Invalid feature as name";
        if (descriptionObject instanceof BasicLabelStyleDescription) {
            result = DiagramElementMappingHelper.computeLabel(view, (BasicLabelStyleDescription)descriptionObject, this.diagram, this.interpreter);
        }
        return result;
    }

    private String computeTooltip(DSemanticDecorator view, EObject descriptionObject) {
        String result = StylePackage.eINSTANCE.getTooltipStyleDescription_TooltipExpression().getDefaultValueLiteral();
        if (descriptionObject instanceof TooltipStyleDescription) {
            String tooltipExpression = ((TooltipStyleDescription)descriptionObject).getTooltipExpression();
            try {
                try {
                    this.interpreter.setVariable("view", (Object)view);
                    result = this.interpreter.evaluateString(view.getTarget(), tooltipExpression);
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error(descriptionObject, (EStructuralFeature)StylePackage.eINSTANCE.getTooltipStyleDescription_TooltipExpression(), (Throwable)e);
                    this.interpreter.unSetVariable("view");
                }
            }
            finally {
                this.interpreter.unSetVariable("view");
            }
        }
        return result;
    }

    public void updatePath(DEdge edge, EdgeMapping mapping, Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets) {
        if (mapping.getPathExpression() != null && !StringUtil.isEmpty((String)mapping.getPathExpression()) && mapping.getPathNodeMapping() != null) {
            List<EObject> pathSemanticCandidates;
            block10: {
                pathSemanticCandidates = Collections.emptyList();
                this.interpreter.setVariable("viewpoint", (Object)this.diagram);
                this.interpreter.setVariable("diagram", (Object)this.diagram);
                this.interpreter.setVariable("element", (Object)edge.getTarget());
                if (edge.getSourceNode() instanceof DSemanticDecorator) {
                    this.interpreter.setVariable("source", (Object)((DSemanticDecorator)edge.getSourceNode()).getTarget());
                }
                if (edge.getTargetNode() instanceof DSemanticDecorator) {
                    this.interpreter.setVariable("target", (Object)((DSemanticDecorator)edge.getTargetNode()).getTarget());
                }
                try {
                    try {
                        pathSemanticCandidates = new ArrayList<EObject>(this.interpreter.evaluateCollection(edge.getTarget(), mapping.getPathExpression()));
                    }
                    catch (EvaluationException e) {
                        RuntimeLoggerManager.INSTANCE.error((EObject)mapping, (EStructuralFeature)org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getEdgeMapping_PathExpression(), (Throwable)e);
                        this.interpreter.unSetVariable("viewpoint");
                        this.interpreter.unSetVariable("diagram");
                        this.interpreter.unSetVariable("element");
                        this.interpreter.unSetVariable("source");
                        this.interpreter.unSetVariable("target");
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    this.interpreter.unSetVariable("viewpoint");
                    this.interpreter.unSetVariable("diagram");
                    this.interpreter.unSetVariable("element");
                    this.interpreter.unSetVariable("source");
                    this.interpreter.unSetVariable("target");
                    throw throwable;
                }
                this.interpreter.unSetVariable("viewpoint");
                this.interpreter.unSetVariable("diagram");
                this.interpreter.unSetVariable("element");
                this.interpreter.unSetVariable("source");
                this.interpreter.unSetVariable("target");
            }
            Map<EObject, EdgeTarget> availableElements = this.getAvailableElements(mappingsToEdgeTargets, (Collection<AbstractNodeMapping>)mapping.getPathNodeMapping());
            Set<EObject> semanticAvailableElements = availableElements.keySet();
            BasicEList newPath = new BasicEList();
            for (EObject pathSemanticCandidate : pathSemanticCandidates) {
                if (!semanticAvailableElements.contains(pathSemanticCandidate)) continue;
                newPath.add((Object)availableElements.get(pathSemanticCandidate));
            }
            if (!newPath.isEmpty() && !edge.getPath().equals((Object)newPath)) {
                edge.getPath().clear();
                edge.getPath().addAll((Collection)newPath);
            }
        }
    }

    private Map<EObject, EdgeTarget> getAvailableElements(Map<DiagramElementMapping, Collection<EdgeTarget>> mappingsToEdgeTargets, Collection<AbstractNodeMapping> mappings) {
        HashMap<EObject, EdgeTarget> semanticToEdgeTargets = new HashMap<EObject, EdgeTarget>();
        for (DiagramElementMapping diagramElementMapping : mappings) {
            Collection<EdgeTarget> edgeTargets = mappingsToEdgeTargets.get(diagramElementMapping);
            if (edgeTargets == null) continue;
            for (EdgeTarget edgeTarget : edgeTargets) {
                if (!(edgeTarget instanceof DSemanticDecorator)) continue;
                semanticToEdgeTargets.put(((DSemanticDecorator)edgeTarget).getTarget(), edgeTarget);
            }
        }
        return semanticToEdgeTargets;
    }

    public void addDecoration(DDiagramElement element, DecorationDescription decorationDescription) {
        for (Decoration decoration : new ArrayList<Decoration>((Collection<Decoration>)element.getDecorations())) {
            if (!EcoreUtil.equals((EObject)decorationDescription, (EObject)decoration.getDescription())) continue;
            return;
        }
        if (this.checkDecoratorPrecondition(element.getTarget(), (DSemanticDecorator)element.eContainer(), decorationDescription)) {
            Decoration decoration;
            decoration = ViewpointFactory.eINSTANCE.createDecoration();
            decoration.setDescription(decorationDescription);
            element.getDecorations().add((Object)decoration);
        }
    }

    private boolean checkDecoratorPrecondition(EObject semantic, DSemanticDecorator container, DecorationDescription decorationDescription) {
        DslCommonPlugin.PROFILER.startWork("Check precondition expressions");
        boolean result = false;
        if (decorationDescription != null && !decorationDescription.eIsProxy()) {
            result = true;
            String preconditionExpression = decorationDescription.getPreconditionExpression();
            if (!StringUtil.isEmpty((String)preconditionExpression)) {
                this.interpreter.setVariable("containerView", (Object)container);
                this.interpreter.setVariable("container", (Object)(container != null ? container.getTarget() : null));
                this.interpreter.setVariable("viewpoint", (Object)this.diagram);
                this.interpreter.setVariable("diagram", (Object)this.diagram);
                try {
                    result = this.interpreter.evaluateBoolean(semantic, preconditionExpression);
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)decorationDescription, (EStructuralFeature)DescriptionPackage.eINSTANCE.getDecorationDescription_PreconditionExpression(), (Throwable)e);
                }
                this.interpreter.unSetVariable("containerView");
                this.interpreter.unSetVariable("container");
                this.interpreter.unSetVariable("viewpoint");
                this.interpreter.unSetVariable("diagram");
            }
        }
        DslCommonPlugin.PROFILER.stopWork("Check precondition expressions");
        return result;
    }

    private void refreshSemanticElements(DDiagramElement element, DiagramElementMapping mapping) {
        DiagramElementMappingHelper.refreshSemanticElements(mapping, element, this.interpreter);
    }
}

