/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.description.estructuralfeaturecustomization;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditor;
import org.eclipse.sirius.editor.properties.sections.common.AbstractEditorDialogPropertySection;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.EAttributeCustomization;
import org.eclipse.sirius.viewpoint.description.EReferenceCustomization;
import org.eclipse.sirius.viewpoint.description.EStructuralFeatureCustomization;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class EStructuralFeatureCustomizationAppliedOnPropertySection
extends AbstractEditorDialogPropertySection {
    @Override
    protected String getDefaultLabelText() {
        return "AppliedOn";
    }

    @Override
    protected String getLabelText() {
        String labelText = String.valueOf(super.getLabelText()) + ":";
        labelText = String.valueOf(super.getLabelText()) + "*:";
        return labelText;
    }

    protected EReference getFeature() {
        return DescriptionPackage.eINSTANCE.getEStructuralFeatureCustomization_AppliedOn();
    }

    @Override
    protected String getFeatureAsText() {
        String string = new String();
        if (this.eObject.eGet((EStructuralFeature)this.getFeature()) != null) {
            List values = (List)this.eObject.eGet((EStructuralFeature)this.getFeature());
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                EObject eObj = (EObject)iterator.next();
                string = String.valueOf(string) + this.getAdapterFactoryLabelProvider(eObj).getText((Object)eObj);
                if (!iterator.hasNext()) continue;
                string = String.valueOf(string) + ", ";
            }
        }
        return string;
    }

    @Override
    protected boolean isEqual(List<?> newList) {
        return newList.equals(this.eObject.eGet((EStructuralFeature)this.getFeature()));
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.text.setToolTipText("The style to customize.");
        CLabel help = this.getWidgetFactory().createCLabel(this.composite, "");
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.text, 0, 128);
        data.left = new FormAttachment((Control)this.nameLabel);
        help.setLayoutData((Object)data);
        help.setFont(SiriusEditor.getFontRegistry().get("description"));
        help.setImage(this.getHelpIcon());
        help.setToolTipText("The style to customize.");
        this.nameLabel.setFont(SiriusEditor.getFontRegistry().get("required"));
    }

    @Override
    protected List<?> getChoiceOfValues(List<?> currentValues) {
        ArrayList<EObject> customizableElements = new ArrayList<EObject>();
        for (Object choiceOfValue : super.getChoiceOfValues(currentValues)) {
            EObject choice;
            if (!(choiceOfValue instanceof EObject) || !DialectManager.INSTANCE.allowsEStructuralFeatureCustomization(choice = (EObject)choiceOfValue) || !this.isConformToCustomization(choice)) continue;
            customizableElements.add(choice);
        }
        return customizableElements;
    }

    private boolean isConformToCustomization(EObject choice) {
        boolean isConform = false;
        if (this.eObject instanceof EAttributeCustomization) {
            EAttributeCustomization eAttributeCustomization = (EAttributeCustomization)this.eObject;
            if (StringUtil.isEmpty((String)eAttributeCustomization.getAttributeName())) {
                isConform = true;
            } else {
                EStructuralFeature feature = this.getEStructuralFeature(choice.eClass(), eAttributeCustomization.getAttributeName());
                isConform = feature instanceof EAttribute;
            }
        } else if (this.eObject instanceof EReferenceCustomization) {
            EStructuralFeature feature;
            EReferenceCustomization eReferenceCustomization = (EReferenceCustomization)this.eObject;
            isConform = StringUtil.isEmpty((String)eReferenceCustomization.getReferenceName()) ? true : (feature = this.getEStructuralFeature(choice.eClass(), eReferenceCustomization.getReferenceName())) instanceof EReference && this.checkValue((EReference)feature, eReferenceCustomization.getValue());
        }
        return isConform;
    }

    private boolean checkValue(EReference ref, EObject value) {
        EClass eType = ref.getEReferenceType();
        return value != null && eType != null && eType.isSuperTypeOf(value.eClass());
    }

    private EStructuralFeature getEStructuralFeature(EClass eClass, String featureName) {
        if (!StringUtil.isEmpty((String)featureName) && eClass != null) {
            return eClass.getEStructuralFeature(featureName);
        }
        return null;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.updateReadOnlyStatus();
    }

    @Override
    protected boolean shouldBeReadOnly() {
        boolean shouldBeReadOnly = super.shouldBeReadOnly();
        if (!shouldBeReadOnly) {
            return ((EStructuralFeatureCustomization)this.eObject).isApplyOnAll();
        }
        return shouldBeReadOnly;
    }
}

