/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.style.basiclabelstyledescription;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditor;
import org.eclipse.sirius.editor.properties.sections.common.AbstractTextPropertySection;
import org.eclipse.sirius.viewpoint.description.style.StylePackage;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class BasicLabelStyleDescriptionIconPathPropertySection
extends AbstractTextPropertySection {
    protected CLabel help;

    @Override
    public void refresh() {
        super.refresh();
        String tooltip = this.getToolTipText();
        if (tooltip != null && this.help != null) {
            this.help.setToolTipText(this.getToolTipText());
        }
    }

    @Override
    protected String getDefaultLabelText() {
        return "IconPath";
    }

    @Override
    protected String getLabelText() {
        String labelText = String.valueOf(super.getLabelText()) + ":";
        return labelText;
    }

    @Override
    public EAttribute getFeature() {
        return StylePackage.eINSTANCE.getBasicLabelStyleDescription_IconPath();
    }

    @Override
    protected Object getFeatureValue(String newText) {
        return newText;
    }

    @Override
    protected boolean isEqual(String newText) {
        return this.getFeatureAsText().equals(newText);
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.text.setToolTipText(this.getToolTipText());
        this.help = this.getWidgetFactory().createCLabel(this.composite, "");
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.text, 0, 128);
        data.left = new FormAttachment((Control)this.nameLabel);
        this.help.setLayoutData((Object)data);
        this.help.setFont(SiriusEditor.getFontRegistry().get("description"));
        this.help.setImage(this.getHelpIcon());
        this.help.setToolTipText(this.getToolTipText());
    }

    @Override
    protected String getPropertyDescription() {
        return "Path to a specific icon, if unset the icon associated to the semantic element will be used. Otherwise use path\nlike /myProject/myDirectory/myImage.gif, the style will look for it first in the workspace, then in the plugins.";
    }
}

