/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.helper.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.TaskExecutor;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.table.business.internal.helper.task.DeleteTableElementTask;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.tools.internal.command.TableCommandFactory;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class DeleteTableElementsTask
extends AbstractCommandTask {
    private SiriusCommand cmd;
    private TableCommandFactory tableCommandFactory;
    private DTableElement tableElement;
    private TransactionalEditingDomain domain;
    private ModelAccessor modelAccessor;
    private List<ICommandTask> executedTask;

    public DeleteTableElementsTask(TransactionalEditingDomain domain, ModelAccessor modelAcessor, SiriusCommand cmd, TableCommandFactory tableCommandFactory, DTableElement tableElement) {
        this.cmd = cmd;
        this.tableCommandFactory = tableCommandFactory;
        this.tableElement = tableElement;
        this.domain = domain;
        this.modelAccessor = modelAcessor;
    }

    public void execute() {
        ArrayList<ICommandTask> tasks = new ArrayList<ICommandTask>();
        Set<DTableElement> vpElements = null;
        boolean automaticRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.sirius", SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), false, null);
        if (automaticRefresh) {
            vpElements = this.tableCommandFactory.getCommandTaskHelper().getDElementToClearFromSemanticElements(EcoreUtil.getRootContainer((EObject)this.tableElement), this.completeCollection(this.cmd.getDeletedObjects()));
        } else {
            vpElements = new HashSet<DTableElement>();
            vpElements.add(this.tableElement);
        }
        for (DSemanticDecorator dSemanticDecorator : vpElements) {
            tasks.add((ICommandTask)new DeleteTableElementTask((EObject)dSemanticDecorator, this.modelAccessor));
            if (!(dSemanticDecorator instanceof DTable)) continue;
            SiriusCommand temp = new SiriusCommand(this.domain);
            this.tableCommandFactory.addDeleteTableTasks(temp, (DTable)dSemanticDecorator);
            List tempTasks = temp.getTasks();
            if (!TaskExecutor.canExecute((List)tempTasks)) continue;
            TaskExecutor.execute((List)tempTasks);
            if (this.executedTask == null) {
                this.executedTask = new LinkedList<ICommandTask>();
            }
            this.executedTask.addAll(tempTasks);
        }
        if (TaskExecutor.canExecute(tasks)) {
            TaskExecutor.execute(tasks);
            if (this.executedTask != null) {
                this.executedTask.addAll(tasks);
            } else {
                this.executedTask = tasks;
            }
        }
    }

    public void undo() {
        if (this.executedTask != null) {
            TaskExecutor.undo(this.executedTask);
        }
    }

    public void redo() {
        if (this.executedTask != null) {
            TaskExecutor.redo(this.executedTask);
        }
    }

    public String getLabel() {
        return "delete viewpint elements task";
    }

    private Set<EObject> completeCollection(Collection<EObject> semantics) {
        HashSet<EObject> result = new HashSet<EObject>(semantics);
        for (EObject sem : semantics) {
            TreeIterator iterContent = sem.eAllContents();
            while (iterContent.hasNext()) {
                result.add((EObject)iterContent.next());
            }
        }
        return result;
    }
}

