/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.internal.refresh;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.table.business.internal.refresh.KeyCache;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.LineContainer;
import org.eclipse.sirius.table.metamodel.table.description.LineMapping;

public class DLineCandidate {
    private final LineContainer viewContainer;
    private final EObject semantic;
    private final LineMapping mapping;
    private DLine element;
    private final URI semanticURI;
    private final URI viewContainerURI;
    private int hashCode;

    public DLineCandidate(LineMapping mapping, EObject semanticElement, LineContainer viewContainer) {
        this.mapping = mapping;
        this.semantic = semanticElement;
        this.viewContainer = viewContainer;
        this.semanticURI = this.semantic != null ? EcoreUtil.getURI((EObject)this.semantic) : null;
        this.viewContainerURI = viewContainer != null ? EcoreUtil.getURI((EObject)viewContainer) : null;
        this.hashCode = this.computeHashCode();
    }

    public DLineCandidate(DLine tableElement) {
        this(tableElement.getOriginMapping(), tableElement.getTarget(), (LineContainer)tableElement.eContainer());
        this.element = tableElement;
    }

    public boolean comesFromTableElement() {
        return this.getOriginalElement() != null;
    }

    public DLine getOriginalElement() {
        return this.element;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return KeyCache.DEFAULT.getKey(String.valueOf(this.mapping != null ? this.mapping.getName() : "") + this.semanticURI + this.viewContainerURI);
    }

    public boolean equals(Object obj) {
        Boolean result = null;
        if (this == obj) {
            result = true;
        }
        if (result == null && obj == null) {
            result = false;
        }
        if (result == null && !(obj instanceof DLineCandidate)) {
            result = false;
        }
        DLineCandidate other = (DLineCandidate)obj;
        if (result == null && this.mapping == null) {
            if (other.mapping != null) {
                result = false;
            }
        } else if (result == null && !this.mapping.getName().equals(other.mapping.getName())) {
            result = false;
        }
        if (result == null && this.semantic == null) {
            if (other.semantic != null) {
                result = false;
            }
        } else if (result == null && !this.semanticURI.equals(other.semanticURI)) {
            result = false;
        }
        if (result == null && this.viewContainer == null) {
            if (other.viewContainer != null) {
                result = false;
            }
        } else if (result == null && !this.viewContainerURI.equals(other.viewContainerURI)) {
            result = false;
        }
        if (result == null) {
            result = true;
        }
        return result;
    }

    public LineMapping getMapping() {
        return this.mapping;
    }

    public EObject getSemantic() {
        return this.semantic;
    }

    public LineContainer getViewContainer() {
        return this.viewContainer;
    }
}

