/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.listeners;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.interaction.DTreeItemUserInteraction;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.business.internal.helper.RefreshTreeElementTask;

public class DTreeViewerListener
implements ITreeViewerListener {
    private Session session;
    private TransactionalEditingDomain domain;

    public DTreeViewerListener(Session session) {
        this.session = session;
        this.domain = session.getTransactionalEditingDomain();
    }

    public void treeExpanded(TreeExpansionEvent event) {
        DTreeItem dTreeItem;
        if (event.getElement() instanceof DTreeItem && !(dTreeItem = (DTreeItem)event.getElement()).isExpanded()) {
            CommandStack commandStack = this.domain.getCommandStack();
            CompoundCommand expandDTreeItemCmd = new CompoundCommand("Expand " + dTreeItem.getName() + " tree item");
            expandDTreeItemCmd.append((Command)new TreeFoldingRecordingCommand(this.session, event, true));
            SiriusCommand result = new SiriusCommand(this.domain);
            result.getTasks().add(new RefreshTreeElementTask((EObject)((DTreeItem)event.getElement()), this.domain));
            expandDTreeItemCmd.append((Command)result);
            commandStack.execute((Command)expandDTreeItemCmd);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        DTreeItem dTreeItem;
        if (event.getElement() instanceof DTreeItem && (dTreeItem = (DTreeItem)event.getElement()).isExpanded()) {
            CommandStack commandStack = this.domain.getCommandStack();
            CompoundCommand expandDTreeItemCmd = new CompoundCommand("Collapse " + dTreeItem.getName() + " tree item");
            expandDTreeItemCmd.append((Command)new TreeFoldingRecordingCommand(this.session, event, false));
            commandStack.execute((Command)expandDTreeItemCmd);
        }
    }

    class TreeFoldingRecordingCommand
    extends RecordingCommand {
        private Session session;
        private TreeExpansionEvent event;
        private boolean expand;

        public TreeFoldingRecordingCommand(Session session, TreeExpansionEvent event, boolean expand) {
            super(session.getTransactionalEditingDomain());
            this.session = session;
            this.event = event;
            this.expand = expand;
        }

        protected void doExecute() {
            GlobalContext ctx = new GlobalContext(this.session.getModelAccessor(), this.session);
            if (this.expand) {
                new DTreeItemUserInteraction((DTreeItem)this.event.getElement(), ctx).expand();
            } else {
                new DTreeItemUserInteraction((DTreeItem)this.event.getElement(), ctx).collapse();
            }
        }
    }
}

