/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor.provider;

import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.TreeItemStyle;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeViewer;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeViewerManager;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.ui.PlatformUI;

public class TreeUIUpdater
extends ResourceSetListenerImpl {
    private DTreeViewerManager dTreeViewerManager;
    private DTreeViewer dTreeViewer;

    public TreeUIUpdater(DTreeViewerManager dTreeViewerManager) {
        this.dTreeViewerManager = dTreeViewerManager;
        this.dTreeViewer = (DTreeViewer)dTreeViewerManager.getTreeViewer();
        dTreeViewerManager.getEditingDomain().addResourceSetListener((ResourceSetListener)this);
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    private boolean isCustom(Notification notif) {
        return notif.getEventType() == -1;
    }

    private void notifyChanged(Notification notification) {
        Resource resource;
        if (this.dTreeViewer == null || this.dTreeViewer.getControl() == null || this.dTreeViewer.getControl().isDisposed()) {
            TransactionalEditingDomain domain;
            if (notification.getNotifier() instanceof EObject && (domain = TransactionUtil.getEditingDomain((Object)notification.getNotifier())) != null) {
                domain.removeResourceSetListener((ResourceSetListener)this);
            }
            return;
        }
        Object notifier = notification.getNotifier();
        if (notifier instanceof Resource && "odesign".equals((resource = (Resource)notifier).getURI().fileExtension()) && (notification.getFeatureID(Resource.class) == 3 || notification.getFeatureID(Resource.class) == 4)) {
            this.dTreeViewerManager.setDescriptionFileChanged(true);
        }
        if (this.isChangeAboutDTreeModel(notification)) {
            if (notifier instanceof DTree) {
                this.handleDTreeNotification(notification, (DTree)notifier);
            } else if (notifier instanceof DTreeItem) {
                this.handleDTreeItemNotification(notification, (DTreeItem)notifier);
            } else if (notifier instanceof TreeItemStyle) {
                this.handleDTreeItemNotification(notification, (TreeItemStyle)notifier);
            } else if (notifier instanceof RGBValues) {
                this.handleDTreItemNotification(notification, (RGBValues)notifier);
            }
        }
    }

    private boolean isChangeAboutDTreeModel(Notification notification) {
        boolean isImpactingNotification = false;
        Object notifier = notification.getNotifier();
        if (notifier instanceof EObject) {
            EObject eObject = (EObject)notifier;
            while (eObject != null && !isImpactingNotification) {
                if (eObject instanceof DTree) {
                    isImpactingNotification = true;
                    continue;
                }
                eObject = eObject.eContainer();
            }
        }
        return isImpactingNotification;
    }

    private void handleDTreeNotification(Notification n, DTree tree) {
        int featureID = n.getFeatureID(DTree.class);
        switch (featureID) {
            case 6: 
            case 7: {
                DslCommonPlugin.PROFILER.startWork("Refresh the SWT table");
                this.refreshViewer(tree);
                DslCommonPlugin.PROFILER.stopWork("Refresh the SWT table");
                break;
            }
        }
    }

    private void handleDTreeItemNotification(Notification n, final DTreeItem dTreeItem) {
        int featureID = n.getFeatureID(DTreeItem.class);
        switch (featureID) {
            case 2: 
            case 6: {
                DslCommonPlugin.PROFILER.startWork("Update a line of the SWT table");
                this.updateViewer(dTreeItem);
                DslCommonPlugin.PROFILER.stopWork("Update a line of the SWT table");
                break;
            }
            case 1: {
                DslCommonPlugin.PROFILER.startWork("Refresh a line of the SWT table");
                this.refreshViewer(dTreeItem);
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (TreeUIUpdater.this.dTreeViewer != null && TreeUIUpdater.this.dTreeViewer.getControl() != null && !TreeUIUpdater.this.dTreeViewer.getControl().isDisposed()) {
                            TreeUIUpdater.this.dTreeViewer.setExpandedState(dTreeItem, dTreeItem.isExpanded());
                        }
                    }
                });
                DslCommonPlugin.PROFILER.stopWork("Refresh a line of the SWT table");
                break;
            }
            case 5: {
                if (!(n.getNewValue() instanceof Boolean)) break;
                DslCommonPlugin.PROFILER.startWork("Change the collapse state of a line of the SWT table");
                final boolean expanded = n.getNewBooleanValue();
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (TreeUIUpdater.this.dTreeViewer != null && TreeUIUpdater.this.dTreeViewer.getControl() != null && !TreeUIUpdater.this.dTreeViewer.getControl().isDisposed()) {
                            TreeUIUpdater.this.dTreeViewer.setExpandedState(dTreeItem, expanded);
                        }
                    }
                });
                DslCommonPlugin.PROFILER.stopWork("Change the collapse state of a line of the SWT table");
                break;
            }
        }
    }

    private void handleDTreeItemNotification(Notification n, TreeItemStyle notifier) {
        int featureID = n.getFeatureID(TreeItemStyle.class);
        switch (featureID) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                DTreeItem treeItem = (DTreeItem)notifier.eContainer();
                if (treeItem == null) break;
                DslCommonPlugin.PROFILER.startWork("Update a line of the SWT table");
                this.updateViewer(treeItem);
                DslCommonPlugin.PROFILER.stopWork("Update a line of the SWT table");
                break;
            }
        }
    }

    private void handleDTreItemNotification(Notification notification, RGBValues notifier) {
        int featureID = notification.getFeatureID(TreeItemStyle.class);
        switch (featureID) {
            case 0: 
            case 1: 
            case 2: {
                TreeItemStyle treeItemStyle;
                EObject treeitemStyleContainer;
                EObject notifierContainer = notifier.eContainer();
                if (!(notifierContainer instanceof TreeItemStyle) || (treeitemStyleContainer = (treeItemStyle = (TreeItemStyle)notifierContainer).eContainer()) == null) break;
                DslCommonPlugin.PROFILER.startWork("Update a line of the SWT table");
                this.updateViewer(treeitemStyleContainer);
                DslCommonPlugin.PROFILER.stopWork("Update a line of the SWT table");
                break;
            }
        }
    }

    private void refreshViewer(final Object object) {
        if (object != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TreeUIUpdater.this.dTreeViewer != null && TreeUIUpdater.this.dTreeViewer.getControl() != null && !TreeUIUpdater.this.dTreeViewer.getControl().isDisposed()) {
                        TreeUIUpdater.this.dTreeViewer.refresh(object, true);
                    }
                }
            });
        }
    }

    private void updateViewer(final Object object) {
        if (object != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TreeUIUpdater.this.dTreeViewer != null && TreeUIUpdater.this.dTreeViewer.getControl() != null && !TreeUIUpdater.this.dTreeViewer.getControl().isDisposed()) {
                        TreeUIUpdater.this.dTreeViewer.update(object, null);
                    }
                }
            });
        }
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        super.resourceSetChanged(event);
        for (Notification notif : Iterables.filter((Iterable)event.getNotifications(), Notification.class)) {
            if (this.isCustom(notif)) continue;
            this.notifyChanged(notif);
        }
    }

    public void dispose() {
        if (this.getTarget() != null) {
            this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        }
    }
}

