/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.tools.internal.command;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tree.DTree;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.internal.helper.TreeHelper;
import org.eclipse.sirius.tree.business.internal.refresh.DTreeElementSynchronizerSpec;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class RefreshTreeElementCommand
extends RecordingCommand {
    private DTreeItem treeElement;

    public RefreshTreeElementCommand(TransactionalEditingDomain domain, DTreeItem treeElement, IProgressMonitor monitor) {
        super(domain, "Refresh representation");
        this.treeElement = treeElement;
    }

    public RefreshTreeElementCommand(TransactionalEditingDomain domain, DTreeItem treeElement) {
        this(domain, treeElement, null);
    }

    protected void doExecute() {
        DTree tree = TreeHelper.getTree(this.treeElement);
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(tree.getTarget());
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)tree);
        DTreeElementSynchronizerSpec synchronizer = new DTreeElementSynchronizerSpec(interpreter, accessor);
        synchronizer.refreshItemAndChildren(this.treeElement);
    }
}

