/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.assist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.sirius.common.tools.api.contentassist.ContentContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.common.tools.api.interpreter.CompoundInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.tools.internal.assist.ContentContextHelper;
import org.eclipse.sirius.common.ui.tools.internal.contentassist.ContentProposalConverter;
import org.eclipse.sirius.ext.swt.TextChangeListener;
import org.eclipse.sirius.tools.api.interpreter.context.SiriusInterpreterContextFactory;
import org.eclipse.sirius.ui.tools.api.assist.ContentProposalClient;
import org.eclipse.sirius.ui.tools.api.assist.IAssistContentProvider;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;

public class TextContentProposalProvider
implements IAssistContentProvider {
    private AbstractPropertySection view;
    private EObject element;
    private EStructuralFeature feature;

    public IContentProposal[] getProposals(String contents, int position) {
        if (StringUtil.isEmpty((String)contents)) {
            List prefixes = CompoundInterpreter.INSTANCE.getAllNewEmtpyExpressions();
            return new ContentProposalConverter("").convertToJFaceContentProposals(prefixes);
        }
        String prefix = CompoundInterpreter.INSTANCE.getVariablePrefix(contents);
        ContentContext context = this.getContentContext(contents, position);
        String proposalStart = new ContentContextHelper(contents, position, prefix).getProposalStart();
        List<ContentProposal> proposals = new ArrayList<ContentProposal>();
        if (!StringUtil.isEmpty((String)proposalStart) && !StringUtil.isEmpty((String)prefix)) {
            proposalStart.contains(prefix);
        }
        proposals.addAll(CompoundInterpreter.INSTANCE.getProposals((IInterpreter)CompoundInterpreter.INSTANCE, context));
        proposals = TextContentProposalProvider.removeDuplicatedProposals(proposals);
        ContentProposalConverter contentProposalConverter = new ContentProposalConverter(proposalStart);
        return contentProposalConverter.convertToJFaceContentProposals(proposals);
    }

    private ContentContext getContentContext(String text, int position) {
        Object selectedElement = this.getSelectedElement();
        EStructuralFeature f = this.getEStructuralFeature();
        IInterpreterContext interContext = SiriusInterpreterContextFactory.createInterpreterContext((EObject)((EObject)selectedElement), (EStructuralFeature)f);
        return new ContentContext(text, position, interContext);
    }

    private Object getSelectedElement() {
        if (this.element == null && this.view != null) {
            return ((TreeSelection)this.view.getSelection()).getFirstElement();
        }
        return this.element;
    }

    private static List<ContentProposal> removeDuplicatedProposals(List<ContentProposal> contents) {
        ArrayList<ContentProposal> resultProposals = new ArrayList<ContentProposal>();
        for (ContentProposal entry : contents) {
            if (resultProposals.contains(entry)) continue;
            resultProposals.add(entry);
        }
        return resultProposals;
    }

    private EStructuralFeature getEStructuralFeature() {
        EStructuralFeature f = null;
        if (this.feature != null) {
            f = this.feature;
        } else if (this.view instanceof ContentProposalClient) {
            f = ((ContentProposalClient)this.view).getFeature();
        }
        return f;
    }

    @Override
    public void setView(AbstractPropertySection view) {
        this.view = view;
    }

    @Override
    public void initContext(EObject selectedElement, EStructuralFeature selectedFeature) {
        this.element = selectedElement;
        this.feature = selectedFeature;
    }

    public void proposalPopupClosed(ContentProposalAdapter adapter) {
        Text text = (Text)adapter.getControl();
        if (this.view instanceof ContentProposalClient) {
            TextChangeListener helper = ((ContentProposalClient)this.view).getListener();
            helper.startListeningTo(text);
            helper.startListeningForEnter(text);
        }
    }

    public void proposalPopupOpened(ContentProposalAdapter adapter) {
        Text text = (Text)adapter.getControl();
        if (this.view instanceof ContentProposalClient) {
            TextChangeListener helper = ((ContentProposalClient)this.view).getListener();
            helper.stopListeningTo(text);
        }
    }
}

