/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common.modelingproject.manager;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.query.ResourceQuery;
import org.eclipse.sirius.business.api.resource.LoadEMFResource;
import org.eclipse.sirius.business.api.session.DefaultLocalSessionCreationOperation;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetFactory;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.ui.tools.internal.views.common.modelingproject.ModelingProjectFileQuery;
import org.eclipse.sirius.ui.tools.internal.views.common.modelingproject.OpenRepresentationsFileJob;

public class ModelingProjectManagerImpl
implements ModelingProjectManager {
    private static final String VIEWPOINT_MODELING_PROJECT_NATURE_ID = "fr.obeo.dsl.viewpoint.nature.modelingproject";
    private final SessionManagerListener sessionManagerListener = new SessionManagerListener.Stub(){

        public void notify(Session updated, int notification) {
            if (notification != 6 && notification == 7) {
                ModelingProjectManagerImpl.this.sessionFileLoading.remove(updated.getSessionResource().getURI());
            }
        }
    };
    private Predicate<URI> isAlreadyLoadedPredicate = new Predicate<URI>(){

        public boolean apply(URI representationsFileURI) {
            return ModelingProjectManagerImpl.this.isAlreadyLoaded(representationsFileURI);
        }
    };
    private Set<URI> sessionFileLoading = Sets.newHashSet();

    protected ModelingProjectManagerImpl() {
    }

    public static ModelingProjectManagerImpl init() {
        return new ModelingProjectManagerImpl();
    }

    @Override
    public void loadAndOpenRepresentationsFile(URI representationsFileURI) {
        this.loadAndOpenRepresentationsFiles(Lists.newArrayList((Object[])new URI[]{representationsFileURI}));
    }

    @Override
    public void loadAndOpenRepresentationsFiles(List<URI> representationsFilesURIs) {
        SessionManager.INSTANCE.addSessionsListener(this.sessionManagerListener);
        UnmodifiableIterator representationsFilesURIsToLoadIterator = Iterators.filter(representationsFilesURIs.iterator(), (Predicate)Predicates.not((Predicate)Predicates.or((Predicate)Predicates.in(this.sessionFileLoading), this.isAlreadyLoadedPredicate)));
        if (!representationsFilesURIsToLoadIterator.hasNext()) {
            return;
        }
        ArrayList tempRepresentationsFilesURIs = Lists.newArrayList((Iterator)representationsFilesURIsToLoadIterator);
        this.sessionFileLoading.addAll(tempRepresentationsFilesURIs);
        OpenRepresentationsFileJob.scheduleNewWhenPossible(tempRepresentationsFilesURIs, false);
    }

    private boolean isAlreadyLoaded(URI representationsFileURI) {
        for (Session session : Collections.unmodifiableCollection(SessionManager.INSTANCE.getSessions())) {
            if (!representationsFileURI.equals(session.getSessionResource().getURI())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearCache(URI representationsFileURI) {
        this.sessionFileLoading.remove(representationsFileURI);
    }

    @Override
    public IProject createNewModelingProject(String projectName, boolean createAndOpenBlankRepresentationsFile, IProgressMonitor monitor) throws CoreException {
        return this.createNewModelingProject(projectName, null, createAndOpenBlankRepresentationsFile, monitor);
    }

    @Override
    public IProject createNewModelingProject(final String projectName, final IPath projectLocationPath, final boolean createAndOpenBlankRepresentationsFile, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask("Modeling Project creation : " + projectName, 3);
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    if (!project.exists()) {
                        IProjectDescription desc = project.getWorkspace().newProjectDescription(projectName);
                        IPath projectLocationPathTemp = projectLocationPath;
                        if (projectLocationPath != null && ResourcesPlugin.getWorkspace().getRoot().getLocation().equals((Object)projectLocationPath)) {
                            projectLocationPathTemp = null;
                        }
                        desc.setLocation(projectLocationPathTemp);
                        String[] natures = new String[]{"org.eclipse.sirius.nature.modelingproject"};
                        desc.setNatureIds(natures);
                        monitor.subTask("Create project");
                        project.create(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        monitor.subTask("Open project");
                        project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        if (createAndOpenBlankRepresentationsFile) {
                            monitor.subTask("Create local representations file");
                            ModelingProjectManagerImpl.this.createLocalRepresentationsFile(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                    if (!project.isOpen()) {
                        project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        ResourcesPlugin.getWorkspace().run(create, monitor);
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    @Override
    public void convertToModelingProject(final IProject project, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask("Conversion to Modeling Project", 1);
                    ModelingProjectManagerImpl.this.doAddModelingNature(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                finally {
                    monitor.done();
                }
            }
        };
        if (this.alreadyIsInWorkspaceModificationOperation()) {
            this.doAddModelingNature(project, monitor);
        } else {
            ResourcesPlugin.getWorkspace().run(create, monitor);
        }
    }

    private boolean alreadyIsInWorkspaceModificationOperation() {
        Job currentJob = Job.getJobManager().currentJob();
        return currentJob != null && currentJob.getRule() != null;
    }

    @Override
    public void removeModelingNature(final IProject project, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable create = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ModelingProjectManagerImpl.this.doRemoveModelingNature(project, monitor);
            }
        };
        ResourcesPlugin.getWorkspace().run(create, monitor);
    }

    @Override
    public void createLocalRepresentationsFile(IProject project, IProgressMonitor monitor) throws CoreException {
        URI representationsURI = URI.createPlatformResourceURI((String)project.getFullPath().append("representations.aird").toString(), (boolean)true);
        DefaultLocalSessionCreationOperation sessionCreationOperation = new DefaultLocalSessionCreationOperation(representationsURI, monitor);
        sessionCreationOperation.execute();
    }

    protected void doAddModelingNature(IProject project, IProgressMonitor monitor) throws CoreException {
        block13: {
            try {
                Option optionalModelingProject;
                block14: {
                    monitor.beginTask("Add Modeling Project nature", 3);
                    IProjectDescription description = project.getDescription();
                    String[] natures = description.getNatureIds();
                    if (description.hasNature(VIEWPOINT_MODELING_PROJECT_NATURE_ID)) {
                        int i = 0;
                        while (i < natures.length) {
                            if (VIEWPOINT_MODELING_PROJECT_NATURE_ID.equals(natures[i])) {
                                natures[i] = "org.eclipse.sirius.nature.modelingproject";
                            }
                            ++i;
                        }
                        description.setNatureIds(natures);
                    } else {
                        String[] newNatures = new String[natures.length + 1];
                        System.arraycopy(natures, 0, newNatures, 1, natures.length);
                        newNatures[0] = "org.eclipse.sirius.nature.modelingproject";
                        description.setNatureIds(newNatures);
                    }
                    project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    optionalModelingProject = ModelingProject.asModelingProject((IProject)project);
                    if (!optionalModelingProject.some()) break block13;
                    try {
                        Option mainRepresentationsFileURI = ((ModelingProject)optionalModelingProject.get()).getMainRepresentationsFileURI((IProgressMonitor)new SubProgressMonitor(monitor, 1), false, true);
                        if (mainRepresentationsFileURI.some()) {
                            OpenRepresentationsFileJob.scheduleNewWhenPossible((URI)mainRepresentationsFileURI.get(), true);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        if (e.getMessage().contains("Zero representations file found in \"")) {
                            ModelingProjectManager.INSTANCE.createLocalRepresentationsFile(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        if (!e.getMessage().contains(". A modeling project must contain only one.")) break block14;
                        this.removeModelingNature(project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getMessage()));
                    }
                }
                if (OpenRepresentationsFileJob.shouldWaitOtherJobs()) {
                    OpenRepresentationsFileJob.waitOtherJobs();
                }
                if (((ModelingProject)optionalModelingProject.get()).getSession() != null) {
                    this.addSemanticResources((IContainer)project, ((ModelingProject)optionalModelingProject.get()).getSession(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    protected void doRemoveModelingNature(IProject project, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Remove Modeling Project nature", -1);
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if ("org.eclipse.sirius.nature.modelingproject".equals(natures[i])) {
                    String[] newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                    description.setNatureIds(newNatures);
                    project.setDescription(description, (IProgressMonitor)new SubProgressMonitor(monitor, -1));
                    project.deleteMarkers("org.eclipse.sirius.modelingMarker", false, 0);
                    break;
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    private void addSemanticResources(IContainer container, Session session, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("Semantic resources addition", 1);
            Command semanticResourcesAdditionCommand = this.getSemanticResourcesAdditionCommand(container, session, monitor);
            session.getTransactionalEditingDomain().getCommandStack().execute(semanticResourcesAdditionCommand);
        }
        finally {
            monitor.done();
        }
    }

    private Command getSemanticResourcesAdditionCommand(IContainer container, Session session, IProgressMonitor monitor) throws CoreException {
        CompoundCommand cc = new CompoundCommand();
        if (container != null) {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Command subCc;
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFile && new ModelingProjectFileQuery((IFile)resource).isPotentialSemanticResource() && this.isLoadableModel((IFile)resource, session)) {
                    URI uri = URI.createPlatformResourceURI((String)resource.getFullPath().toOSString(), (boolean)true);
                    AddSemanticResourceCommand cmd = new AddSemanticResourceCommand(session, uri, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    cc.append((Command)cmd);
                } else if (resource instanceof IContainer && (subCc = this.getSemanticResourcesAdditionCommand((IContainer)resource, session, monitor)).canExecute()) {
                    cc.append(subCc);
                }
                ++n2;
            }
        }
        return cc;
    }

    private boolean isLoadableModel(IFile file, Session session) {
        if (file == null) {
            return false;
        }
        ResourceSet set = ResourceSetFactory.createFactory().createResourceSet(session.getSessionResource().getURI());
        LoadEMFResource runnable = new LoadEMFResource(set, file);
        runnable.run();
        Resource resource = runnable.getLoadedResource();
        return resource != null && !new ResourceQuery(resource).isRepresentationsResource();
    }
}

