/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.modelingproject.manager;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tools.api.command.semantic.RemoveSemanticResourceCommand;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class DetachSemanticResourcesJob
extends Job {
    private static final String ACTION_NAME = "Detach semantic resources";
    private Map<Session, Set<URI>> semanticResourcesURIsToDetachPerSession;

    public DetachSemanticResourcesJob(Map<Session, Set<URI>> semanticResourcesURIsToDetachPerSession) {
        super(ACTION_NAME);
        this.semanticResourcesURIsToDetachPerSession = semanticResourcesURIsToDetachPerSession;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            try {
                monitor.beginTask(ACTION_NAME, 2);
                for (final Session session : this.semanticResourcesURIsToDetachPerSession.keySet()) {
                    if (session == null || !session.isOpen()) continue;
                    TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
                    Set<URI> semanticResourcesURIsToDetach = this.semanticResourcesURIsToDetachPerSession.get(session);
                    CompoundCommand compoundCommand = new CompoundCommand();
                    for (final URI semanticResourcesURI : semanticResourcesURIsToDetach) {
                        RunnableWithResult.Impl<Resource> resourceGetter = new RunnableWithResult.Impl<Resource>(){

                            public void run() {
                                Resource semanticResource = session.getTransactionalEditingDomain().getResourceSet().getResource(semanticResourcesURI, false);
                                this.setResult(semanticResource);
                            }
                        };
                        TransactionUtil.runExclusive((TransactionalEditingDomain)domain, (RunnableWithResult)resourceGetter);
                        RemoveSemanticResourceCommand removeSemanticResourceCmd = new RemoveSemanticResourceCommand(session, (Resource)resourceGetter.getResult(), true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        compoundCommand.append((Command)removeSemanticResourceCmd);
                    }
                    monitor.worked(1);
                    session.getTransactionalEditingDomain().getCommandStack().execute((Command)compoundCommand);
                }
            }
            catch (Exception e) {
                SiriusPlugin.getDefault().error(e.getMessage(), e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        return "org.eclipse.sirius.representationsFile".equals(family);
    }
}

