/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.danalysis;

import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.internal.query.DAnalysisesInternalQuery;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.business.internal.session.danalysis.SemanticResourceGetter;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public class SemanticResourcesUpdater
extends AdapterImpl
implements Adapter {
    private DAnalysisSessionImpl dAnalysisSessionImpl;
    private Collection<Resource> semanticResources;

    public SemanticResourcesUpdater(DAnalysisSessionImpl dAnalysisSessionImpl, Collection<Resource> semanticResources) {
        this.dAnalysisSessionImpl = dAnalysisSessionImpl;
        Collection<DAnalysis> allAnalyses = new DAnalysisesInternalQuery((Collection<DAnalysis>)dAnalysisSessionImpl.getAnalyses()).getAllAnalyses();
        for (DAnalysis dAnalysis : allAnalyses) {
            if (dAnalysis.eAdapters().contains((Object)this)) continue;
            dAnalysis.eAdapters().add((Object)this);
        }
        this.semanticResources = semanticResources;
    }

    public void notifyChanged(Notification msg) {
        if (!(msg.isTouch() || msg.getFeature() != ViewpointPackage.Literals.DANALYSIS_SESSION_EOBJECT__ANALYSES && msg.getFeature() != ViewpointPackage.Literals.DANALYSIS__REFERENCED_ANALYSIS && msg.getFeature() != ViewpointPackage.Literals.DANALYSIS_SESSION_EOBJECT__ANALYSES && msg.getFeature() != ViewpointPackage.Literals.DANALYSIS__MODELS && msg.getFeature() != ViewpointPackage.Literals.DANALYSIS_SESSION_EOBJECT__CONTROLLED_RESOURCES)) {
            SemanticResourceGetter semanticResourcesGetter = new SemanticResourceGetter(this.dAnalysisSessionImpl);
            semanticResourcesGetter.run();
            boolean hasNbOfSemanticResourcesChanged = this.semanticResources.size() != ((Collection)semanticResourcesGetter.getResult()).size();
            this.semanticResources.clear();
            this.semanticResources.addAll((Collection)semanticResourcesGetter.getResult());
            if (hasNbOfSemanticResourcesChanged) {
                this.dAnalysisSessionImpl.transfertNotification(11);
            }
        }
    }

    public void dispose() {
        Collection<DAnalysis> allAnalyses = new DAnalysisesInternalQuery((Collection<DAnalysis>)this.dAnalysisSessionImpl.getAnalyses()).getAllAnalyses();
        for (DAnalysis dAnalysis : allAnalyses) {
            if (!dAnalysis.eAdapters().contains((Object)this)) continue;
            dAnalysis.eAdapters().remove((Object)this);
        }
        this.dAnalysisSessionImpl = null;
        this.semanticResources = null;
    }
}

