/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.timeline;

import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2D;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Coord2DList;

public class CurveAreaCompensationHelper {
    Coord2D[] oldPointsAll;
    Coord2D[] oldPoints;
    Coord2D[] newPointsAll;
    Coord2D[] newPoints;
    private final double EPS = 1.0E-6;

    public CurveAreaCompensationHelper(Coord2DList points, Coord2D[] oldPoints, Coord2D[] newPoints) {
        this.oldPointsAll = points.toArray();
        this.oldPoints = oldPoints;
        this.newPointsAll = points.toArray();
        this.newPoints = newPoints;
        if (oldPoints.length != 0) {
            int firstChangedIndex = points.size();
            int lastChangedIndex = -1;
            int i = 0;
            while (i < oldPoints.length) {
                firstChangedIndex = Math.min(firstChangedIndex, points.getIndex(oldPoints[i]));
                lastChangedIndex = Math.max(lastChangedIndex, points.getIndex(oldPoints[i]));
                ++i;
            }
            i = 0;
            while (i < newPoints.length) {
                this.newPointsAll[firstChangedIndex + i] = newPoints[i];
                ++i;
            }
            double areaBeforeChange = 0.0;
            double areaAfterChange = 0.0;
            int i2 = 0;
            while (i2 < this.oldPointsAll.length) {
                areaBeforeChange += this.getArea(this.oldPointsAll, i2);
                areaAfterChange += this.getArea(this.newPointsAll, i2);
                ++i2;
            }
            double areaLeftOfChange = 0.0;
            int i3 = 0;
            while (i3 < firstChangedIndex) {
                areaLeftOfChange += this.getArea(this.newPointsAll, i3);
                ++i3;
            }
            double areaRightOfChange = 0.0;
            int i4 = lastChangedIndex + 1;
            while (i4 < points.size()) {
                areaRightOfChange += this.getArea(this.newPointsAll, i4);
                ++i4;
            }
            double areaOutsideOfChange = areaLeftOfChange + areaRightOfChange;
            double areaDiff = areaAfterChange - areaBeforeChange;
            if (points.size() > 1 && areaDiff != 0.0) {
                if (areaDiff < 0.0 && lastChangedIndex < points.size() - 1) {
                    this.changeCurveToRight(areaDiff, lastChangedIndex + 1);
                } else if (areaDiff < 0.0 && firstChangedIndex > 0) {
                    this.changeCurveToRightAndLeft(areaDiff, firstChangedIndex - 1, lastChangedIndex + 1);
                } else if (areaDiff <= areaRightOfChange) {
                    this.changeCurveToRight(areaDiff, lastChangedIndex + 1);
                } else if (areaDiff <= areaOutsideOfChange) {
                    this.changeCurveToRightAndLeft(areaDiff, firstChangedIndex - 1, lastChangedIndex + 1);
                }
            }
            this.normalizeCurve();
        }
    }

    private void changeCurveToRight(double areaDiff, int index) {
        System.out.println("*** changeCurveToRight");
        Coord2DList oldPointsPlus = new Coord2DList(this.oldPoints);
        Coord2DList newPointsPlus = new Coord2DList(this.newPoints);
        if (areaDiff > 0.0) {
            while (index < this.oldPointsAll.length && areaDiff > 0.0) {
                double currentArea = this.getArea(this.newPointsAll, index);
                if (areaDiff > currentArea) {
                    oldPointsPlus.add(this.oldPointsAll[index]);
                    newPointsPlus.add(new Coord2D(this.newPointsAll[index].getX(), 0.0));
                    areaDiff -= currentArea;
                } else {
                    double yDiff = areaDiff / this.newPointsAll[index].getX();
                    oldPointsPlus.add(this.oldPointsAll[index]);
                    newPointsPlus.add(new Coord2D(this.newPointsAll[index].getX(), this.newPointsAll[index].getY() - yDiff));
                    areaDiff = 0.0;
                }
                ++index;
            }
        } else {
            double yDiff = -areaDiff / this.newPointsAll[index].getX();
            oldPointsPlus.add(this.oldPointsAll[index]);
            newPointsPlus.add(new Coord2D(this.newPointsAll[index].getX(), this.newPointsAll[index].getY() + yDiff));
        }
        this.oldPoints = oldPointsPlus.toArray();
        this.newPoints = newPointsPlus.toArray();
    }

    private void changeCurveToRightAndLeft(double areaDiff, int firstIndex, int lastIndex) {
        System.out.println("*** changeCurveToRight");
        Coord2DList oldPointsPlus = new Coord2DList(this.oldPoints);
        Coord2DList newPointsPlus = new Coord2DList(this.newPoints);
        if (areaDiff > 0.0) {
            int index = lastIndex;
            while (index < this.oldPointsAll.length) {
                areaDiff -= this.getArea(this.newPointsAll, index);
                oldPointsPlus.add(0, this.oldPointsAll[index]);
                newPointsPlus.add(0, new Coord2D(this.newPointsAll[index].getX(), 0.0));
                ++index;
            }
            while (firstIndex >= 0 && areaDiff > 0.0) {
                double currentArea = this.getArea(this.newPointsAll, firstIndex);
                if (areaDiff > currentArea) {
                    oldPointsPlus.add(0, this.oldPointsAll[firstIndex]);
                    newPointsPlus.add(0, new Coord2D(this.newPointsAll[firstIndex].getX(), 0.0));
                    areaDiff -= currentArea;
                } else {
                    double yDiff = areaDiff / this.newPointsAll[firstIndex].getX();
                    oldPointsPlus.add(0, this.oldPointsAll[firstIndex]);
                    newPointsPlus.add(0, new Coord2D(this.newPointsAll[firstIndex].getX(), this.newPointsAll[firstIndex].getY() - yDiff));
                    areaDiff = 0.0;
                }
                --firstIndex;
            }
        } else {
            double yDiff = -areaDiff / this.newPointsAll[firstIndex].getX();
            oldPointsPlus.add(this.oldPointsAll[firstIndex]);
            newPointsPlus.add(new Coord2D(this.newPointsAll[firstIndex].getX(), this.newPointsAll[firstIndex].getY() + yDiff));
        }
        this.oldPoints = oldPointsPlus.toArray();
        this.newPoints = newPointsPlus.toArray();
    }

    private void normalizeCurve() {
        block4: {
            double areaAll;
            block3: {
                areaAll = 0.0;
                int i = 0;
                while (i < this.newPointsAll.length) {
                    areaAll += this.getArea(this.newPointsAll, i);
                    ++i;
                }
                if (areaAll != 0.0) break block3;
                this.oldPoints = this.oldPointsAll;
                this.newPoints = new Coord2D[this.newPointsAll.length];
                i = 0;
                while (i < this.newPoints.length) {
                    this.newPoints[i] = new Coord2D(this.newPointsAll[i].getX(), 1.0);
                    ++i;
                }
                break block4;
            }
            if (!(areaAll > 0.0) || !(Math.abs(areaAll - 1.0) > 1.0E-6)) break block4;
            this.oldPoints = this.oldPointsAll;
            this.newPoints = new Coord2D[this.newPointsAll.length];
            double scale = 1.0 / areaAll;
            int i = 0;
            while (i < this.newPoints.length) {
                this.newPoints[i] = new Coord2D(this.newPointsAll[i].getX(), this.newPointsAll[i].getY() * scale);
                ++i;
            }
        }
    }

    private double getArea(Coord2D[] curve, int index) {
        return index == 0 ? curve[index].area() : (curve[index].getX() - curve[index - 1].getX()) * curve[index].getY();
    }
}

