/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages;

import com.gface.date.DatePickerCombo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.ide.simulation.ui.SimulationConfiguration;
import org.eclipse.stardust.ide.simulation.ui.SimulationConfigurationList;
import org.eclipse.stardust.ide.simulation.ui.SimulationInterval;
import org.eclipse.stardust.ide.simulation.ui.SimulationPlugin;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.propertypages.NotificationDispatcherGUI2Model;
import org.eclipse.stardust.ide.simulation.ui.propertypages.NotificationDispatcherModel2GUI;
import org.eclipse.stardust.ide.simulation.ui.propertypages.NotificationWorkaround;
import org.eclipse.stardust.ide.simulation.ui.propertypages.utils.AttributeAccessForModel;
import org.eclipse.stardust.ide.simulation.ui.propertypages.visitors.ChangeRetrieveFromAuditTrailVisitor;
import org.eclipse.stardust.ide.simulation.ui.propertypages.visitors.UpdateSimulationIntervalVisitor;
import org.eclipse.stardust.ide.simulation.ui.utils.SimulationDateFormat;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.core.editors.parts.NotificationAdaptee;
import org.eclipse.stardust.modeling.core.editors.parts.NotificationAdapter;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SimulationConfigurationPropertyPage
extends AbstractModelElementPropertyPage {
    Button currentConfigurationCheckBox;
    private LabeledText configurationNameText;
    private LabeledText descriptionTextArea;
    private DatePickerCombo fromDatePicker;
    private DatePickerCombo toDatePicker;
    private Button enableRetrieveFromAuditTrailOnAll;
    private Button disableRetrieveFromAuditTrailOnAll;
    private SimulationInterval interval;
    NotificationAdapter notificationAdapter;

    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        SimulationConfiguration simulationConfiguration = this.updateFieldsFromElement(element);
        this.interval = simulationConfiguration.getInterval();
        this.registerAsListener(element);
        SimulationConfigurationList simulationConfigurationList = (SimulationConfigurationList)this.getElement().getAdapter(SimulationConfigurationList.class);
        if (simulationConfiguration.getId() == simulationConfigurationList.getCurrentConfigurationId()) {
            NotificationWorkaround.notifyListeners(element);
        }
        this.enableRetrieveFromAuditTrailOnAll.setSelection(false);
        this.disableRetrieveFromAuditTrailOnAll.setSelection(false);
    }

    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        this.unregisterAsListener(element);
        SimulationConfiguration simulationConfiguration = this.updateElementFromFields(element);
        boolean intervalChange = !simulationConfiguration.getInterval().equals(this.interval);
        simulationConfiguration.writeSimulationConfigurationToModel(new AttributeAccessForModel((IExtensibleElement)element, ""));
        if (intervalChange) {
            new UpdateSimulationIntervalVisitor(ModelUtils.findContainingModel((EObject)element), simulationConfiguration, this.interval);
        }
        if (this.enableRetrieveFromAuditTrailOnAll.getSelection()) {
            new ChangeRetrieveFromAuditTrailVisitor(ModelUtils.findContainingModel((EObject)element), simulationConfiguration, true);
        } else if (this.disableRetrieveFromAuditTrailOnAll.getSelection()) {
            new ChangeRetrieveFromAuditTrailVisitor(ModelUtils.findContainingModel((EObject)element), simulationConfiguration, false);
        }
    }

    protected SimulationConfiguration updateFieldsFromElement(IModelElement element) {
        SimulationConfigurationList simulationConfigurationList = (SimulationConfigurationList)this.getElement().getAdapter(SimulationConfigurationList.class);
        SimulationConfiguration simulationConfiguration = (SimulationConfiguration)this.getElement().getAdapter(SimulationConfiguration.class);
        try {
            this.configurationNameText.getText().setText(simulationConfiguration.getName());
            this.descriptionTextArea.getText().setText(simulationConfiguration.getDescription());
            this.fromDatePicker.setDate(simulationConfiguration.getInterval().getStartDate());
            this.toDatePicker.setDate(simulationConfiguration.getInterval().getEndDate());
            this.currentConfigurationCheckBox.setSelection(simulationConfiguration.getId() == simulationConfigurationList.getCurrentConfigurationId());
        }
        catch (RuntimeException e) {
            SimulationPlugin.getDefault().getLog().log((IStatus)new Status(2, SimulationPlugin.getDefault().getBundle().getSymbolicName(), 0, null, (Throwable)e));
        }
        return simulationConfiguration;
    }

    protected SimulationConfiguration updateElementFromFields(IModelElement element) {
        SimulationConfigurationList simulationConfigurationList = (SimulationConfigurationList)this.getElement().getAdapter(SimulationConfigurationList.class);
        SimulationConfiguration simulationConfiguration = (SimulationConfiguration)this.getElement().getAdapter(SimulationConfiguration.class);
        simulationConfiguration.setName(this.configurationNameText.getText().getText());
        simulationConfiguration.setDescription(this.descriptionTextArea.getText().getText());
        if (this.currentConfigurationCheckBox.getSelection()) {
            simulationConfigurationList.setCurrentSimulationConfiguration(simulationConfiguration);
        }
        simulationConfiguration.setIntervalStart(this.fromDatePicker.getDate());
        simulationConfiguration.setIntervalEnd(this.toDatePicker.getDate());
        return simulationConfiguration;
    }

    public void registerAsListener(IModelElement element) {
        if (this.notificationAdapter != null) {
            this.unregisterAsListener(element);
        }
        this.notificationAdapter = new NotificationAdapter((NotificationAdaptee)new NotificationDispatcherModel2GUI(element){

            @Override
            public void updateOnChanges() {
                SimulationConfigurationPropertyPage.this.updateFieldsFromElement(this.element);
            }
        });
        NotificationWorkaround.register(element, this.notificationAdapter);
        this.currentConfigurationCheckBox.addSelectionListener((SelectionListener)new NotificationDispatcherGUI2Model(element){

            @Override
            public void updateOnChanges() {
                SimulationConfigurationPropertyPage.this.updateElementFromFields(this.element);
                NotificationWorkaround.notifyListeners(this.element);
            }
        });
    }

    public void unregisterAsListener(IModelElement element) {
        if (this.notificationAdapter != null) {
            NotificationWorkaround.unregister(element, this.notificationAdapter);
            this.notificationAdapter = null;
        }
    }

    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        this.currentConfigurationCheckBox = FormBuilder.createCheckBox((Composite)composite, (String)Simulation_Modeling_Messages.IS_CURRENT_CONFIGURATION, (int)2);
        this.configurationNameText = FormBuilder.createLabeledText((Composite)composite, (String)Simulation_Modeling_Messages.CONFIGURATION_NAME);
        this.descriptionTextArea = FormBuilder.createLabeledTextArea((Composite)composite, (String)Simulation_Modeling_Messages.CONFIGURATION_DESCRIPTION);
        FormBuilder.createLabel((Composite)composite, (String)Simulation_Modeling_Messages.CONFIGURATION_INTERVAL_START, (int)1);
        this.fromDatePicker = new DatePickerCombo(composite, 2048, 1);
        this.fromDatePicker.setDateFormat(SimulationDateFormat.getInteractiveDateFormatInstance());
        this.fromDatePicker.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData());
        FormBuilder.createLabel((Composite)composite, (String)Simulation_Modeling_Messages.CONFIGURATION_INTERVAL_END, (int)1);
        this.toDatePicker = new DatePickerCombo(composite, 2048, 1);
        this.toDatePicker.setDateFormat(SimulationDateFormat.getInteractiveDateFormatInstance());
        this.toDatePicker.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData());
        FormBuilder.createHorizontalSeparator((Composite)composite, (int)2);
        FormBuilder.createLabel((Composite)composite, (String)Simulation_Modeling_Messages.CONFIGURATION_ALL_RETRIVEAUDITTRAIL, (int)2);
        this.enableRetrieveFromAuditTrailOnAll = FormBuilder.createCheckBox((Composite)composite, (String)Simulation_Modeling_Messages.CONFIGURATION_ALL_RETRIVEAUDITTRAIL_ON, (int)2);
        this.disableRetrieveFromAuditTrailOnAll = FormBuilder.createCheckBox((Composite)composite, (String)Simulation_Modeling_Messages.CONFIGURATION_ALL_RETRIVEAUDITTRAIL_OFF, (int)2);
        this.enableRetrieveFromAuditTrailOnAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SimulationConfigurationPropertyPage.this.enableRetrieveFromAuditTrailOnAll.getSelection()) {
                    SimulationConfigurationPropertyPage.this.disableRetrieveFromAuditTrailOnAll.setSelection(false);
                }
            }
        });
        this.disableRetrieveFromAuditTrailOnAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SimulationConfigurationPropertyPage.this.disableRetrieveFromAuditTrailOnAll.getSelection()) {
                    SimulationConfigurationPropertyPage.this.enableRetrieveFromAuditTrailOnAll.setSelection(false);
                }
            }
        });
        return composite;
    }

    public void dispose() {
        try {
            IModelElementNodeSymbol symbol = (IModelElementNodeSymbol)this.getElement().getAdapter(IModelElementNodeSymbol.class);
            IModelElement element = (IModelElement)(symbol != null ? symbol.getModelElement() : this.getElement().getAdapter(IModelElement.class));
            if (element != null) {
                this.unregisterAsListener(element);
            }
        }
        catch (Exception exception) {}
    }
}

