/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.gui;

import org.eclipse.stardust.ide.simulation.ui.distributions.utils.TimeUnitHelper;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AdapterForTimeUnitWidget {
    public static final int MILLI_INDEX = 0;
    public static final int SECOND_INDEX = 1;
    public static final int MINUTE_INDEX = 2;
    public static final int HOUR_INDEX = 3;
    public static final int DAY_INDEX = 4;
    Combo widget;
    String[] unitId = new String[]{"MILLISECOND", "SECOND", "MINUTE", "HOUR", "DAY"};

    public AdapterForTimeUnitWidget(Composite parent, int style) {
        String[] messages = new String[this.unitId.length];
        int i = 0;
        while (i < messages.length) {
            messages[i] = TimeUnitHelper.getMessage(this.unitId[i]);
            ++i;
        }
        this.widget = new Combo(parent, style | 8);
        this.widget.setItems(messages);
        this.widget.select(0);
    }

    public Control getControl() {
        return this.widget;
    }

    public void setSelection(int index) {
        this.widget.select(index);
    }

    public int getSelection() {
        return this.widget.getSelectionIndex();
    }

    public long getPreferredMaxValue() {
        String lessPrecisionId = TimeUnitHelper.getLessPrecision(this.getUnitId());
        return lessPrecisionId != null ? TimeUnitHelper.getMultiplicator(lessPrecisionId) / TimeUnitHelper.getMultiplicator(this.getUnitId()) : 31L;
    }

    public String getUnitId() {
        return this.unitId[this.widget.getSelectionIndex()];
    }

    public void setUnitId(String unitId) {
        int index = "MILLISECOND".equals(unitId) ? 0 : ("SECOND".equals(unitId) ? 1 : ("MINUTE".equals(unitId) ? 2 : ("HOUR".equals(unitId) ? 3 : ("DAY".equals(unitId) ? 4 : 3))));
        this.widget.select(index);
    }

    public int getCalendarType() {
        return TimeUnitHelper.getCalendarType(this.getUnitId());
    }

    public void addSelectionListener(SelectionListener listener) {
        this.widget.addSelectionListener(listener);
    }
}

