/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.wst.common.utils;

import java.io.File;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.ide.wst.common.IModuleConfigurator;
import org.eclipse.stardust.ide.wst.common.IWebModuleConfigurator;
import org.eclipse.stardust.modeling.common.ui.BpmUiActivator;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class ProjectSetupUtils {
    public static final String LICENSE_PATH_TOKEN = "@licensePath@";
    public static final String IPP_RESOURCE_FOLDER = "ipp-resources";
    public static final String IPP_CONFIG_FOLDER = "WEB-INF/config/ipp";

    public static IFolder getWebInfLibDir(IProject pj) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)pj);
        IVirtualFolder vf = vc.getRootFolder().getFolder("WEB-INF/lib");
        return (IFolder)vf.getUnderlyingFolder();
    }

    public static void configureModule(IProject project, IModuleConfigurator configurator) {
        IVirtualComponent webComponent = ComponentCore.createComponent((IProject)project);
        ArtifactEdit artifact = ComponentUtilities.getArtifactEditForWrite((IVirtualComponent)webComponent);
        try {
            configurator.performConfiguration(artifact);
        }
        finally {
            artifact.dispose();
        }
    }

    public static IFolder getIppResourceFolder(IProject project) throws CoreException {
        Path path = new Path(IPP_RESOURCE_FOLDER);
        IFolder folder = project.getFolder((IPath)path);
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] cpEntries = javaProject.getRawClasspath();
            Path proRelPath = new Path("/" + project.getName() + "/" + folder.getProjectRelativePath());
            int i = 0;
            while (i < cpEntries.length) {
                IClasspathEntry entry = cpEntries[i];
                if (3 == entry.getEntryKind() && proRelPath.equals((Object)entry.getPath())) {
                    return folder;
                }
                ++i;
            }
            IClasspathEntry entry = JavaCore.newSourceEntry((IPath)project.getFullPath().append((IPath)path));
            IClasspathEntry[] modifiedCpEntries = new IClasspathEntry[cpEntries.length + 1];
            System.arraycopy(cpEntries, 0, modifiedCpEntries, 0, cpEntries.length);
            modifiedCpEntries[cpEntries.length] = entry;
            javaProject.setRawClasspath(modifiedCpEntries, null);
        }
        return folder;
    }

    public static IFolder getIppConfigFolder(IProject project) {
        Path path = new Path(IPP_CONFIG_FOLDER);
        IPath webContent = JSFAppConfigUtils.getWebContentFolder((IProject)project).getProjectRelativePath();
        return project.getFolder(webContent.append((IPath)path));
    }

    public static IFolder getIppJSFFolder(IProject project) {
        IFolder configFolder = ProjectSetupUtils.getIppConfigFolder(project);
        if (configFolder != null) {
            return configFolder.getFolder("jsf");
        }
        return null;
    }

    public static void configureWebModule(IProject project, IWebModuleConfigurator configurator) {
        WebArtifactEdit artifact = WebArtifactEdit.getWebArtifactEditForWrite((IProject)project);
        try {
            configurator.performConfiguration(artifact);
            artifact.saveIfNecessary(null);
        }
        finally {
            artifact.dispose();
        }
    }

    public static String getLicensePath() {
        String licensePath = BpmUiActivator.getDefault().getTraceFilePath();
        if (!StringUtils.isEmpty((String)licensePath)) {
            File fLicense = new File(licensePath);
            if (fLicense.exists()) {
                licensePath = fLicense.getAbsolutePath();
                licensePath = StringUtils.replace((String)licensePath, (String)"\\", (String)"/");
            } else {
                licensePath = LICENSE_PATH_TOKEN;
            }
        } else {
            licensePath = LICENSE_PATH_TOKEN;
        }
        return licensePath;
    }

    public static void addCommonProperties(IProject project, Map properties) {
        try {
            properties.put("resourceDir", ProjectSetupUtils.getIppResourceFolder(project).getLocation().toOSString());
            IPath proRelPath = JSFAppConfigUtils.getWebContentFolder((IProject)project).getProjectRelativePath();
            properties.put("webContentDir", project.getFolder(proRelPath).getLocation().toOSString());
        }
        catch (CoreException coreException) {}
    }

    public static void refreshCommonFolders(IProject project) {
        try {
            ProjectSetupUtils.getIppResourceFolder(project).refreshLocal(2, null);
            IPath webContentPath = JSFAppConfigUtils.getWebContentFolder((IProject)project).getProjectRelativePath();
            IFolder webContentFolder = project.getFolder(webContentPath);
            webContentFolder.refreshLocal(2, null);
        }
        catch (CoreException coreException) {}
    }
}

