/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.GroupSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;

public class DiagramUtil {
    public static <T> List<T> getSymbols(ISymbolContainer container, EStructuralFeature feature, IModelElement element) {
        List list = CollectionUtils.newList();
        DiagramUtil.addSymbols(list, container, feature, element);
        return list;
    }

    private static void addSymbols(List list, ISymbolContainer container, EStructuralFeature feature, IModelElement element) {
        block6: {
            Iterator i2;
            block5: {
                List symbols = (List)container.eGet(feature);
                int i = 0;
                while (i < symbols.size()) {
                    IGraphicalObject object = (IGraphicalObject)symbols.get(i);
                    if (element == null || !(object instanceof IModelElementNodeSymbol) || element.equals(((IModelElementNodeSymbol)object).getModelElement())) {
                        list.add(object);
                    }
                    ++i;
                }
                i2 = container.getGroupSymbol().iterator();
                while (i2.hasNext()) {
                    DiagramUtil.addSymbols(list, (GroupSymbolType)i2.next(), feature, element);
                }
                if (!(container instanceof DiagramType)) break block5;
                i2 = ((DiagramType)container).getPoolSymbols().iterator();
                while (i2.hasNext()) {
                    DiagramUtil.addSymbols(list, (ISymbolContainer)i2.next(), feature, element);
                }
                break block6;
            }
            if (!(container instanceof ISwimlaneSymbol)) break block6;
            i2 = ((ISwimlaneSymbol)((Object)container)).getChildLanes().iterator();
            while (i2.hasNext()) {
                DiagramUtil.addSymbols(list, (ISymbolContainer)i2.next(), feature, element);
            }
        }
    }

    public static INodeSymbol getClosestSymbol(INodeSymbol reference, EStructuralFeature feature, IModelElement element) {
        IGraphicalObject symbol = reference;
        while (symbol.eContainer() instanceof ISymbolContainer) {
            ISymbolContainer container = (ISymbolContainer)symbol.eContainer();
            List dataSymbols = DiagramUtil.getSymbols(container, feature, element);
            if (!dataSymbols.isEmpty()) {
                return DiagramUtil.findClosestSymbol(reference, dataSymbols);
            }
            if (!(container instanceof IGraphicalObject)) break;
            symbol = (IGraphicalObject)((Object)container);
        }
        return null;
    }

    private static INodeSymbol findClosestSymbol(INodeSymbol reference, List symbols) {
        INodeSymbol dataSymbol = (INodeSymbol)symbols.get(0);
        double distance = DiagramUtil.getDistance2(reference, dataSymbol);
        int i = 1;
        while (i < symbols.size()) {
            INodeSymbol symbol = (INodeSymbol)symbols.get(i);
            double newDistance = DiagramUtil.getDistance2(reference, symbol);
            if (newDistance < distance) {
                distance = newDistance;
                dataSymbol = symbol;
            }
            ++i;
        }
        return dataSymbol;
    }

    private static double getDistance2(INodeSymbol first, INodeSymbol second) {
        double i = first.getXPos() - second.getXPos();
        double j = first.getYPos() - second.getYPos();
        return i * i + j * j;
    }

    public static PoolSymbol getDefaultPool(DiagramType diagram) {
        EList<PoolSymbol> pools;
        PoolSymbol defaultPool = null;
        if (diagram != null && diagram.eContainer() instanceof ProcessDefinitionType && !(pools = diagram.getPoolSymbols()).isEmpty()) {
            for (PoolSymbol pool : pools) {
                if (!DiagramUtil.isDefaultPool(pool)) continue;
                defaultPool = pool;
                break;
            }
        }
        return defaultPool;
    }

    public static boolean isDefaultPool(ISwimlaneSymbol pool) {
        return pool instanceof PoolSymbol && "_default_pool__1".equals(pool.getId()) && pool.eContainer().eContainer() instanceof ProcessDefinitionType;
    }

    public static PoolSymbol createDefaultPool(DiagramType diagram) {
        PoolSymbol pool = CarnotWorkflowModelFactory.eINSTANCE.createPoolSymbol();
        pool.setId("_default_pool__1");
        pool.setName("Default Pool");
        pool.setXPos(0L);
        pool.setYPos(0L);
        pool.setWidth(-1);
        pool.setHeight(-1);
        if (diagram != null) {
            diagram.getPoolSymbols().add((Object)pool);
        }
        return pool;
    }

    public static boolean isDiagramModelElementProxy(EObject model) {
        DiagramType diagram = null;
        if (model instanceof DiagramType) {
            diagram = (DiagramType)model;
        }
        if (model instanceof IGraphicalObject) {
            diagram = ModelUtils.findContainingDiagram((IGraphicalObject)model);
        }
        if (diagram == null) {
            return false;
        }
        EObject root = diagram.eContainer();
        return model.eIsProxy() || diagram instanceof DiagramType && diagram.eIsProxy() || root instanceof ProcessDefinitionType && root.eIsProxy();
    }

    public static DiagramType findDiagramByName(List diagrams, String diagramName) {
        if (diagrams == null || diagrams.isEmpty()) {
            return null;
        }
        if (StringUtils.isEmpty((String)diagramName)) {
            return null;
        }
        for (DiagramType diagram : diagrams) {
            if (!diagramName.equals(diagram.getName())) continue;
            return diagram;
        }
        return null;
    }
}

