/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xml.type.internal.RegEx;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.core.preferences.configurationvariables.ConfigurationVariableScope;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DescriptionType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelVariable;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;

public class VariableContext {
    private List<ModelVariable> variables = new ArrayList<ModelVariable>();
    private Map<String, List<EObject>> variableReferences = new HashMap<String, List<EObject>>();
    private Map<String, Map<EObject, String>> elementReferences = new HashMap<String, Map<EObject, String>>();
    private Pattern pattern = Pattern.compile("(\\$\\{[^{}]+\\})");
    private ModelType model;
    private boolean criticalityFormulaChanged;

    private List<AttributeType> getConfigurationVariableElements(ModelType model) {
        ArrayList<AttributeType> elements = new ArrayList<AttributeType>();
        EList allAttributes = model.getAttribute();
        for (AttributeType at : allAttributes) {
            if (!at.getName().startsWith("ipp:variables")) continue;
            elements.add(at);
        }
        Collections.sort(elements, new ConfigurationVariableIndexComparator());
        return elements;
    }

    public void initializeVariables(ModelType model) {
        try {
            this.model = model;
            this.variableReferences.clear();
            this.variables.clear();
            int lastIndex = -1;
            List<AttributeType> configVariableElements = this.getConfigurationVariableElements(model);
            for (AttributeType configVariableElement : configVariableElements) {
                int variableIndex = VariableContext.getIndex(configVariableElement.getName());
                ModelVariable modelVariable = this.createModelVariable(configVariableElement);
                try {
                    if (lastIndex != variableIndex) {
                        this.parseVariables(model, modelVariable.getName());
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                lastIndex = variableIndex;
            }
        }
        catch (Throwable throwable) {}
    }

    public void saveVariables() {
        int j = 0;
        for (ModelVariable modelVariable : this.getVariables()) {
            this.removeAttributeSet(modelVariable, j);
            ++j;
        }
        j = 0;
        for (ModelVariable modelVariable : this.getVariables()) {
            this.createAttributeSet(modelVariable, j);
            if (modelVariable.isRemoved()) continue;
            ++j;
        }
    }

    public void createAttributeSet(ModelVariable modelVariable, int j) {
        if (!modelVariable.isRemoved()) {
            String saveName = modelVariable.getName().substring(2, modelVariable.getName().length() - 1);
            AttributeUtil.setAttribute(this.model, "ipp:variables[" + j + "]:name", "String", saveName);
            AttributeUtil.setAttribute(this.model, "ipp:variables[" + j + "]:defaultValue", "String", modelVariable.getDefaultValue());
            AttributeUtil.setAttribute(this.model, "ipp:variables[" + j + "]:description", "String", modelVariable.getDescription());
        }
    }

    private void removeAttributeSet(ModelVariable modelVariable, int j) {
        AttributeUtil.setAttribute(this.model, "ipp:variables[" + j + "]:name", "String", null);
        AttributeUtil.setAttribute(this.model, "ipp:variables[" + j + "]:defaultValue", "String", null);
        AttributeUtil.setAttribute(this.model, "ipp:variables[" + j + "]:description", "String", null);
    }

    private ModelVariable createModelVariable(AttributeType attribute) {
        ModelVariable modelVariable;
        int index = VariableContext.getIndex(attribute.getName());
        if (index + 1 > this.variables.size()) {
            modelVariable = new ModelVariable("", "", "");
            this.variables.add(modelVariable);
        }
        modelVariable = this.variables.get(index);
        String feature = attribute.getName().substring(attribute.getName().indexOf("]") + 2);
        if (feature.equals("name")) {
            modelVariable.setName("${" + attribute.getValue() + "}");
        }
        if (feature.equals("defaultValue")) {
            modelVariable.setDefaultValue(attribute.getValue());
        }
        if (feature.equals("description")) {
            modelVariable.setDescription(attribute.getValue());
        }
        return modelVariable;
    }

    public static int getIndex(String name) {
        int startIndex = name.indexOf("[");
        int endIndex = name.indexOf("]");
        String index = name.substring(startIndex + 1, endIndex);
        return Integer.parseInt(index);
    }

    private void parseVariables(EObject modelElement, String ref) {
        int idx = modelElement.toString().indexOf(ref);
        if (modelElement.eContainer() != null && idx > -1 && idx > 0 && modelElement.toString().charAt(idx - 1) != '\\') {
            List<EObject> refList = this.variableReferences.get(ref);
            if (refList == null) {
                refList = new ArrayList<EObject>();
                this.variableReferences.put(ref, refList);
            }
            refList.add(modelElement);
            if (modelElement.eContainer() instanceof IModelElement) {
                IModelElement parent = (IModelElement)modelElement.eContainer();
                Map<EObject, String> elementMap = this.elementReferences.get(String.valueOf(parent.getElementOid()));
                if (elementMap == null) {
                    elementMap = new HashMap<EObject, String>();
                    this.elementReferences.put(String.valueOf(parent.getElementOid()), elementMap);
                }
                elementMap.put(modelElement, ref);
            }
        }
        Iterator i = modelElement.eContents().iterator();
        while (i.hasNext()) {
            this.parseVariables((EObject)i.next(), ref);
        }
    }

    public void cleanupReferences() {
        ArrayList<ModelVariable> invalidVariables = new ArrayList<ModelVariable>();
        for (ModelVariable variable : this.variables) {
            ArrayList<EObject> invalidReferences = new ArrayList<EObject>();
            List<EObject> refList = this.variableReferences.get(variable.getName());
            if (refList == null) continue;
            for (EObject modelElement : refList) {
                if (modelElement.eContainer().toString().indexOf("ChangeDescriptionImpl") <= -1) continue;
                invalidReferences.add(modelElement);
            }
            if (invalidReferences.size() > 0 && invalidReferences.size() == refList.size()) {
                invalidVariables.add(variable);
                this.variableReferences.remove(variable.getName());
                continue;
            }
            refList.removeAll(invalidReferences);
        }
        this.variables.removeAll(invalidVariables);
    }

    public void refreshVariables(EObject modelElement) {
        Matcher matcher = this.pattern.matcher(modelElement.toString());
        if (modelElement.eContainer() != null) {
            while (matcher.find()) {
                if (matcher.start() != 0 && (matcher.start() <= 0 || modelElement.toString().charAt(matcher.start() - 1) == '\\')) continue;
                String ref = modelElement.toString().substring(matcher.start(), matcher.end());
                ref = ref.trim();
                ModelVariable modelVariable = null;
                List<EObject> refList = null;
                if (!this.variableExists(ref)) {
                    modelVariable = new ModelVariable(ref, "", "");
                    this.variables.add(modelVariable);
                } else {
                    modelVariable = this.getVariable(ref);
                    refList = this.getReferences(modelVariable);
                }
                if (refList == null) {
                    refList = new ArrayList<EObject>();
                    this.variableReferences.put(ref, refList);
                }
                if (this.containedReference(modelElement, refList)) continue;
                refList.add(modelElement);
            }
        }
        Iterator i = modelElement.eContents().iterator();
        while (i.hasNext()) {
            this.refreshVariables((EObject)i.next());
        }
    }

    private boolean variableExists(String ref) {
        for (ModelVariable variable : this.variables) {
            if (!this.variableEquals(variable.getName(), ref)) continue;
            return true;
        }
        return false;
    }

    private ModelVariable getVariable(String ref) {
        for (ModelVariable variable : this.variables) {
            if (!this.variableEquals(variable.getName(), ref)) continue;
            return variable;
        }
        return null;
    }

    private boolean containedReference(EObject modelElement, List<EObject> refList) {
        for (EObject o : refList) {
            if (!o.toString().equals(modelElement.toString())) continue;
            return true;
        }
        return false;
    }

    public List<ModelVariable> getVariables() {
        return this.variables;
    }

    public List<EObject> getReferences(ModelVariable modelVariable) {
        String typelessName = "${" + modelVariable.getStrippedName().split(":")[0] + "}";
        List<EObject> references = this.variableReferences.get(modelVariable.getName());
        if (references == null || references.isEmpty()) {
            references = this.variableReferences.get(typelessName);
        }
        return references;
    }

    public boolean hasVariable(IModelElement modelElement) {
        Map<EObject, String> o = this.elementReferences.get(String.valueOf(modelElement.getElementOid()));
        return o != null;
    }

    public void replaceVariablesWithDefaultValue(IModelElement modelElement) {
        Map<EObject, String> elementMap = this.elementReferences.get(String.valueOf(modelElement.getElementOid()));
        this.replaceAllVariablesWithDefaultValues(elementMap, modelElement);
    }

    private void replaceAllVariablesWithDefaultValues(Map<EObject, String> elementMap, EObject modelElement) {
        if (!(modelElement instanceof IModelElement)) {
            for (Map.Entry entry : elementMap.entrySet()) {
                ModelVariable modelVariable = this.getModelVariableByName((String)entry.getValue());
                if (!(modelElement instanceof AttributeType) || !(entry.getKey() instanceof AttributeType)) continue;
                AttributeType modelAttribute = (AttributeType)modelElement;
                AttributeType refAttribute = (AttributeType)entry.getKey();
                if (!modelAttribute.getName().equals(refAttribute.getName())) continue;
                this.replaceVariable(modelAttribute, modelVariable, modelVariable.getDefaultValue());
            }
        }
        Iterator i = modelElement.eContents().iterator();
        while (i.hasNext()) {
            this.replaceAllVariablesWithDefaultValues(elementMap, (EObject)i.next());
        }
    }

    public ModelVariable getModelVariableByName(String value) {
        for (ModelVariable modelVariable : this.variables) {
            if (!modelVariable.getName().equals(value)) continue;
            return modelVariable;
        }
        return null;
    }

    public String replaceAllVariablesByDefaultValue(String aString) {
        String result = aString;
        if (aString == null || StringUtils.isEmpty((String)result)) {
            return result;
        }
        for (ModelVariable modelVariable : this.variables) {
            result = this.replace(modelVariable, modelVariable.getDefaultValue(), result);
        }
        result = result.replaceAll("\\\\\\$\\{", "\\$\\{");
        return result;
    }

    public void replaceVariable(Object o, ModelVariable modelVariable, String newValue) {
        if (o instanceof AttributeType) {
            AttributeType attribute = (AttributeType)o;
            String value = attribute.getValue();
            value = this.replace(modelVariable, newValue, value);
            attribute.setValue(value);
            if (attribute.getName().equalsIgnoreCase("ipp:criticalityFormula")) {
                this.setCriticalityFormulaChanged(true);
            }
        } else if (o instanceof XmlTextNode) {
            XmlTextNode textNode = (XmlTextNode)o;
            String value = ModelUtils.getCDataString(textNode.getMixed());
            value = this.replace(modelVariable, newValue, value);
            ModelUtils.setCDataString(textNode.getMixed(), value);
        } else if (o instanceof DescriptionType) {
            DescriptionType description = (DescriptionType)o;
            String value = ModelUtils.getCDataString(description.getMixed());
            value = this.replace(modelVariable, newValue, value);
            ModelUtils.setCDataString(description.getMixed(), value);
        } else if (o instanceof IIdentifiableElement) {
            IIdentifiableElement identifiable = (IIdentifiableElement)o;
            String value = identifiable.getId();
            value = this.replace(modelVariable, newValue, value);
            identifiable.setId(value);
            value = identifiable.getName();
            value = this.replace(modelVariable, newValue, value);
            identifiable.setName(value);
        }
    }

    public void replaceVariable(ModelVariable modelVariable, String newValue) {
        List<EObject> refList = this.getReferences(modelVariable);
        if (refList != null) {
            for (EObject o : refList) {
                this.replaceVariable(o, modelVariable, newValue);
            }
        }
        if (!newValue.equals(modelVariable.getName())) {
            this.variableReferences.put(newValue, refList);
            this.variableReferences.remove(modelVariable.getName());
        }
    }

    public String replace(ModelVariable modelVariable, String newValue, String value) {
        String literal = modelVariable.getName();
        value = this.replaceLiteral(literal, value, newValue);
        if (modelVariable.getStrippedName().endsWith(":String")) {
            String typelessName = modelVariable.getStrippedName().split(":")[0];
            literal = "${" + typelessName + "}";
            value = this.replaceLiteral(literal, value, newValue);
        }
        return value;
    }

    private String replaceLiteral(String literal, String value, String newValue) {
        String tobeReplaced = "";
        String replacement = "";
        if (!newValue.startsWith("${")) {
            tobeReplaced = literal.substring(2, literal.length() - 1);
            replacement = newValue;
            if (replacement.indexOf("$") > -1) {
                replacement = replacement.replace("$", "\\$");
            }
            ArrayList<String> list1 = new ArrayList<String>();
            while (value.indexOf("${" + tobeReplaced + "}") > -1) {
                int idx = value.indexOf("${" + tobeReplaced + "}");
                if (idx == 0 || idx > 0 && value.charAt(idx - 1) != '\\') {
                    value = value.replaceFirst("(\\$\\{" + tobeReplaced + "\\})", replacement);
                    continue;
                }
                list1.add("\\$\\{" + tobeReplaced + "\\}");
                value = value.replaceFirst("(\\$\\{" + tobeReplaced + "\\})", "*0*0*0*0*");
            }
            for (String string : list1) {
                value = value.replaceFirst("(\\*0\\*0\\*0\\*0\\*)", string);
            }
        } else {
            tobeReplaced = literal.substring(2, literal.length() - 1);
            replacement = newValue.substring(2, newValue.length() - 1);
            if (replacement.indexOf("$") > -1) {
                replacement = replacement.replace("$", "\\$");
            }
            tobeReplaced = RegEx.REUtil.quoteMeta((String)tobeReplaced);
            value = value.replaceAll("(\\$\\{" + tobeReplaced + "\\})", "\\$\\{" + replacement + "\\}");
        }
        return value;
    }

    public boolean isSecurityContext(String name) {
        String type;
        if (name.startsWith("${")) {
            name = name.substring(2, name.length() - 1);
        }
        return (type = VariableContextHelper.getType(name)).equals(ConfigurationVariableScope.Password.name());
    }

    public boolean isValidType(String name) {
        ConfigurationVariableScope[] scopes;
        if (name.startsWith("${")) {
            name = name.substring(2, name.length() - 1);
        }
        String type = VariableContextHelper.getType(name);
        ConfigurationVariableScope[] configurationVariableScopeArray = scopes = ConfigurationVariableScope.values();
        int n = scopes.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigurationVariableScope scope = configurationVariableScopeArray[n2];
            if (scope.name().equals(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isValidName(String name) {
        if (name == null) {
            return false;
        }
        if (name.startsWith("${")) {
            name = name.substring(2, name.length() - 1);
        }
        if (name == "" || StringUtils.isEmpty((String)name)) {
            return false;
        }
        String[] parts = name.split(":");
        if (parts.length > 2) {
            return false;
        }
        return StringUtils.isValidIdentifier((String)(name = VariableContextHelper.getName(name)));
    }

    public boolean isCriticalityFormulaChanged() {
        return this.criticalityFormulaChanged;
    }

    public void setCriticalityFormulaChanged(boolean criticalityFormulaChanged) {
        this.criticalityFormulaChanged = criticalityFormulaChanged;
    }

    private boolean variableEquals(String left, String right) {
        String rightName;
        String rightType;
        String leftType;
        if (left.startsWith("${")) {
            left = left.substring(2, left.length() - 1);
        }
        if (right.startsWith("${")) {
            right = right.substring(2, right.length() - 1);
        }
        if (!(leftType = VariableContextHelper.getType(left)).equals(rightType = VariableContextHelper.getType(right))) {
            return false;
        }
        String leftName = VariableContextHelper.getName(left);
        return leftName.equalsIgnoreCase(rightName = VariableContextHelper.getName(right));
    }

    private class ConfigurationVariableIndexComparator
    implements Comparator<AttributeType> {
        private ConfigurationVariableIndexComparator() {
        }

        @Override
        public int compare(AttributeType o1, AttributeType o2) {
            Integer index1 = VariableContext.getIndex(o1.getName());
            Integer index2 = VariableContext.getIndex(o2.getName());
            return index1.compareTo(index2);
        }
    }
}

