/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.OrientationType;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.IImageManager;
import org.eclipse.stardust.modeling.common.ui.jface.ImageManager;
import org.eclipse.stardust.modeling.core.CarnotAdapterFactory;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class DiagramPlugin
extends AbstractUIPlugin {
    private static DiagramPlugin plugin;
    private IImageManager imageManager;
    private Map externalImageManagers = new HashMap();
    public static final String CARNOT_WORKFLOW_MODEL_EDITOR_ID = "org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor";
    public static final String CONTEXT_MENU_ACTION_EXTENSION_POINT = "org.eclipse.stardust.modeling.core.contextMenuAction";
    public static final String EP_ATTR_ID = "id";
    public static final String EP_ATTR_ACTION_CLASS = "actionClass";
    public static final String EP_ATTR_TARGET_ELEMENT_TYPE = "targetElementType";
    public static final String EP_ATTR_TARGET_SYMBOL_TYPE = "targetSymbolType";
    public static final String EP_ATTR_TARGET_EOBJECT_TYPE = "targetEObjectType";
    public static final String EP_ATTR_GROUP = "group";

    public DiagramPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        CarnotAdapterFactory.registerAdapterFactories();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        CarnotAdapterFactory.unregisterAdapterFactories();
        SpiExtensionRegistry.stop();
        plugin = null;
    }

    public static DiagramPlugin getDefault() {
        return plugin;
    }

    public IImageManager getImageManager() {
        if (this.imageManager == null) {
            this.imageManager = new SpiAwareImageManager();
        }
        return this.imageManager;
    }

    public IImageManager getImageManager(String bundleId) {
        IImageManager result = null;
        if (this.getBundle().getSymbolicName().equals(bundleId)) {
            result = this.getImageManager();
        } else {
            result = (IImageManager)this.externalImageManagers.get(bundleId);
            if (result == null) {
                result = new ImageManager(bundleId);
                this.externalImageManagers.put(bundleId, result);
            }
        }
        return result;
    }

    public void setImageManager(IImageManager imageManager) {
        this.imageManager = imageManager;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return DiagramPlugin.getDefault().getImageManager().getImageDescriptor(path);
    }

    public static ImageDescriptor getImageDescriptor(IConfigurationElement element) {
        return DiagramPlugin.getDefault().getImageManager(element.getNamespace()).getImageDescriptor(element.getAttribute("icon"));
    }

    public static Image getImage(String path) {
        Image image = null;
        if (!StringUtils.isEmpty((String)path) && path.startsWith("{")) {
            Iterator qualifiedPath = StringUtils.split((String)path, (String)"}");
            String bundleId = null;
            String imagePath = null;
            if (qualifiedPath.hasNext()) {
                bundleId = ((String)qualifiedPath.next()).substring(1);
            }
            if (qualifiedPath.hasNext()) {
                imagePath = (String)qualifiedPath.next();
            }
            if (!StringUtils.isEmpty(bundleId) && !StringUtils.isEmpty((String)imagePath)) {
                image = DiagramPlugin.getDefault().getImageManager(bundleId).getImage(imagePath);
            }
        }
        return image != null ? image : DiagramPlugin.getDefault().getImageManager().getImage(path);
    }

    public static Image getImage(String path, int style) {
        Image image = null;
        if (!StringUtils.isEmpty((String)path) && path.startsWith("{")) {
            Iterator qualifiedPath = StringUtils.split((String)path, (String)"}");
            String bundleId = null;
            String imagePath = null;
            if (qualifiedPath.hasNext()) {
                bundleId = ((String)qualifiedPath.next()).substring(1);
            }
            if (qualifiedPath.hasNext()) {
                imagePath = (String)qualifiedPath.next();
            }
            if (!StringUtils.isEmpty(bundleId) && !StringUtils.isEmpty((String)imagePath)) {
                image = DiagramPlugin.getDefault().getImageManager(bundleId).getIcon(imagePath, style);
            }
        }
        return image != null ? image : DiagramPlugin.getDefault().getImageManager().getImage(path);
    }

    public static void warn(String message) {
        plugin.getLog().log((IStatus)new Status(2, "org.eclipse.stardust.modeling.core", 0, message, null));
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static boolean isVerticalModelling(DiagramType diagram) {
        OrientationType direction = diagram.getOrientation();
        return direction == null || OrientationType.VERTICAL_LITERAL.equals((Object)direction);
    }

    public static boolean isVerticalModelling(IGraphicalObject symbol) {
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)symbol);
        return DiagramPlugin.isVerticalModelling(diagram);
    }

    public static String getCurrentPerspectiveId() {
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench.getActiveWorkbenchWindow() != null && workbench.getActiveWorkbenchWindow().getActivePage() != null) {
                IPerspectiveDescriptor perspective = workbench.getActiveWorkbenchWindow().getActivePage().getPerspective();
                return perspective.getId();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static String getViewAsPerspectiveId(WorkflowModelEditor editor) {
        return DiagramPlugin.getCurrentPerspectiveId();
    }

    private class SpiAwareImageManager
    extends ImageManager {
        public SpiAwareImageManager() {
            super((AbstractUIPlugin)DiagramPlugin.this);
        }

        public ImageDescriptor getImageDescriptor(String path) {
            ImageDescriptor result = null;
            if (!StringUtils.isEmpty((String)path) && path.startsWith("{")) {
                Iterator qualifiedPath = StringUtils.split((String)path, (String)"}");
                String bundleId = null;
                String imagePath = null;
                if (qualifiedPath.hasNext()) {
                    bundleId = ((String)qualifiedPath.next()).substring(1);
                }
                if (qualifiedPath.hasNext()) {
                    imagePath = (String)qualifiedPath.next();
                }
                if (!StringUtils.isEmpty(bundleId) && !StringUtils.isEmpty((String)imagePath)) {
                    result = DiagramPlugin.getDefault().getImageManager(bundleId).getImageDescriptor(imagePath);
                }
            }
            if (result == null) {
                result = super.getImageDescriptor(path);
            }
            return result;
        }
    }
}

