/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.createUtils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelOutlinePage;
import org.eclipse.stardust.modeling.core.editors.parts.tree.AbstractEObjectTreeEditPart;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CreationUtils {
    public static void showInDiagramAndEdit(INodeSymbol symbol) {
        IIdentifiableModelElement model;
        if (symbol instanceof IModelElementNodeSymbol && (model = ((IModelElementNodeSymbol)symbol).getModelElement()) != null) {
            WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            CreationUtils.refreshTreeItem((EObject)model);
            String focusMode = PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnature.focusMode");
            if (focusMode.equals("focusModeElement")) {
                return;
            }
            if (focusMode.equals("focusModeDialog")) {
                editor.selectSymbol(symbol);
                ActionRegistry registry = editor.getActionRegistry();
                IAction action = registry.getAction((Object)ActionFactory.PROPERTIES.getId());
                if (action != null) {
                    action.run();
                }
            } else if (focusMode.equals("focusModeEditor")) {
                CreationUtils.showInOutlineAndEdit((EObject)model);
            }
            return;
        }
    }

    public static void showInOutlineAndEdit(EObject element) {
        WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        WorkflowModelOutlinePage outlinePage = (WorkflowModelOutlinePage)editor.getOutlinePage();
        String focusMode = PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnature.focusMode");
        if (focusMode.equals("focusModeElement")) {
            editor.selectInOutline(element);
            return;
        }
        if (focusMode.equals("focusModeDialog")) {
            editor.selectInOutline(element);
            ActionRegistry registry = outlinePage.getActionRegistry();
            IAction action = registry.getAction((Object)ActionFactory.PROPERTIES.getId());
            if (action != null) {
                action.run();
            }
        } else if (focusMode.equals("focusModeEditor")) {
            editor.selectInOutline(element);
            AbstractEObjectTreeEditPart treeEditPart = (AbstractEObjectTreeEditPart)outlinePage.getEditPart(element);
            treeEditPart.performRequest((Request)new DirectEditRequest());
        }
    }

    public static void refreshTreeItem(EObject element) {
        Widget widget;
        AbstractEObjectTreeEditPart treeEditPart;
        WorkflowModelEditor editor = GenericUtils.getWorkflowModelEditor(ModelUtils.findContainingModel((EObject)element));
        if (editor == null) {
            return;
        }
        WorkflowModelOutlinePage outlinePage = (WorkflowModelOutlinePage)editor.getOutlinePage();
        if (outlinePage != null && (treeEditPart = (AbstractEObjectTreeEditPart)outlinePage.getEditPart(element)) != null && (widget = treeEditPart.getWidget()) != null && !widget.isDisposed()) {
            treeEditPart.refresh();
        }
    }

    public static void refreshTreeItemVisuals(EObject element) {
        Widget widget;
        AbstractEObjectTreeEditPart treeEditPart;
        WorkflowModelEditor editor = GenericUtils.getWorkflowModelEditor(ModelUtils.findContainingModel((EObject)element));
        if (editor == null) {
            return;
        }
        WorkflowModelOutlinePage outlinePage = (WorkflowModelOutlinePage)editor.getOutlinePage();
        if (outlinePage != null && (treeEditPart = (AbstractEObjectTreeEditPart)outlinePage.getEditPart(element)) != null && (widget = treeEditPart.getWidget()) != null && !widget.isDisposed()) {
            treeEditPart.refreshTextAndIcon();
        }
    }
}

