/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.config.CurrentVersion;
import org.eclipse.stardust.common.config.Version;
import org.eclipse.stardust.engine.api.model.Modules;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.EndEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IntermediateEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.PublicInterfaceSymbol;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.modeling.common.ui.BpmUiActivator;
import org.eclipse.stardust.modeling.common.ui.IWorkflowModelEditor;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.decoration.DecorationUtils;
import org.eclipse.stardust.modeling.core.decoration.IDecorationProvider;
import org.eclipse.stardust.modeling.core.decoration.IDecorationTarget;
import org.eclipse.stardust.modeling.core.editors.AbstractGraphicalEditorPage;
import org.eclipse.stardust.modeling.core.editors.AbstractMultiPageGraphicalEditor;
import org.eclipse.stardust.modeling.core.editors.AbstractMultiPageGraphicalEditorOutlinePage;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.EditPartRegistry;
import org.eclipse.stardust.modeling.core.editors.IDiagramChangeListener;
import org.eclipse.stardust.modeling.core.editors.LicensePage;
import org.eclipse.stardust.modeling.core.editors.ModelResourceIssueSynchronizer;
import org.eclipse.stardust.modeling.core.editors.UpgradePage;
import org.eclipse.stardust.modeling.core.editors.ValidationIssueManager;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditorPaletteFactory;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelOutlinePage;
import org.eclipse.stardust.modeling.core.editors.parts.IconFactory;
import org.eclipse.stardust.modeling.core.editors.parts.NotificationAdaptee;
import org.eclipse.stardust.modeling.core.editors.parts.NotificationAdapter;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.AddExternalReferenceAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CloseDiagramAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ConnectAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ConvertGatewayAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CopyAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CreateActivityAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CreateActivityGraphAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CreateApplicationAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CreateConditionalPerformerAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CreateDataAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CreateDiagramAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CreateInteractiveApplicationAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CreateLinkTypeAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CreateOrganizationAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CreateOrganizationHierarchyAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CreateProcessDefinitionAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CreateRepositoryConnectionAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CreateRoleAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CreateSubprocessAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.CreateTriggerAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.DeleteExternalReferenceAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.DeleteSymbolAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.DeployModelAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ElementSelectionAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ExportDiagramAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.FixInvalidIdsAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ForwardDeleteAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ImportConnectionObjectAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ImportModelElementsAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.OpenDiagramAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.OptimizeDiagramAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.PasteAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ReferencesSearchAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.RefreshConnectionObjectAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ReloadConnectionsAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ReloadSchemaAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ResetSubprocessAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.SearchAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.SearchConnectionAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.SetDefaultParticipantAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ShowPropertiesAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.UpdateDiagramAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.UpgradeDataAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.UpgradeModelAndDiagramAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ValidateModelAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteSymbolCommandFactory;
import org.eclipse.stardust.modeling.core.jobs.ModelValidationJob;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.stardust.modeling.repository.common.ExtendedModelManager;
import org.eclipse.stardust.modeling.validation.ValidationMarkerService;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class WorkflowModelEditor
extends AbstractMultiPageGraphicalEditor
implements IWorkflowModelEditor,
EditPartRegistry,
IGotoMarker,
IDecorationTarget {
    private WorkflowModelManager modelManager;
    private ModelType cwmModel;
    private List<DiagramType> diagrams = new ArrayList<DiagramType>();
    private Map<NotificationAdaptee, NotificationAdapter> adapters = CollectionUtils.newMap();
    private Set<IDiagramChangeListener> diagramChangeListeners = CollectionUtils.newSet();
    private final ValidationIssueManager validationIssueManager = new ValidationIssueManager();
    private final ModelResourceIssueSynchronizer issueSynchronizer = new ModelResourceIssueSynchronizer(this.validationIssueManager);
    private final EditorChangeTracker editorChangeTracker = new EditorChangeTracker();
    private WorkflowModelOutlinePage outlinePage;
    private VariableContextHelper variableContextHelper = VariableContextHelper.getInstance();
    private boolean changed;
    private boolean initialized;
    private ModelValidationJob validationJob;
    private Map<String, IDecorationProvider> decorations = CollectionUtils.newMap();
    private IconFactory iconFactory;
    protected Boolean upgradeChecked;

    public EditorChangeTracker getEditorChangeTracker() {
        return this.editorChangeTracker;
    }

    @Override
    public AbstractMultiPageGraphicalEditorOutlinePage getOutlinePage() {
        return super.getOutlinePage();
    }

    public WorkflowModelEditor() {
        PlatformUI.getPreferenceStore().setDefault("org.eclipse.stardust.modeling.common.projectnature.autoValidation", true);
        this.addPropertyListener(new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 258) {
                    WorkflowModelEditor.this.setPartName(WorkflowModelEditor.this.getEditorInput().getName());
                }
            }
        });
        this.iconFactory = new IconFactory(this);
    }

    public WorkflowModelManager getModelManager() {
        return this.modelManager;
    }

    @Override
    public void dispose() {
        this.variableContextHelper.removeContext(this.getWorkflowModel());
        super.dispose();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public IconFactory getIconFactory() {
        return this.iconFactory;
    }

    @Override
    public ActionRegistry getActionRegistry() {
        return super.getActionRegistry();
    }

    public void addDiagramChangeListener(IDiagramChangeListener listener) {
        if (listener != null && !this.diagramChangeListeners.contains(listener)) {
            this.diagramChangeListeners.add(listener);
        }
    }

    public void removeDiagramChangeListener(IDiagramChangeListener listener) {
        if (listener != null && this.diagramChangeListeners.contains(listener)) {
            this.diagramChangeListeners.remove(listener);
        }
    }

    public void showDiagramPage(DiagramType diagram) throws PartInitException {
        int pageId = this.diagrams.indexOf(diagram);
        if (pageId < 0) {
            pageId = this.createDiagramPage(diagram);
        }
        this.setActivePage(pageId);
        this.checkShowLicensePage();
    }

    public List<DiagramType> getOpenedDiagrams() {
        return Collections.unmodifiableList(this.diagrams);
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.addEditPartAction(new CopyAction(this));
        this.addEditPartAction(new PasteAction(this));
        this.addEditPartAction(new SetDefaultParticipantAction(this));
        this.addEditPartAction(new ConnectAction(this));
        this.addAction((IAction)new ReloadConnectionsAction(this));
        this.addEditPartAction(new OptimizeDiagramAction(this));
        this.addEditPartAction(new UpdateDiagramAction(this));
        this.addEditPartAction(new UpgradeModelAndDiagramAction(this));
        this.addEditPartAction(new UpgradeDataAction(this));
        this.addEditPartAction(new OpenDiagramAction(this, 0));
        this.addEditPartAction(new OpenDiagramAction(this, 1));
        this.addEditPartAction(new OpenDiagramAction(this, 2));
        this.addEditPartAction(new CloseDiagramAction(this));
        this.addEditPartAction(new ReferencesSearchAction((IWorkbenchPart)this));
        this.addEditPartAction(new SearchAction((IWorkbenchPart)this));
        ShowPropertiesAction propDlgAction = new ShowPropertiesAction(this, this.getSite().getSelectionProvider());
        propDlgAction.setId(ActionFactory.PROPERTIES.getId());
        this.addAction((IAction)propDlgAction);
        this.addEditPartAction(new CreateOrganizationHierarchyAction((IWorkbenchPart)this));
        this.addEditPartAction(new CreateActivityGraphAction(this));
        DeleteSymbolAction deleteSymbolAction = new DeleteSymbolAction((IWorkbenchPart)this);
        IAction deleteAction = this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId());
        deleteSymbolAction.setImageDescriptor(deleteAction.getImageDescriptor());
        deleteSymbolAction.setDisabledImageDescriptor(deleteAction.getDisabledImageDescriptor());
        this.addEditPartAction(deleteSymbolAction);
        this.addEditPartAction(new ForwardDeleteAction((IWorkbenchPart)this, this.getActionRegistry()));
        this.addEditPartAction(new DeployModelAction(this));
        this.addEditPartAction(new ImportModelElementsAction(this));
        this.addEditPartAction(new CreateActivityAction(null, "org.eclipse.stardust.modeling.core.createGenericActivity", this));
        this.addEditPartAction(new CreateActivityAction(ActivityImplementationType.ROUTE_LITERAL, "org.eclipse.stardust.modeling.core.createRouteActivity", this));
        this.addEditPartAction(new CreateActivityAction(ActivityImplementationType.MANUAL_LITERAL, "org.eclipse.stardust.modeling.core.createManualActivity", this));
        this.addEditPartAction(new CreateActivityAction(ActivityImplementationType.APPLICATION_LITERAL, "org.eclipse.stardust.modeling.core.createApplicationActivity", this));
        this.addEditPartAction(new CreateActivityAction(ActivityImplementationType.SUBPROCESS_LITERAL, "org.eclipse.stardust.modeling.core.createSubprocessActivity", this));
        this.addEditPartAction(new CreateProcessDefinitionAction((IWorkbenchPart)this));
        this.addEditPartAction(new ResetSubprocessAction(this));
        this.addEditPartAction(new CreateSubprocessAction(this));
        SpiExtensionRegistry registry = SpiExtensionRegistry.instance();
        this.addEditPartAction(new CreateApplicationAction(null, this));
        Map applicationTypesExtensions = registry.getExtensions("applicationTypes");
        for (IConfigurationElement config : applicationTypesExtensions.values()) {
            this.addEditPartAction(new CreateApplicationAction(config, this));
        }
        Map contextTypesExtensions = registry.getExtensions("contextTypes");
        for (IConfigurationElement config : contextTypesExtensions.values()) {
            if (ActivityUtil.isImplicitContext((String)config.getAttribute("id"))) continue;
            this.addEditPartAction(new CreateInteractiveApplicationAction(config, this));
        }
        this.addEditPartAction(new ValidateModelAction(this));
        this.addEditPartAction(new CreateLinkTypeAction((IWorkbenchPart)this));
        this.addEditPartAction(new CreateDiagramAction((IWorkbenchPart)this));
        this.addEditPartAction(new ConvertGatewayAction((IWorkbenchPart)this));
        Map dataExtensions = registry.getExtensions("dataTypes");
        for (IConfigurationElement config : dataExtensions.values()) {
            this.addEditPartAction(new CreateDataAction(config, this));
        }
        this.addEditPartAction(new CreateDataAction(null, this));
        Map connectionExtensions = registry.getExtensions("org.eclipse.stardust.modeling.repository.common", "connections");
        for (IConfigurationElement config : connectionExtensions.values()) {
            this.addEditPartAction(new CreateRepositoryConnectionAction(config, this));
        }
        Map searchConnectionExtensions = registry.getExtensions("org.eclipse.stardust.modeling.repository.common", "connectionsearch");
        for (IConfigurationElement config : searchConnectionExtensions.values()) {
            this.addEditPartAction(new SearchConnectionAction(config, this));
        }
        this.addEditPartAction(new ElementSelectionAction((IWorkbenchPart)this));
        this.addEditPartAction(new ImportConnectionObjectAction(this));
        this.addEditPartAction(new RefreshConnectionObjectAction(this));
        this.addEditPartAction(new AddExternalReferenceAction(this));
        this.addEditPartAction(new DeleteExternalReferenceAction(this));
        Map triggerExtensions = registry.getExtensions("triggerTypes");
        for (IConfigurationElement config : triggerExtensions.values()) {
            this.addEditPartAction(new CreateTriggerAction(config, this));
        }
        this.addEditPartAction(new CreateConditionalPerformerAction((IWorkbenchPart)this));
        this.addEditPartAction(new CreateRoleAction((IWorkbenchPart)this));
        this.addEditPartAction(new CreateOrganizationAction((IWorkbenchPart)this));
        this.addEditPartAction(new ExportDiagramAction((IWorkbenchPart)this));
        this.addEditPartAction(new ReloadSchemaAction((IWorkbenchPart)this));
    }

    @Override
    protected boolean canDelete(ISelection selection) {
        return false;
    }

    protected void createPages() {
        this.initializeExtensions();
        try {
            if (this.initialized && this.getWorkflowModel() != null) {
                if (this.checkUpgradeModel()) {
                    EList processDiagrams;
                    this.removeUpgradePage();
                    Iterator i = this.getWorkflowModel().getDiagram().iterator();
                    while (i.hasNext()) {
                        this.showDiagramPage((DiagramType)i.next());
                    }
                    if (!this.getWorkflowModel().getProcessDefinition().isEmpty() && !(processDiagrams = ((ProcessDefinitionType)this.getWorkflowModel().getProcessDefinition().get(0)).getDiagram()).isEmpty()) {
                        this.showDiagramPage((DiagramType)processDiagrams.get(0));
                    }
                } else {
                    this.showUpgradePage();
                }
            }
            this.checkShowLicensePage();
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Diagram_Messages.ERR_OpenError, (String)Diagram_Messages.ERR_duringOpeningTheEditor, (IStatus)e.getStatus());
        }
    }

    private void removeUpgradePage() {
        int i = this.getPageCount() - 1;
        while (i >= 0) {
            IEditorPart page = this.getEditor(i);
            if (page instanceof UpgradePage) {
                this.removePage(i);
            }
            --i;
        }
    }

    private void showUpgradePage() {
        int i = 0;
        while (i < this.getPageCount()) {
            this.removePage(i);
            ++i;
        }
        UpgradePage page = new UpgradePage(this);
        try {
            int pageId = this.addPage((IEditorPart)page, this.getEditorInput());
            this.setPageText(pageId, page.getPageName());
            this.setActivePage(pageId);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    boolean checkUpgradeModel() {
        if (this.upgradeChecked == null) {
            this.upgradeChecked = Boolean.TRUE;
            Command upgradeModelAndDiagramCmd = new UpgradeModelAndDiagramAction(this).createUpgradeModelAndDiagramCmd();
            if (upgradeModelAndDiagramCmd.canExecute()) {
                String message = null;
                Version modelVersion = null;
                Version carnotVersion = CurrentVersion.getVersion();
                try {
                    modelVersion = new Version(this.cwmModel.getCarnotVersion());
                    if (modelVersion.compareTo(carnotVersion, true) < 0) {
                        message = MessageFormat.format(Diagram_Messages.MSG_UpgradeModel, this.cwmModel.getName(), modelVersion.toString(), carnotVersion.toString());
                    } else {
                        if (modelVersion.compareTo(carnotVersion, true) > 0) {
                            message = MessageFormat.format(String.valueOf(Diagram_Messages.MSG_DIA_MODEL_NULL_WAS_CREATED_USING_A_NEWER_VERSION_OF_THE_MODELER_ONE) + "\n" + Diagram_Messages.MSG_DIA_CHANGING_MODEL_IS_NOT_RECOMMENDED, this.cwmModel.getName(), modelVersion.toString());
                            MessageDialog dialog = new MessageDialog(this.getSite().getShell(), Diagram_Messages.LB_UpgradeModel, null, message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                            dialog.open();
                            this.upgradeChecked = Boolean.TRUE;
                            return this.upgradeChecked;
                        }
                        message = MessageFormat.format(String.valueOf(Diagram_Messages.MSG_DIA_DEPRECATED_MD_FORMAT_DETECTED) + "\n" + Diagram_Messages.MSG_DIA_DO_YOU_WANT_TO_UPDATE_MD_TO_CURRENT_SPECS_NULL, modelVersion.toString());
                    }
                }
                catch (Exception exception) {
                    message = MessageFormat.format(String.valueOf(Diagram_Messages.MSG_DIA_UNKNOWN_VERSION_FOR_MD_NULL) + "\n" + Diagram_Messages.MSG_DO_YOU_WANT_TO_UPDATE_MD_TO_VERSION_ONE, this.cwmModel.getName(), carnotVersion.toShortString());
                }
                MessageDialog dialog = new MessageDialog(this.getSite().getShell(), Diagram_Messages.LB_UpgradeModel, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
                switch (dialog.open()) {
                    case 0: {
                        this.getEditDomain().getCommandStack().execute(upgradeModelAndDiagramCmd);
                        break;
                    }
                    case 1: {
                        this.upgradeChecked = modelVersion != null && modelVersion.getMajor() == carnotVersion.getMajor();
                    }
                }
            }
            FixInvalidIdsAction.run(this);
        }
        return this.upgradeChecked;
    }

    private int createDiagramPage(DiagramType diagram) throws PartInitException {
        DiagramEditorPage page = new DiagramEditorPage(this, diagram);
        int pageId = this.addPage((IEditorPart)page, this.getEditorInput());
        this.setPageText(pageId, page.getPageName());
        this.diagrams.add(diagram);
        if (diagram.eContainer() instanceof ProcessDefinitionType) {
            ProcessDefinitionType process = (ProcessDefinitionType)diagram.eContainer();
            this.addRemoveAdapter(diagram, (EObject)process);
        }
        this.addRemoveAdapter(diagram, (EObject)diagram);
        for (IDecorationProvider decoration : this.decorations.values()) {
            DecorationUtils.applyDecoration(decoration, page.getGraphicalViewer().getRootEditPart().getChildren());
        }
        this.fireDiagramPageOpened(page);
        return pageId;
    }

    private void addRemoveAdapter(final Object diagram, final EObject eObject) {
        final EObject container = eObject.eContainer();
        NotificationAdaptee adaptee = new NotificationAdaptee(){

            @Override
            public Object getModel() {
                return eObject;
            }

            @Override
            public void handleNotification(Notification notification) {
                if (notification.getEventType() == 4 && notification.getOldValue() == eObject) {
                    container.eAdapters().remove(WorkflowModelEditor.this.adapters.get(this));
                    WorkflowModelEditor.this.adapters.remove(this);
                    int i = 0;
                    while (i < WorkflowModelEditor.this.getOpenedDiagrams().size()) {
                        if (WorkflowModelEditor.this.diagrams.get(i) == diagram) {
                            WorkflowModelEditor.this.removePage(i);
                            WorkflowModelEditor.this.diagrams.remove(i);
                            break;
                        }
                        ++i;
                    }
                }
            }
        };
        NotificationAdapter adapter = new NotificationAdapter(adaptee);
        this.adapters.put(adaptee, adapter);
        container.eAdapters().add((Object)adapter);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            IFile file = null;
            if (this.getEditorInput() instanceof IFileEditorInput) {
                file = ((IFileEditorInput)this.getEditorInput()).getFile();
            }
            if (file != null && file.exists() || MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)Diagram_Messages.MSG_CreateFile, (String)(String.valueOf(Diagram_Messages.MSG_Confirm_P1_TheFile) + file.getName() + Diagram_Messages.MSG_Confirm_P2_doesntExist))) {
                this.save(file, monitor);
                this.getSharedCommandStack().markSaveLocation();
            }
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Diagram_Messages.ERR_DuringSave, (String)Diagram_Messages.ERR_WorkflowModelCouldNotBeSaved, (IStatus)e.getStatus());
        }
    }

    public void doSaveAs() {
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getShell());
        dialog.setOriginalFile(((IFileEditorInput)this.getEditorInput()).getFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return;
        }
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getSite().getShell());
        IProgressMonitor progressMonitor = progressMonitorDialog.getProgressMonitor();
        try {
            progressMonitorDialog.open();
            try {
                IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                this.save(newFile, progressMonitor);
                this.getSharedCommandStack().markSaveLocation();
                this.setInput((IEditorInput)new FileEditorInput(newFile));
                this.firePropertyChange(258);
            }
            finally {
                progressMonitorDialog.close();
            }
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)Diagram_Messages.ERR_DuringSave, (String)Diagram_Messages.ERR_CurrentModelCouldNotBeSaved, (IStatus)e.getStatus());
        }
    }

    @Override
    public Object getAdapter(Class type) {
        if (type == IContentOutlinePage.class) {
            return this.getOutlinePage();
        }
        if (type == ConnectionManager.class) {
            return this.getConnectionManager();
        }
        if (type == WorkflowModelManager.class) {
            return this.modelManager;
        }
        return super.getAdapter(type);
    }

    public DiagramType getActiveDiagram() {
        int idx = this.getActivePage();
        IEditorPart editPart = this.getEditor(idx);
        if (editPart instanceof DiagramEditorPage) {
            return ((DiagramEditorPage)editPart).getDiagram();
        }
        return null;
    }

    @Override
    public Object getModel() {
        return this.getWorkflowModel();
    }

    @Override
    public ModelType getWorkflowModel() {
        return this.cwmModel;
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return WorkflowModelEditorPaletteFactory.createPalettePreferences();
    }

    @Override
    protected WorkflowModelOutlinePage createOutlinePage() {
        this.outlinePage = new WorkflowModelOutlinePage(this);
        this.validationIssueManager.addValidationEventListener(this.outlinePage);
        return this.outlinePage;
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.currentPageChanged();
    }

    protected void setActivePage(int pageIndex) {
        if (this.getPageCount() > 0 && pageIndex >= 0 && pageIndex < this.getPageCount()) {
            super.setActivePage(pageIndex);
        }
        this.currentPageChanged();
    }

    protected void currentPageChanged() {
        IEditorPart currentPage;
        if (this.outlinePage != null) {
            this.outlinePage.editorPageChanged();
            if (this.getEditorSite() != null && this.getEditorSite().getSelectionProvider() != null && this.getSite() != null && this.getSite().getSelectionProvider() != null) {
                try {
                    this.getEditorSite().getSelectionProvider().setSelection(this.getSite().getSelectionProvider().getSelection());
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        if ((currentPage = this.getCurrentPage()) != null) {
            this.getDelegatingZoomManager().setCurrentZoomManager(this.getZoomManager(currentPage instanceof AbstractGraphicalEditorPage ? ((AbstractGraphicalEditorPage)currentPage).getGraphicalViewer() : null));
        }
        if (currentPage instanceof DiagramEditorPage) {
            this.fireDiagramPageChanged((DiagramEditorPage)currentPage);
        }
    }

    private void fireDiagramPageChanged(DiagramEditorPage page) {
        for (IDiagramChangeListener listener : this.diagramChangeListeners) {
            listener.diagramPageChanged(page);
        }
    }

    private void fireDiagramPageOpened(DiagramEditorPage page) {
        for (IDiagramChangeListener listener : this.diagramChangeListeners) {
            listener.diagramPageOpened(page);
        }
    }

    private void fireDiagramPageClosed(DiagramEditorPage page) {
        for (IDiagramChangeListener listener : this.diagramChangeListeners) {
            listener.diagramPageClosed(page);
        }
    }

    @Override
    protected void setInput(IEditorInput input) {
        this.getEditorInputTracker().removeChangeVisitor(this.issueSynchronizer);
        this.getEditorInputTracker().removeChangeVisitor(this.editorChangeTracker);
        this.getEditorInputTracker().addChangeVisitor(this.issueSynchronizer);
        this.getEditorInputTracker().addChangeVisitor(this.editorChangeTracker);
        super.setInput(input);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.updateModel(input);
        super.init(site, input);
        this.createActions();
        this.updateListeners();
    }

    private void updateListeners() {
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener(this.getSelectionListener());
        this.getSharedCommandStack().markSaveLocation();
        this.getSharedCommandStack().addCommandStackEventListener(new CommandStackEventListener(){

            public void stackChanged(CommandStackEvent event) {
                boolean mustValidate;
                boolean bl = mustValidate = (event.getDetail() & 0x38) != 0;
                if (mustValidate) {
                    WorkflowModelEditor.this.validateModel();
                }
            }
        });
        this.getSite().getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                WorkflowModelEditor.this.forceRefresh();
                if (WorkflowModelEditor.this.getSite().getPage().equals(WorkflowModelEditor.this.getSite().getWorkbenchWindow().getActivePage()) && CompareHelper.areEqual((Object)WorkflowModelEditor.this.getSite().getPage().getActiveEditor(), (Object)WorkflowModelEditor.this)) {
                    WorkflowModelEditor.this.checkChanged();
                }
            }
        });
        this.getSite().getWorkbenchWindow().getWorkbench().addWindowListener(new IWindowListener(){

            public void windowActivated(IWorkbenchWindow window) {
                WorkflowModelEditor.this.forceRefresh();
                if (this.equals(WorkflowModelEditor.this.getSite().getWorkbenchWindow().getActivePage())) {
                    WorkflowModelEditor.this.checkChanged();
                }
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
            }

            public void windowOpened(IWorkbenchWindow window) {
            }
        });
    }

    public void updateEditor(IWorkbenchPage workbenchPage) {
        if (this.getSite().getPage().equals(workbenchPage)) {
            this.initializeExtensions();
            if (!this.initialized) {
                this.closePages();
                this.getOutlinePage().setOutlineContents(null);
            } else if (this.diagrams.isEmpty()) {
                this.createPages();
            }
            int i = 0;
            while (i < this.getPageCount()) {
                EditorPart page;
                if (this.getEditor(i) instanceof LicensePage) {
                    page = (LicensePage)this.getEditor(i);
                    page.redraw();
                } else if (this.getEditor(i) instanceof UpgradePage) {
                    page = (UpgradePage)this.getEditor(i);
                    page.redraw();
                } else if (this.initialized) {
                    page = (DiagramEditorPage)this.getEditor(i);
                    Map registry = page.getGraphicalViewer().getEditPartRegistry();
                    for (Object o : registry.values()) {
                        ((EditPart)o).refresh();
                    }
                    WorkflowModelEditorPaletteFactory.updatePalette((DiagramEditorPage)page);
                }
                ++i;
            }
            if (this.initialized && this.checkUpgradeModel()) {
                this.getOutlinePage().initializeOutlineViewer();
            }
            this.validateModel();
        }
    }

    private void initializeExtensions() {
        this.initialized = BpmUiActivator.getDefault().initializeExtensions(Modules.DEVELOPER) == null || BpmUiActivator.getDefault().initializeExtensions(Modules.MODELLING) == null;
    }

    private void forceRefresh() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof FileEditorInput) {
            try {
                IFile file = ((FileEditorInput)editorInput).getFile();
                file.refreshLocal(0, null);
            }
            catch (CoreException coreException) {}
        }
    }

    public void updateModel(IEditorInput input) throws PartInitException {
        try {
            if (BpmUiActivator.getDefault().initializeExtensions(Modules.DEVELOPER) == null || BpmUiActivator.getDefault().initializeExtensions(Modules.MODELLING) == null) {
                if (input instanceof IFileEditorInput) {
                    IFile file = ((IFileEditorInput)input).getFile();
                    this.cwmModel = this.create(file);
                } else if (input instanceof IURIEditorInput) {
                    java.net.URI uri = ((IURIEditorInput)input).getURI();
                    this.cwmModel = this.create(uri);
                }
                if (this.getWorkflowModel() == null) {
                    throw new PartInitException(Diagram_Messages.EX_SpecifiedInputNotValidModel);
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new PartInitException(e.getStatus());
        }
        catch (ClassCastException e) {
            throw new PartInitException(Diagram_Messages.EX_SpecifiedInputNotValidModel, (Throwable)e);
        }
    }

    protected void validateModel() {
        if (this.getWorkflowModel() == null) {
            return;
        }
        VariableContextHelper.getInstance().storeVariables(this.getWorkflowModel(), true);
        if (!PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.autoValidation")) {
            return;
        }
        if (this.validationJob != null) {
            this.validationJob.cancel();
        }
        if (this.initialized) {
            this.validationJob = new ModelValidationJob(this, this.getWorkflowModel(), this.createPerspectiveFilter());
            if (this.validationJob.getModelFile() != null) {
                this.validationJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().markerRule(this.validationJob.getModelFile()));
            } else {
                this.validationJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().markerRule((IResource)ResourcesPlugin.getWorkspace().getRoot()));
            }
            this.validationJob.schedule();
        } else {
            IFile modelFile = ((IFileEditorInput)this.getEditorInput()).getFile();
            try {
                modelFile.deleteMarkers("org.eclipse.stardust.modeling.validation.wfModelValidationMarker", true, 2);
                ValidationMarkerService.getInstance().removeMappings((IResource)modelFile);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private Map<String, String> createPerspectiveFilter() {
        String perspectiveId = DiagramPlugin.getViewAsPerspectiveId(this);
        return perspectiveId == null ? Collections.emptyMap() : Collections.singletonMap("perspectiveType", perspectiveId);
    }

    protected ModelType create(IFile file) throws CoreException {
        ModelType model = null;
        this.modelManager = this.createModelManager();
        if (file.exists()) {
            try {
                this.modelManager.load(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false));
            }
            catch (Exception e) {
                throw new PartInitException(Diagram_Messages.EX_FailedLoadingModel, (Throwable)e);
            }
            model = this.modelManager.getModel();
            if (model == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.core", 0, Diagram_Messages.EX_ErrorLoadingNetwork, null));
            }
            this.fixSymbols(model);
        }
        this.variableContextHelper.storeVariables(model, false);
        return model;
    }

    protected ExtendedModelManager createModelManager() {
        return new ExtendedModelManager();
    }

    protected ModelType create(java.net.URI uri) throws CoreException {
        ModelType model = null;
        this.modelManager = this.createModelManager();
        try {
            this.modelManager.load(URI.createURI((String)uri.toString()));
        }
        catch (Exception e) {
            throw new PartInitException(Diagram_Messages.EX_FailedLoadingModel, (Throwable)e);
        }
        model = this.modelManager.getModel();
        if (model == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.stardust.modeling.core", 0, Diagram_Messages.EX_ErrorLoadingNetwork, null));
        }
        this.fixSymbols(model);
        return model;
    }

    private void fixSymbols(ModelType model) {
        WorkflowModelEditor.fixSymbols((List<DiagramType>)model.getDiagram());
        EList processes = model.getProcessDefinition();
        for (ProcessDefinitionType process : processes) {
            WorkflowModelEditor.fixSymbols((List<DiagramType>)process.getDiagram());
        }
    }

    private static void fixSymbols(List<DiagramType> diagrams) {
        for (DiagramType diagram : diagrams) {
            List toDelete = CollectionUtils.newList();
            TreeIterator contents = diagram.eAllContents();
            while (contents.hasNext()) {
                IModelElementNodeSymbol symbol;
                EObject object = (EObject)contents.next();
                if (!(object instanceof IModelElementNodeSymbol) || (symbol = (IModelElementNodeSymbol)object).getModelElement() != null || symbol instanceof StartEventSymbol || symbol instanceof EndEventSymbol || symbol instanceof IntermediateEventSymbol || symbol instanceof PublicInterfaceSymbol) continue;
                toDelete.add(symbol);
            }
            for (IModelElementNodeSymbol symbol : toDelete) {
                DeleteSymbolCommandFactory.createDeleteSymbolCommand((INodeSymbol)symbol).execute();
            }
        }
    }

    private void save(IFile file, IProgressMonitor progressMonitor) throws CoreException {
        this.getEditorInputTracker().removeChangeVisitor(this.editorChangeTracker);
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        progressMonitor.beginTask(String.valueOf(Diagram_Messages.TASKNAME_Saving) + file, 3);
        if (this.modelManager == null) {
            Status status = new Status(4, "org.eclipse.stardust.modeling.core", 0, Diagram_Messages.ERR_NoModelManagerFound, null);
            throw new CoreException((IStatus)status);
        }
        try {
            try {
                this.variableContextHelper.storeVariables(this.getWorkflowModel(), true);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)this.getWorkflowModel(), (String)"stardust:security:hash");
            if (attribute != null) {
                this.getWorkflowModel().getAttribute().remove((Object)attribute);
            }
            this.modelManager.save(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false));
            progressMonitor.worked(1);
            progressMonitor.worked(1);
            file.refreshLocal(0, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            progressMonitor.done();
        }
        catch (FileNotFoundException e) {
            Status status = new Status(4, "org.eclipse.stardust.modeling.core", 0, Diagram_Messages.ERR_writingFile, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.stardust.modeling.core", 0, Diagram_Messages.ERR_writingFile, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        this.getEditorInputTracker().addChangeVisitor(this.editorChangeTracker);
    }

    @Override
    public EditPart findEditPart(Object model) {
        Map registry;
        DiagramType diagram = this.getDiagram(model);
        if (diagram != null && this.diagrams.contains(diagram)) {
            int pageNumber = this.diagrams.indexOf(diagram);
            DiagramEditorPage page = (DiagramEditorPage)this.getEditor(pageNumber);
            registry = page.getGraphicalViewer().getEditPartRegistry();
        } else {
            WorkflowModelOutlinePage outline = (WorkflowModelOutlinePage)this.getOutlinePage();
            registry = outline.getViewer().getEditPartRegistry();
        }
        return (EditPart)registry.get(model);
    }

    private DiagramType getDiagram(Object model) {
        if (model instanceof DiagramType) {
            return (DiagramType)model;
        }
        if (model instanceof IGraphicalObject) {
            return ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)model));
        }
        return null;
    }

    public boolean hasDiagramPage(DiagramType diagram) {
        return this.diagrams.contains(diagram);
    }

    protected void closePages() {
        while (!this.diagrams.isEmpty()) {
            DiagramType diagram = this.diagrams.get(0);
            this.closeDiagramPage(diagram);
        }
    }

    public void closeDiagramPage(DiagramType diagram) {
        NotificationAdaptee adaptee = this.findAdaptee(diagram);
        if (adaptee != null) {
            if (diagram.eContainer() != null) {
                diagram.eContainer().eAdapters().remove((Object)this.adapters.get(adaptee));
            }
            this.adapters.remove(adaptee);
        }
        int pageId = this.diagrams.indexOf(diagram);
        this.diagrams.remove(diagram);
        if (pageId >= 0) {
            DiagramEditorPage page = (DiagramEditorPage)this.getEditor(pageId);
            for (IDecorationProvider decoration : this.decorations.values()) {
                DecorationUtils.removeDecoration(decoration, page.getGraphicalViewer().getRootEditPart().getChildren());
            }
            this.removePage(pageId);
            this.currentPageChanged();
        }
        this.checkShowLicensePage();
        this.variableContextHelper.removeContext(this.getWorkflowModel());
    }

    public void removePage(int pageIndex) {
        IEditorPart editor = this.getEditor(pageIndex);
        super.removePage(pageIndex);
        if (editor instanceof DiagramEditorPage) {
            this.fireDiagramPageClosed((DiagramEditorPage)editor);
        }
    }

    private void checkShowLicensePage() {
        if (this.getPageCount() == 0) {
            LicensePage page = new LicensePage(this);
            try {
                int pageId = this.addPage((IEditorPart)page, this.getEditorInput());
                this.setPageText(pageId, page.getPageName());
                this.setActivePage(pageId);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        } else if (!this.diagrams.isEmpty()) {
            this.removeLicensePage();
        }
    }

    private void removeLicensePage() {
        int i = this.getPageCount() - 1;
        while (i >= 0) {
            IEditorPart page = this.getEditor(i);
            if (page instanceof LicensePage) {
                this.removePage(i);
            }
            --i;
        }
    }

    private NotificationAdaptee findAdaptee(DiagramType diagram) {
        for (NotificationAdaptee adaptee : this.adapters.keySet()) {
            if (adaptee.getModel() != diagram) continue;
            return adaptee;
        }
        return null;
    }

    public boolean isActiveDiagram(DiagramType diagram) {
        return this.getActivePage() >= 0 && this.getActivePage() == this.diagrams.indexOf(diagram);
    }

    public void gotoMarker(IMarker marker) {
        EObject element = null;
        try {
            element = (EObject)marker.getAttribute("markerModelElement");
        }
        catch (CoreException coreException) {}
        if (element != null) {
            this.selectElement(element);
            ShowPropertiesAction showPropertiesAction = new ShowPropertiesAction(this, this.outlinePage.getSite().getSelectionProvider());
            showPropertiesAction.run();
        }
    }

    @Override
    public boolean hasDecoration(IDecorationProvider decoration) {
        return this.decorations.containsKey(decoration.getId());
    }

    @Override
    public void enableDecoration(IDecorationProvider decoration) {
        if (!this.hasDecoration(decoration)) {
            this.decorations.put(decoration.getId(), decoration);
            int i = 0;
            while (i < this.getPageCount()) {
                DiagramEditorPage page = (DiagramEditorPage)this.getEditor(i);
                DecorationUtils.applyDecoration(decoration, page.getGraphicalViewer().getRootEditPart().getChildren());
                ++i;
            }
        }
    }

    @Override
    public void disableDecoration(IDecorationProvider decoration) {
        if (this.hasDecoration(decoration)) {
            int i = 0;
            while (i < this.getPageCount()) {
                DiagramEditorPage page = (DiagramEditorPage)this.getEditor(i);
                DecorationUtils.removeDecoration(decoration, page.getGraphicalViewer().getRootEditPart().getChildren());
                ++i;
            }
            this.decorations.remove(decoration.getId());
        }
    }

    public void selectElement(EObject element) {
        this.outlinePage.selectElement(element);
        INodeSymbol symbol = this.getElementSymbol(element);
        if (symbol != null) {
            this.selectSymbol(symbol);
        }
    }

    public void selectSymbols(List<?> symbols, DiagramType diagram) {
        if (!this.isActiveDiagram(diagram)) {
            try {
                this.showDiagramPage(diagram);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        List editParts = CollectionUtils.newList();
        for (Object symbol : symbols) {
            EditPart editPart = this.findEditPart(symbol);
            editParts.add(editPart);
        }
        this.getEditorSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection(editParts));
    }

    public void selectSymbol(INodeSymbol symbol) {
        EditPart editPart;
        DiagramType diagram = this.getDiagram(symbol);
        if (!this.isActiveDiagram(diagram)) {
            try {
                this.showDiagramPage(diagram);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        if ((editPart = this.findEditPart(symbol)) != null) {
            this.getEditorSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)editPart));
            editPart.getParent().getViewer().reveal(editPart);
        }
    }

    public INodeSymbol getElementSymbol(EObject element) {
        EList diagrams = null;
        if (element instanceof ProcessDefinitionType) {
            diagrams = ((ProcessDefinitionType)element).getDiagram();
        } else if (ModelUtils.findContainingProcess((EObject)element) != null) {
            diagrams = ModelUtils.findContainingProcess((EObject)element).getDiagram();
        } else {
            return null;
        }
        for (DiagramType diagram : diagrams) {
            List nodeContainingFeatures = diagram.getNodeContainingFeatures();
            for (EStructuralFeature feature : nodeContainingFeatures) {
                List nodeSymbolList = (List)diagram.eGet(feature);
                for (INodeSymbol nodeSymbol : nodeSymbolList) {
                    IIdentifiableModelElement nodeSymbolModelElement;
                    if (!(nodeSymbol instanceof IModelElementNodeSymbol) || (nodeSymbolModelElement = ((IModelElementNodeSymbol)nodeSymbol).getModelElement()) == null || !nodeSymbolModelElement.equals(element)) continue;
                    return nodeSymbol;
                }
            }
        }
        return null;
    }

    public void selectInOutline(EObject element) {
        this.outlinePage.selectElement(element);
    }

    public void setFocus() {
        try {
            super.setFocus();
        }
        catch (SWTException sWTException) {}
        this.forceRefresh();
        this.checkChanged();
    }

    protected void checkChanged() {
        if (this.getCurrentPage() != null) {
            if (this.getCurrentPage() instanceof DiagramEditorPage) {
                this.setPageText(this.getActivePage(), ((DiagramEditorPage)this.getCurrentPage()).getPageName());
                ((DiagramEditorPage)this.getCurrentPage()).updateTitle(((DiagramEditorPage)this.getCurrentPage()).getEditorInput());
            }
            boolean action = this.changed;
            this.changed = false;
            if (action && MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)Diagram_Messages.LB_Changed, (String)Diagram_Messages.MSG_ResourceChanged)) {
                this.reloadModel();
            }
        }
    }

    public void reloadModel() {
        Display display = this.getSite().getShell().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                WorkflowModelEditor.this.initializeExtensions();
                WorkflowModelEditor.this.closePages();
                WorkflowModelEditor.this.setInput(WorkflowModelEditor.this.getEditorInput());
                try {
                    WorkflowModelEditor.this.updateModel(WorkflowModelEditor.this.getEditorInput());
                }
                catch (PartInitException partInitException) {}
                WorkflowModelEditor.this.upgradeChecked = null;
                WorkflowModelEditor.this.createPages();
                WorkflowModelEditor.this.getOutlinePage().initializeOutlineViewer();
                WorkflowModelEditor.this.validateModel();
            }
        });
    }

    public void refreshDiagramPages() {
        int i = 0;
        while (i < this.getPageCount()) {
            DiagramEditorPage diagramPage = (DiagramEditorPage)this.getEditor(i);
            diagramPage.getGraphicalViewer().setContents((Object)diagramPage.getDiagram());
            ++i;
        }
    }

    public ValidationIssueManager getIssueManager() {
        return this.validationIssueManager;
    }

    public ConnectionManager getConnectionManager() {
        return this.modelManager instanceof ExtendedModelManager ? ((ExtendedModelManager)this.modelManager).getConnectionManager() : null;
    }

    public void doUpgradeModel() {
        this.upgradeChecked = Boolean.TRUE;
        Command upgradeModelAndDiagramCmd = new UpgradeModelAndDiagramAction(this).createUpgradeModelAndDiagramCmd();
        if (upgradeModelAndDiagramCmd.canExecute()) {
            this.getEditDomain().getCommandStack().execute(upgradeModelAndDiagramCmd);
        }
        this.createPages();
        this.getOutlinePage().initializeOutlineViewer();
    }

    public DiagramEditorPage[] getEditors() {
        ArrayList<DiagramEditorPage> editors = new ArrayList<DiagramEditorPage>();
        int i = 0;
        while (i < this.getPageCount()) {
            IEditorPart editor = this.getEditor(i);
            if (editor instanceof DiagramEditorPage) {
                editors.add((DiagramEditorPage)editor);
            }
            ++i;
        }
        return editors.toArray(new DiagramEditorPage[editors.size()]);
    }

    public class EditorChangeTracker
    implements IResourceDeltaVisitor {
        public boolean isEnabled = true;

        public void setEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        public boolean visit(IResourceDelta delta) {
            if (!this.isEnabled) {
                return false;
            }
            if (delta.getKind() == 4 && (delta.getFlags() & 0x50100) != 0) {
                if ((delta.getFlags() & 0x10000) != 0) {
                    if (delta.getAffectedChildren(4).length > 0) {
                        WorkflowModelEditor.this.changed = true;
                    }
                } else {
                    WorkflowModelEditor.this.changed = true;
                }
            }
            return false;
        }
    }
}

