/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PrinterGraphics;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.modeling.core.editors.figures.AbstractConnectionSymbolFigure;
import org.eclipse.stardust.modeling.core.editors.figures.ForkOnTraversalDecoration;
import org.eclipse.stardust.modeling.core.editors.figures.SequenceFlowArrowhead;
import org.eclipse.stardust.modeling.core.utils.TransitionConnectionUtils;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.PlatformUI;

public class TransitionConnectionFigure
extends AbstractConnectionSymbolFigure
implements IPropertyChangeListener {
    private Shape rect;
    private Label label;
    private static final boolean SHOW_BORDER = false;
    private static final boolean ROUNDED = false;
    private static final boolean USE_TOOLTIP = true;
    private static final boolean USE_TOOLTIP_COLORS = true;
    private static final int[][] MODIFIERS;
    public static final Color FG_COLOR;
    private int antialiasMode = 1;
    private Point startPoint;
    private Point endPoint;
    private String transitionLabel;
    private TransitionConnectionType transition;

    static {
        int[][] nArrayArray = new int[9][];
        nArrayArray[0] = new int[7];
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[6] = 90;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 1;
        nArray2[2] = -1;
        nArray2[4] = -2;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[7];
        nArray3[1] = -1;
        nArray3[2] = 1;
        nArray3[5] = -2;
        nArray3[6] = 180;
        nArrayArray[3] = nArray3;
        int[] nArray4 = new int[7];
        nArray4[1] = -1;
        nArray4[2] = -1;
        nArray4[4] = -2;
        nArray4[5] = -2;
        nArray4[6] = 270;
        nArrayArray[4] = nArray4;
        int[] nArray5 = new int[7];
        nArray5[0] = 1;
        nArray5[3] = 1;
        nArray5[6] = 90;
        nArrayArray[5] = nArray5;
        int[] nArray6 = new int[7];
        nArray6[0] = -1;
        nArray6[3] = 1;
        nArray6[4] = -2;
        nArrayArray[6] = nArray6;
        int[] nArray7 = new int[7];
        nArray7[0] = 1;
        nArray7[3] = -1;
        nArray7[5] = -2;
        nArray7[6] = 180;
        nArrayArray[7] = nArray7;
        int[] nArray8 = new int[7];
        nArray8[0] = -1;
        nArray8[3] = -1;
        nArray8[4] = -2;
        nArray8[5] = -2;
        nArray8[6] = 270;
        nArrayArray[8] = nArray8;
        MODIFIERS = nArrayArray;
        FG_COLOR = new Color(null, 0, 102, 121);
    }

    public TransitionConnectionFigure(TransitionConnectionType transition) {
        this.transition = transition;
        this.setDefaultBorderColor(FG_COLOR);
        this.setDefaultFillColor(FG_COLOR);
        this.setDefaultRouting(-2);
        if (TransitionConnectionUtils.showForkOnTraversal(transition)) {
            this.setSourceDecoration(new ForkOnTraversalDecoration());
        } else {
            this.setSourceDecoration(null);
        }
        this.setTargetDecoration((RotatableDecoration)new SequenceFlowArrowhead());
        this.getTargetDecoration().setForegroundColor(FG_COLOR);
        this.getTargetDecoration().setBackgroundColor(FG_COLOR);
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void finalize() throws Throwable {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        store.removePropertyChangeListener((IPropertyChangeListener)this);
        super.finalize();
    }

    public RotatableDecoration getTargetDecoration() {
        return super.getTargetDecoration();
    }

    public void setLabel(final String text) {
        int preferredWidth;
        this.transitionLabel = text;
        int n = preferredWidth = this.startPoint != null && this.endPoint != null && Math.abs(this.startPoint.x - this.endPoint.x) < 200 && Math.abs(this.startPoint.y - this.endPoint.y) < 60 ? Math.abs(this.startPoint.x - this.endPoint.x) - 20 : 200;
        if (text == null || text.length() == 0) {
            if (this.label != null) {
                this.remove((IFigure)this.rect);
                this.rect.remove((IFigure)this.label);
                this.label = null;
                this.rect = null;
            }
        } else {
            if (this.label == null) {
                this.rect = new RectangleFigure(){

                    public Dimension getPreferredSize(int wHint, int hHint) {
                        return super.getPreferredSize(wHint == -1 ? 200 : wHint, hHint);
                    }
                };
                this.rect.setOutline(false);
                this.label = new Label(text){
                    private Dimension longestText;

                    public String getSubStringText() {
                        String[] splitText = text.split("\n");
                        String newText = new String();
                        int i = 0;
                        while (i < splitText.length) {
                            newText = String.valueOf(newText) + this.getSubStringText(splitText[i]) + "\n";
                            ++i;
                        }
                        return newText;
                    }

                    public String getSubStringText(String segment) {
                        String subStringText = segment;
                        Dimension textLength = this.getTextUtilities().getTextExtents(segment, this.getFont());
                        int widthShrink = textLength.width - this.getSize().width;
                        if (widthShrink <= 0) {
                            return subStringText;
                        }
                        Dimension effectiveSize = textLength.getExpanded(-widthShrink, 0);
                        Font currentFont = this.getFont();
                        int dotsWidth = this.getTextUtilities().getTextExtents((String)this.getTruncationString(), (Font)currentFont).width;
                        if (effectiveSize.width < dotsWidth) {
                            effectiveSize.width = dotsWidth;
                        }
                        int subStringLength = this.getTextUtilities().getLargestSubstringConfinedTo(segment, currentFont, effectiveSize.width - dotsWidth);
                        subStringText = new String(String.valueOf(segment.substring(0, subStringLength)) + this.getTruncationString());
                        return subStringText;
                    }
                };
                if (this.label.getFont() == null) {
                    this.label.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.dialogfont"));
                }
                this.label.setToolTip((IFigure)new Label(text));
                this.label.setBorder((Border)new MarginBorder(0, 5, 3, 5));
                this.rect.setBackgroundColor(ColorConstants.listBackground);
                this.rect.setLayoutManager((LayoutManager)new BorderLayout());
                this.rect.add((IFigure)this.label, (Object)BorderLayout.CENTER);
                this.add((IFigure)this.rect, new ConnectionLocator((Connection)this){
                    private final PointList plOverride;
                    private final Point p0;
                    private final Point p1;
                    private final Point p2;
                    {
                        this.plOverride = new PointList(2);
                        this.p0 = new Point();
                        this.p1 = new Point();
                        this.p2 = new Point();
                    }

                    protected Point getLocation(PointList points) {
                        PointList pl;
                        if (2 < points.size()) {
                            this.plOverride.removeAllPoints();
                            points.getPoint(this.p0, 0);
                            points.getPoint(this.p1, 1);
                            points.getPoint(this.p2, 2);
                            if (this.p1.x - this.p0.x == 0) {
                                this.plOverride.addPoint(this.p0);
                                this.plOverride.addPoint(this.p1);
                            } else if (this.p2.x - this.p1.x == 0) {
                                this.plOverride.addPoint(this.p1);
                                this.plOverride.addPoint(this.p2);
                            } else {
                                this.plOverride.addPoint(this.p0);
                                this.plOverride.addPoint(this.p1);
                            }
                            pl = this.plOverride;
                        } else {
                            pl = points;
                        }
                        return super.getLocation(pl);
                    }
                });
            } else if (!text.equals(this.label.getText())) {
                this.label.setText(text);
                this.label.setToolTip((IFigure)new Label(text));
            }
            if (preferredWidth < 200) {
                this.rect.setSize(preferredWidth, this.rect.getPreferredSize().height);
                this.rect.setLocation(new Point(this.startPoint.x + 5, this.rect.getLocation().y));
            }
        }
    }

    protected void outlineShape(Graphics g) {
        int DEFAULT_RADIUS = 5;
        boolean printing = g instanceof PrinterGraphics;
        int[] sourceModifiers = MODIFIERS[0];
        PointList points = this.getPoints();
        if (points.size() > 2) {
            Point start = new Point();
            Point middle = new Point();
            Point end = new Point();
            int lastRadius = 0;
            g.pushState();
            try {
                int i = 0;
                while (i < points.size() - 1) {
                    points.getPoint(start, i);
                    points.getPoint(middle, i + 1);
                    points.getPoint(end, Math.min(i + 2, points.size() - 1));
                    if (!start.equals((Object)middle)) {
                        int radius;
                        int[] targetModifiers = MODIFIERS[0];
                        if (start.x == middle.x) {
                            radius = Math.min(DEFAULT_RADIUS, Math.abs(end.x - middle.x) / 2);
                            radius = Math.min(radius, Math.abs(middle.y - start.y) / 2);
                            if (start.y > middle.y) {
                                if (middle.x < end.x) {
                                    targetModifiers = MODIFIERS[1];
                                } else if (middle.x > end.x) {
                                    targetModifiers = MODIFIERS[2];
                                }
                            } else if (start.y < middle.y) {
                                if (middle.x < end.x) {
                                    targetModifiers = MODIFIERS[3];
                                } else if (middle.x > end.x) {
                                    targetModifiers = MODIFIERS[4];
                                }
                            }
                        } else if (start.y == middle.y) {
                            radius = Math.min(DEFAULT_RADIUS, Math.abs(end.y - middle.y) / 2);
                            radius = Math.min(radius, Math.abs(middle.x - start.x) / 2);
                            if (middle.y < end.y) {
                                if (start.x > middle.x) {
                                    targetModifiers = MODIFIERS[5];
                                } else if (start.x < middle.x) {
                                    targetModifiers = MODIFIERS[6];
                                }
                            } else if (middle.y > end.y) {
                                if (start.x > middle.x) {
                                    targetModifiers = MODIFIERS[7];
                                } else if (start.x < middle.x) {
                                    targetModifiers = MODIFIERS[8];
                                }
                            }
                        } else {
                            radius = 0;
                        }
                        boolean retry = false;
                        do {
                            try {
                                if (!printing) {
                                    g.setAntialias(this.antialiasMode);
                                }
                                g.drawLine(start.x + lastRadius * sourceModifiers[2], start.y + lastRadius * sourceModifiers[3], middle.x + radius * targetModifiers[0], middle.y + radius * targetModifiers[1]);
                                if (targetModifiers[0] != 0 || targetModifiers[1] != 0) {
                                    g.drawArc(middle.x + radius * targetModifiers[4], middle.y + radius * targetModifiers[5], 2 * radius, 2 * radius, targetModifiers[6], 90);
                                }
                                retry = false;
                            }
                            catch (SWTException e) {
                                if (!printing && 1 == this.antialiasMode) {
                                    this.antialiasMode = 1 == this.antialiasMode ? -1 : 0;
                                    retry = true;
                                }
                                if (retry) continue;
                                throw e;
                            }
                        } while (retry);
                        sourceModifiers = targetModifiers;
                        lastRadius = radius;
                    }
                    ++i;
                }
            }
            finally {
                g.popState();
            }
        } else {
            super.outlineShape(g);
        }
    }

    public void layout() {
        super.layout();
        if (this.getConnectionRouter() != null) {
            Point startConnectionPoint = TransitionConnectionFigure.getStartPoint((Connection)this);
            Point endConnectionPoint = TransitionConnectionFigure.getEndPoint((Connection)this);
            if (startConnectionPoint != null && endConnectionPoint != null) {
                this.startPoint = startConnectionPoint;
                this.endPoint = endConnectionPoint;
                this.setLabel(this.transitionLabel);
            }
        }
        this.updateForkOnTraversal(null);
    }

    private static Point getEndPoint(Connection connection) {
        Point ref = connection.getSourceAnchor().getReferencePoint();
        return connection.getTargetAnchor().getLocation(ref).getCopy();
    }

    private static Point getStartPoint(Connection conn) {
        Point ref = conn.getTargetAnchor().getReferencePoint();
        return conn.getSourceAnchor().getLocation(ref).getCopy();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.stardust.modeling.common.projectnature.viewForkOnTraversalMode")) {
            this.updateForkOnTraversal(null);
        }
    }

    public void updateForkOnTraversal(Boolean show) {
        boolean showForkOnTraversal = show == null ? TransitionConnectionUtils.showForkOnTraversal(this.transition) : show;
        if (showForkOnTraversal && this.getSourceDecoration() == null) {
            this.setSourceDecoration(new ForkOnTraversalDecoration());
        } else if (!showForkOnTraversal && this.getSourceDecoration() != null) {
            this.setSourceDecoration(null);
        }
    }
}

