/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrientationType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateModelElementCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.properties.ActivityCommandFactory;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class CreateSubprocessAction
extends SelectionAction {
    private ActivityType activity;

    public CreateSubprocessAction(WorkflowModelEditor part) {
        super((IWorkbenchPart)part);
        this.setId("org.eclipse.stardust.modeling.core.createSubprocessDefinition");
        this.setText(Diagram_Messages.CreateSubprocessAction_LB_NewSubprocess);
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor("icons/full/obj16/process.gif"));
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        DiagramType[] newDiagram = new DiagramType[1];
        this.execute((Command)this.createCommand(newDiagram));
        if (this.getWorkbenchPart() instanceof WorkflowModelEditor) {
            try {
                ((WorkflowModelEditor)this.getWorkbenchPart()).showDiagramPage(newDiagram[0]);
            }
            catch (PartInitException partInitException) {}
        }
    }

    private CompoundCommand createCommand(final DiagramType[] newDiagram) {
        final CompoundCommand compoundCommand = new CompoundCommand();
        IdFactory id = new IdFactory(Diagram_Messages.ID_ProcessDefinition, Diagram_Messages.BASENAME_ProcessDefinition);
        CreateModelElementCommand command = new CreateModelElementCommand(2, id, CarnotWorkflowModelPackage.eINSTANCE.getProcessDefinitionType()){

            @Override
            protected IModelElement createModelElement() {
                ProcessDefinitionType process = (ProcessDefinitionType)super.createModelElement();
                DiagramType diagram = CarnotWorkflowModelFactory.eINSTANCE.createDiagramType();
                diagram.setName(Diagram_Messages.DIAGRAM_NAME_Default);
                diagram.setOrientation(OrientationType.VERTICAL_LITERAL.toString().equals(PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnature.modelingDirection")) ? OrientationType.VERTICAL_LITERAL : OrientationType.HORIZONTAL_LITERAL);
                process.getDiagram().add((Object)diagram);
                newDiagram[0] = diagram;
                PoolSymbol pool = DiagramUtil.createDefaultPool(null);
                diagram.getPoolSymbols().add((Object)pool);
                compoundCommand.add(ActivityCommandFactory.getSetSubprocessCommand(CreateSubprocessAction.this.activity, process));
                if (PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.autoSubprocessNameGeneration")) {
                    compoundCommand.add((Command)new SetValueCmd((EObject)CreateSubprocessAction.this.activity, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Name(), (Object)process.getName()));
                }
                return process;
            }
        };
        command.setParent((EObject)this.getModel());
        compoundCommand.add((Command)command);
        return compoundCommand;
    }

    public void setActivity(ActivityType activity) {
        this.activity = activity;
    }

    protected ModelType getModel() {
        return ModelUtils.findContainingModel((EObject)this.activity);
    }
}

