/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.OrientationType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DiagramCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetSymbolContainerCommand;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class CreateSymbolCommand
extends DiagramCommand {
    private SetSymbolContainerCommand symContainerCmd;
    private EditPart targetEditPart;
    private Object transferElement;

    public CreateSymbolCommand(int parentLevel, IdFactory id, EClass eClass) {
        super(parentLevel, id, eClass);
    }

    @Override
    public boolean canExecute() {
        if (this.getEClass().getName().equalsIgnoreCase("PublicInterfaceSymbol")) {
            if (this.getProcess().getFormalParameters() == null) {
                return this.getContainingFeature() != null;
            }
            return false;
        }
        return super.canExecute();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    protected IModelElement createModelElement() {
        IGraphicalObject symbol = (IGraphicalObject)super.createModelElement();
        DiagramType diagram = null;
        diagram = this.getParent() instanceof DiagramType ? (DiagramType)this.getParent() : ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)this.getParent()));
        OrientationType direction = diagram.getOrientation();
        if (symbol instanceof IModelElementNodeSymbol && this.getIdFactory().getReferingElement() != null) {
            ((IModelElementNodeSymbol)symbol).setModelElement(this.getIdFactory().getReferingElement());
        }
        if (symbol instanceof INodeSymbol && this.location != null) {
            IWorkbenchPage page;
            Rectangle containerBounds = null;
            EObject parent = this.getParent();
            boolean createDefaultLane = false;
            AbstractSwimlaneEditPart abstractSwimlaneEP = null;
            if (parent instanceof ISwimlaneSymbol && (page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null) {
                IEditorPart editorPart = page.getActiveEditor();
                if (editorPart instanceof WorkflowModelEditor) {
                    WorkflowModelEditor editor = (WorkflowModelEditor)editorPart;
                    abstractSwimlaneEP = (AbstractSwimlaneEditPart)editor.findEditPart(parent);
                }
                if (abstractSwimlaneEP != null) {
                    containerBounds = GenericUtils.getSymbolRectangle(abstractSwimlaneEP);
                }
            }
            if (symbol instanceof LaneSymbol && containerBounds != null && !(this.getParent() instanceof DiagramType) && diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL) && (!PoolLaneUtils.containsLanes(abstractSwimlaneEP) || PoolLaneUtils.containsOthers(abstractSwimlaneEP))) {
                createDefaultLane = true;
            }
            if (diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL) && symbol instanceof LaneSymbol) {
                ((INodeSymbol)symbol).setXPos((long)this.location.x);
                ((INodeSymbol)symbol).setYPos((long)this.location.y);
                if (createDefaultLane) {
                    ((INodeSymbol)symbol).setWidth(containerBounds.width);
                    ((INodeSymbol)symbol).setHeight(containerBounds.height);
                } else if (abstractSwimlaneEP != null) {
                    LaneEditPart firstLaneEP = (LaneEditPart)abstractSwimlaneEP.getChildren().get(0);
                    Rectangle firstLaneBounds = GenericUtils.getSymbolRectangle((EditPart)firstLaneEP);
                    if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                        ((INodeSymbol)symbol).setHeight(firstLaneBounds.height);
                    } else {
                        ((INodeSymbol)symbol).setWidth(firstLaneBounds.width);
                    }
                }
            } else {
                ISymbolContainer container = (ISymbolContainer)this.getContainer();
                boolean vertical = container instanceof DiagramType ? DiagramPlugin.isVerticalModelling((DiagramType)container) : DiagramPlugin.isVerticalModelling((IGraphicalObject)container);
                ((INodeSymbol)symbol).setXPos((long)(symbol instanceof ISwimlaneSymbol && !vertical ? 0 : this.location.x));
                ((INodeSymbol)symbol).setYPos((long)(symbol instanceof ISwimlaneSymbol && vertical ? 0 : this.location.y));
                ((INodeSymbol)symbol).setWidth(symbol instanceof GatewaySymbol ? this.location.width : -1);
                ((INodeSymbol)symbol).setHeight(symbol instanceof GatewaySymbol ? this.location.height : -1);
            }
        }
        return symbol;
    }

    @Override
    public void undo() {
        if (this.getModelElement() instanceof LaneSymbol) {
            LaneSymbol lane = (LaneSymbol)this.getModelElement();
            lane.setParentLane(null);
            lane.setParentPool(null);
        }
        this.symContainerCmd.undo();
        if (this.transferElement != null && this.transferElement instanceof IIdentifiableModelElement) {
            EList symbols = ((IIdentifiableModelElement)this.transferElement).getSymbols();
            symbols.remove((Object)this.getModelElement());
        }
    }

    public void setTargetEditPart(EditPart targetEditPart) {
        this.targetEditPart = targetEditPart;
    }

    public void setTransferElement(Object transferElement) {
        this.transferElement = transferElement;
    }

    @Override
    public void redo() {
        EList symbols;
        if (this.symContainerCmd == null) {
            this.symContainerCmd = new SetSymbolContainerCommand();
            this.symContainerCmd.setContainer((ISymbolContainer)this.getContainer(), this.targetEditPart);
            this.symContainerCmd.setSymbol((IGraphicalObject)this.getModelElement());
            this.symContainerCmd.execute();
        } else {
            this.symContainerCmd.redo();
        }
        if (this.getModelElement() instanceof LaneSymbol) {
            LaneSymbol lane = (LaneSymbol)this.getModelElement();
            lane.setParentLane((ISwimlaneSymbol)this.getParent());
            lane.setParentPool(this.getPool());
        }
        if (this.transferElement != null && this.transferElement instanceof IIdentifiableModelElement && !(symbols = ((IIdentifiableModelElement)this.transferElement).getSymbols()).contains((Object)this.getModelElement())) {
            symbols.add((Object)this.getModelElement());
        }
    }

    @Override
    protected List getContainingFeatureList() {
        return ((ISymbolContainer)this.getContainer()).getNodeContainingFeatures();
    }
}

