/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;

public class MoveNodeSymbolCommand
extends Command {
    private INodeSymbol target;
    private Point oldPosition;
    private Integer oldWidth;
    private Integer oldHeight;
    private Point newPosition;
    private Integer newWidth;
    private Integer newHeight;
    private boolean executed = false;

    public void setPart(INodeSymbol target) {
        this.target = target;
    }

    public void setBounds(Rectangle r) {
        if (r != null) {
            this.setLocation(r.getLocation());
            this.setSize(r.getSize());
        } else {
            this.setLocation(null);
            this.setSize(null);
        }
    }

    public void setLocation(Point p) {
        this.newPosition = p;
    }

    public void setSize(Dimension d) {
        if (d != null) {
            this.newWidth = new Integer(d.width);
            this.newHeight = new Integer(d.height);
        } else {
            this.newWidth = null;
            this.newHeight = null;
        }
    }

    public void setWidth(int width) {
        this.newWidth = new Integer(width);
    }

    public void setHeight(int height) {
        this.newHeight = new Integer(height);
    }

    public void execute() {
        this.executed = true;
        this.oldPosition = new Point((double)this.target.getXPos(), (double)this.target.getYPos());
        this.oldWidth = this.target.isSetWidth() ? new Integer(this.target.getWidth()) : null;
        this.oldHeight = this.target.isSetHeight() ? new Integer(this.target.getHeight()) : null;
        this.newWidth = this.newWidth == null ? this.oldWidth : this.newWidth;
        this.newHeight = this.newHeight == null ? this.oldHeight : this.newHeight;
        this.redo();
    }

    public void redo() {
        if (this.executed) {
            this.setTargetPosition(this.newPosition);
            this.setTargetSize(this.newWidth, this.newHeight);
        }
    }

    public void undo() {
        if (this.executed) {
            this.setTargetSize(this.oldWidth, this.oldHeight);
            this.setTargetPosition(this.oldPosition);
        }
    }

    private void setTargetPosition(Point point) {
        long xPos = 0L;
        long yPos = 0L;
        if (point != null) {
            xPos = point.x;
            yPos = point.y;
        }
        this.target.setXPos(xPos);
        this.target.setYPos(yPos);
    }

    private void setTargetSize(Integer width, Integer height) {
        if (width != null) {
            this.target.setWidth(width.intValue());
        } else {
            this.target.unsetWidth();
        }
        if (height != null) {
            this.target.setHeight(height.intValue());
        } else {
            this.target.unsetHeight();
        }
    }
}

